/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request.resources;

import java.io.IOException;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;

public class FluidResource
implements IResource {
    private final FluidIdentifier liquid;
    private int amount;
    private final IRequestFluid target;
    private Object ccObject;

    public FluidResource(FluidIdentifier liquid, int amount, IRequestFluid target) {
        this.liquid = liquid;
        this.amount = amount;
        this.target = target;
    }

    public FluidResource(LPDataInputStream data) throws IOException {
        this.liquid = FluidIdentifier.get(data.readItemIdentifier());
        this.amount = data.readInt();
        this.target = null;
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeItemIdentifier(this.liquid.getItemIdentifier());
        data.writeInt(this.amount);
    }

    @Override
    public int getRequestedAmount() {
        return this.amount;
    }

    public FluidIdentifier getFluid() {
        return this.liquid;
    }

    public IRequestFluid getTarget() {
        return this.target;
    }

    @Override
    public IRouter getRouter() {
        return this.target.getRouter();
    }

    @Override
    public boolean matches(ItemIdentifier itemType) {
        if (itemType.isFluidContainer()) {
            FluidIdentifier other = FluidIdentifier.get(itemType);
            return other.equals(this.liquid);
        }
        return false;
    }

    @Override
    public IResource clone(int multiplier) {
        return new FluidResource(this.liquid, this.amount * multiplier, this.target);
    }

    @Override
    public boolean mergeForDisplay(IResource resource, int withAmount) {
        if (resource instanceof FluidResource && ((FluidResource)resource).liquid.equals(this.liquid)) {
            this.amount += withAmount;
            return true;
        }
        return false;
    }

    @Override
    public IResource copyForDisplayWith(int amount) {
        return new FluidResource(this.liquid, amount, null);
    }

    @Override
    public void setCCType(Object type) {
        this.ccObject = type;
    }

    @Override
    public Object getCCType() {
        return this.ccObject;
    }

    @Override
    public String getDisplayText(IResource.ColorCode code) {
        StringBuilder builder = new StringBuilder();
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)(code == IResource.ColorCode.MISSING ? ChatColor.RED : ChatColor.GREEN));
        }
        builder.append(this.amount);
        builder.append("mB ");
        builder.append(this.liquid.makeFluidStack(0).getLocalizedName());
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)ChatColor.WHITE);
        }
        return builder.toString();
    }

    @Override
    public ItemIdentifierStack getDisplayItem() {
        return this.liquid.getItemIdentifier().makeStack(this.amount);
    }
}

