/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IProvide;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.IPromise;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.item.ItemIdentifier;

public class LogisticsPromise
implements IPromise {
    public ItemIdentifier item;
    public int numberOfItems;
    public IProvideItems sender;
    public IOrderInfoProvider.ResourceType type;

    public LogisticsPromise(ItemIdentifier item, int numberOfItems, IProvideItems sender, IOrderInfoProvider.ResourceType type) {
        this.item = item;
        this.numberOfItems = numberOfItems;
        this.sender = sender;
        this.type = type;
    }

    @Override
    public LogisticsPromise copy() {
        return new LogisticsPromise(this.item, this.numberOfItems, this.sender, this.type);
    }

    @Override
    public boolean matches(IResource requestType) {
        return requestType.matches(this.item);
    }

    @Override
    public int getAmount() {
        return this.numberOfItems;
    }

    @Override
    public IExtraPromise split(int more) {
        this.numberOfItems -= more;
        return new LogisticsExtraPromise(this.getItemType(), more, this.sender, false);
    }

    @Override
    public IProvide getProvider() {
        return this.sender;
    }

    @Override
    public ItemIdentifier getItemType() {
        return this.item;
    }

    @Override
    public IOrderInfoProvider.ResourceType getType() {
        return this.type;
    }

    @Override
    public IOrderInfoProvider fullFill(IResource requestType, IAdditionalTargetInformation info) {
        IRequestItems destination = null;
        if (requestType instanceof ItemResource) {
            destination = ((ItemResource)requestType).getTarget();
        } else if (requestType instanceof DictResource) {
            destination = ((DictResource)requestType).getTarget();
        } else {
            throw new UnsupportedOperationException();
        }
        return this.sender.fullFill(this, destination, info);
    }
}

