/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.routing.FluidLogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsFluidOrder;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.utils.FluidIdentifier;

public class LogisticsFluidOrderManager
extends LogisticsOrderManager<LogisticsFluidOrder> {
    public LogisticsFluidOrderManager(ILPPositionProvider pos) {
        super(pos);
    }

    public LogisticsFluidOrderManager(IChangeListener listener, ILPPositionProvider pos) {
        super(listener, pos);
    }

    @Override
    public void sendFailed() {
        ((LogisticsFluidOrder)this._orders.getFirst()).sendFailed();
        super.sendFailed();
    }

    public LogisticsFluidOrder addOrder(FluidLogisticsPromise promise, IRequestFluid destination, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        if (promise.amount < 0) {
            throw new RuntimeException("The amount can't be less than zero");
        }
        LogisticsFluidOrder order = new LogisticsFluidOrder(promise.liquid, promise.amount, destination, type, info);
        this._orders.addLast(order);
        this.listen();
        return order;
    }

    public Integer totalFluidsCountInOrders(FluidIdentifier fluid) {
        int itemCount = 0;
        for (LogisticsFluidOrder request : this._orders) {
            if (!request.getFluid().equals(fluid)) continue;
            itemCount += request.getAmount();
        }
        return itemCount;
    }
}

