/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.utils.item.ItemIdentifierStack;

public class LogisticsItemOrder
extends LogisticsOrder {
    private final ItemIdentifierStack itemStack;
    private final IRequestItems destination;

    public LogisticsItemOrder(ItemIdentifierStack item, IRequestItems destination, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        super(type, info);
        if (item == null) {
            throw new NullPointerException();
        }
        this.itemStack = item;
        this.destination = destination;
    }

    @Override
    public IRouter getRouter() {
        return this.destination.getRouter();
    }

    @Override
    public void sendFailed() {
        this.destination.itemCouldNotBeSend(this.getItemStack(), this.getInformation());
    }

    @Override
    public ItemIdentifierStack getAsDisplayItem() {
        return this.itemStack;
    }

    @Override
    public int getAmount() {
        return this.itemStack.getStackSize();
    }

    @Override
    public void reduceAmountBy(int amount) {
        this.itemStack.setStackSize(this.itemStack.getStackSize() - amount);
    }

    public ItemIdentifierStack getItemStack() {
        return this.itemStack;
    }

    public IRequestItems getDestination() {
        return this.destination;
    }
}

