/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;

public class LogisticsItemOrderManager
extends LogisticsOrderManager<LogisticsItemOrder> {
    public LogisticsItemOrderManager(ILPPositionProvider pos) {
        super(pos);
    }

    public LogisticsItemOrderManager(IChangeListener listener, ILPPositionProvider pos) {
        super(listener, pos);
    }

    @Override
    public void sendFailed() {
        ((LogisticsItemOrder)this._orders.getFirst()).sendFailed();
        super.sendFailed();
    }

    public LogisticsItemOrder addOrder(ItemIdentifierStack stack, IRequestItems requester, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        LogisticsItemOrder order = new LogisticsItemOrder(stack, requester, type, info);
        this._orders.addLast(order);
        this.listen();
        return order;
    }

    @Override
    public LogisticsItemOrder peekAtTopRequest(IOrderInfoProvider.ResourceType type) {
        return (LogisticsItemOrder)super.peekAtTopRequest(type);
    }

    public int totalItemsCountInOrders(ItemIdentifier item) {
        int itemCount = 0;
        for (LogisticsItemOrder request : this._orders) {
            if (!request.getItemStack().getItem().equals(item)) continue;
            itemCount += request.getItemStack().getStackSize();
        }
        return itemCount;
    }
}

