/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.PipeManagerContentPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.order.DistanceTracker;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public abstract class LogisticsOrderManager<T extends LogisticsOrder>
implements Iterable<T> {
    private LinkedList<T> oldOrders = new LinkedList();
    protected LinkedList<T> _orders = new LinkedList();
    protected IChangeListener listener = null;
    protected PlayerCollectionList watchingPlayers = new PlayerCollectionList();
    private ILPPositionProvider pos = null;

    public LogisticsOrderManager(ILPPositionProvider pos) {
        this.pos = pos;
    }

    public LogisticsOrderManager(IChangeListener listener, ILPPositionProvider pos) {
        this(pos);
        this.listener = listener;
    }

    protected void listen() {
        this.changed();
        if (this.listener != null) {
            this.listener.listenedChanged();
        }
    }

    public LinkedList<ItemIdentifierStack> getContentList(World world) {
        if (MainProxy.isClient(world) || this._orders.size() == 0) {
            return new LinkedList<ItemIdentifierStack>();
        }
        LinkedList<ItemIdentifierStack> list = new LinkedList<ItemIdentifierStack>();
        for (LogisticsOrder request : this._orders) {
            LogisticsOrderManager.addToList(request.getAsDisplayItem(), list);
        }
        return list;
    }

    private static void addToList(ItemIdentifierStack stack, LinkedList<ItemIdentifierStack> list) {
        for (ItemIdentifierStack ident : list) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.setStackSize(ident.getStackSize() + stack.getStackSize());
            return;
        }
        list.addLast(stack.clone());
    }

    public boolean hasOrders(IOrderInfoProvider.ResourceType type) {
        return this.peekAtTopRequest(type) != null;
    }

    public T peekAtTopRequest(IOrderInfoProvider.ResourceType type) {
        if (this._orders.size() == 0) {
            return null;
        }
        LogisticsOrder top = ((LogisticsOrder)this._orders.getFirst()).setInProgress(true);
        int loopCount = 0;
        while (type != null & top.getType() != type) {
            if (++loopCount > this._orders.size()) {
                return null;
            }
            this.deferSend();
            top = (LogisticsOrder)this._orders.getFirst();
        }
        return (T)top;
    }

    public void sendSuccessfull(int number, boolean defersend, IRoutedItem item) {
        ((LogisticsOrder)this._orders.getFirst()).reduceAmountBy(number);
        if (((LogisticsOrder)this._orders.getFirst()).isWatched()) {
            DistanceTracker tracker = new DistanceTracker();
            item.setDistanceTracker(tracker);
            ((LogisticsOrder)this._orders.getFirst()).addDistanceTracker(tracker);
        }
        int destination = ((LogisticsOrder)this._orders.getFirst()).getRouterId();
        if (((LogisticsOrder)this._orders.getFirst()).getAmount() <= 0) {
            LogisticsOrder order = (LogisticsOrder)this._orders.removeFirst();
            order.setFinished(true);
            order.setInProgress(false);
        }
        if (!this._orders.isEmpty()) {
            LogisticsOrder start = (LogisticsOrder)this._orders.getFirst();
            if (defersend && destination == start.getRouterId()) {
                this._orders.add(((LogisticsOrder)this._orders.removeFirst()).setInProgress(false));
                while (start != this._orders.getFirst() && destination == ((LogisticsOrder)this._orders.getFirst()).getRouterId()) {
                    this._orders.add(this._orders.removeFirst());
                }
                if (start == this._orders.getFirst()) {
                    this._orders.add(this._orders.removeFirst());
                }
                ((LogisticsOrder)this._orders.getFirst()).setInProgress(true);
            }
        }
        this.listen();
    }

    public void sendFailed() {
        if (!this._orders.isEmpty()) {
            LogisticsOrder order = (LogisticsOrder)this._orders.removeFirst();
            order.setFinished(true);
            order.setInProgress(false);
        }
        if (!this._orders.isEmpty()) {
            ((LogisticsOrder)this._orders.getFirst()).setInProgress(true);
        }
        this.listen();
    }

    public void deferSend() {
        int destination = ((LogisticsOrder)this._orders.getFirst()).getRouterId();
        LogisticsOrder start = (LogisticsOrder)this._orders.getFirst();
        this._orders.add(((LogisticsOrder)this._orders.removeFirst()).setInProgress(false));
        while (start != this._orders.getFirst() && destination == ((LogisticsOrder)this._orders.getFirst()).getRouterId()) {
            this._orders.add(this._orders.removeFirst());
        }
        if (start == this._orders.getFirst()) {
            this._orders.add(this._orders.removeFirst());
        }
        ((LogisticsOrder)this._orders.getFirst()).setInProgress(true);
        this.listen();
    }

    public int totalAmountCountInAllOrders() {
        int amount = 0;
        for (LogisticsOrder request : this._orders) {
            amount += request.getAmount();
        }
        return amount;
    }

    public void setMachineProgress(byte progress) {
        if (this._orders.isEmpty()) {
            return;
        }
        ((LogisticsOrder)this._orders.getFirst()).setMachineProgress(progress);
        this.changed();
    }

    public boolean isFirstOrderWatched() {
        if (this._orders.isEmpty()) {
            return false;
        }
        return ((LogisticsOrder)this._orders.getFirst()).isWatched();
    }

    public void startWatching(EntityPlayer player) {
        this.watchingPlayers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(PipeManagerContentPacket.class).setManager(this).setLPPos(this.pos.getLPPosition()), player);
    }

    public void stopWatching(EntityPlayer player) {
        this.watchingPlayers.remove(player);
    }

    private void changed() {
        if (this.watchingPlayers.isEmpty()) {
            return;
        }
        MainProxy.sendToPlayerList(PacketHandler.getPacket(PipeManagerContentPacket.class).setManager(this).setLPPos(this.pos.getLPPosition()), this.watchingPlayers);
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this._orders).iterator();
    }
}

