/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.pathfinder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.asm.te.ILPTEInformation;
import logisticspipes.asm.te.ITileEntityChangeListener;
import logisticspipes.asm.te.LPTileEntityObject;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.IDirectRoutingConnection;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.specialconnection.SpecialPipeConnection;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IPaintPath;
import logisticspipes.routing.LaserData;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.routing.pathfinder.IRouteProvider;
import logisticspipes.utils.OneList;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PathFinder {
    private final int maxVisited;
    private final int maxLength;
    private final HashSet<LPPosition> setVisited;
    private final HashMap<LPPosition, Double> distances;
    private final IPaintPath pathPainter;
    private int pipesVisited;
    public List<Pair<ILogisticsPowerProvider, List<IFilter>>> powerNodes;
    public List<Pair<ISubSystemPowerProvider, List<IFilter>>> subPowerProvider;
    public HashMap<CoreRoutedPipe, ExitRoute> result;
    public ITileEntityChangeListener changeListener;
    public Set<List<ITileEntityChangeListener>> listenedPipes = new HashSet<List<ITileEntityChangeListener>>();
    public Set<LPTileEntityObject> touchedPipes = new HashSet<LPTileEntityObject>();

    public static HashMap<CoreRoutedPipe, ExitRoute> paintAndgetConnectedRoutingPipes(TileEntity startPipe, ForgeDirection startOrientation, int maxVisited, int maxLength, IPaintPath pathPainter, EnumSet<PipeRoutingConnectionType> connectionType) {
        IPipeInformationProvider startProvider = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(startPipe);
        if (startProvider == null) {
            return new HashMap<CoreRoutedPipe, ExitRoute>();
        }
        PathFinder newSearch = new PathFinder(maxVisited, maxLength, pathPainter);
        LPPosition p = new LPPosition(startProvider);
        newSearch.setVisited.add(p);
        p.moveForward(startOrientation);
        TileEntity entity = p.getTileEntity(startProvider.getWorld());
        IPipeInformationProvider provider = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(entity);
        if (provider == null) {
            return new HashMap<CoreRoutedPipe, ExitRoute>();
        }
        return newSearch.getConnectedRoutingPipes(provider, connectionType, startOrientation);
    }

    public PathFinder(IPipeInformationProvider startPipe, int maxVisited, int maxLength, ITileEntityChangeListener changeListener) {
        this(maxVisited, maxLength, null);
        if (startPipe == null) {
            this.result = new HashMap();
            return;
        }
        this.changeListener = changeListener;
        this.result = this.getConnectedRoutingPipes(startPipe, EnumSet.allOf(PipeRoutingConnectionType.class), ForgeDirection.UNKNOWN);
    }

    public PathFinder(IPipeInformationProvider startPipe, int maxVisited, int maxLength, ForgeDirection side) {
        this(maxVisited, maxLength, null);
        this.result = this.getConnectedRoutingPipes(startPipe, EnumSet.allOf(PipeRoutingConnectionType.class), side);
    }

    private PathFinder(int maxVisited, int maxLength, IPaintPath pathPainter) {
        this.maxVisited = maxVisited;
        this.maxLength = maxLength;
        this.setVisited = new HashSet();
        this.distances = new HashMap();
        this.pathPainter = pathPainter;
    }

    private HashMap<CoreRoutedPipe, ExitRoute> getConnectedRoutingPipes(IPipeInformationProvider startPipe, EnumSet<PipeRoutingConnectionType> connectionFlags, ForgeDirection side) {
        boolean root;
        HashMap<CoreRoutedPipe, ExitRoute> foundPipes = new HashMap<CoreRoutedPipe, ExitRoute>();
        boolean bl = root = this.setVisited.size() == 0;
        if (this.setVisited.size() == 1) {
            this.pipesVisited = 0;
        }
        if (++this.pipesVisited > this.maxVisited) {
            return foundPipes;
        }
        if (this.setVisited.size() > this.maxLength) {
            return foundPipes;
        }
        if (!startPipe.isRouterInitialized()) {
            return foundPipes;
        }
        if (startPipe.isRoutingPipe() && this.setVisited.size() != 0) {
            CoreRoutedPipe rp = startPipe.getRoutingPipe();
            if (rp.stillNeedReplace()) {
                return foundPipes;
            }
            double size = 0.0;
            for (Double dis : this.distances.values()) {
                size += dis.doubleValue();
            }
            if (!rp.getUpgradeManager().hasPowerPassUpgrade()) {
                connectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
            }
            foundPipes.put(rp, new ExitRoute(null, rp.getRouter(), ForgeDirection.UNKNOWN, side.getOpposite(), Math.max(1.0, size), connectionFlags, this.distances.size()));
            return foundPipes;
        }
        this.setVisited.add(new LPPosition(startPipe));
        this.distances.put(new LPPosition(startPipe), startPipe.getDistance());
        List<SpecialPipeConnection.ConnectionInformation> pipez = SimpleServiceLocator.specialpipeconnection.getConnectedPipes(startPipe, connectionFlags, side);
        for (SpecialPipeConnection.ConnectionInformation specialConnection : pipez) {
            if (this.setVisited.contains(new LPPosition(specialConnection.getConnectedPipe()))) continue;
            this.distances.put(new LPPosition(startPipe).center(), specialConnection.getDistance());
            HashMap<CoreRoutedPipe, ExitRoute> result = this.getConnectedRoutingPipes(specialConnection.getConnectedPipe(), specialConnection.getConnectionFlags(), specialConnection.getInsertOrientation());
            this.distances.remove(new LPPosition(startPipe).center());
            for (Map.Entry<CoreRoutedPipe, ExitRoute> pipe : result.entrySet()) {
                pipe.getValue().exitOrientation = specialConnection.getExitOrientation();
                ExitRoute foundPipe = foundPipes.get(pipe.getKey());
                if (foundPipe != null && !(pipe.getValue().distanceToDestination < foundPipe.distanceToDestination)) continue;
                foundPipes.put(pipe.getKey(), pipe.getValue());
            }
        }
        ArrayDeque<Pair<TileEntity, ForgeDirection>> connections = new ArrayDeque<Pair<TileEntity, ForgeDirection>>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile;
            if (root && !ForgeDirection.UNKNOWN.equals((Object)side) && !direction.equals((Object)side) || (tile = startPipe.getTile(direction)) == null) continue;
            if (OrientationsUtil.isSide(direction)) {
                if (root && tile instanceof ILogisticsPowerProvider) {
                    if (this.powerNodes == null) {
                        this.powerNodes = new ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>>();
                    }
                    if (startPipe.isFirewallPipe()) {
                        this.powerNodes.add(new Pair<ILogisticsPowerProvider, OneList<IFilter>>((ILogisticsPowerProvider)tile, new OneList<IFilter>(startPipe.getFirewallFilter())));
                    } else {
                        this.powerNodes.add(new Pair((ILogisticsPowerProvider)tile, Collections.unmodifiableList(new ArrayList(0))));
                    }
                }
                if (root && tile instanceof ISubSystemPowerProvider) {
                    if (this.subPowerProvider == null) {
                        this.subPowerProvider = new ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>>();
                    }
                    if (startPipe.isFirewallPipe()) {
                        this.subPowerProvider.add(new Pair<ISubSystemPowerProvider, OneList<IFilter>>((ISubSystemPowerProvider)tile, new OneList<IFilter>(startPipe.getFirewallFilter())));
                    } else {
                        this.subPowerProvider.add(new Pair((ISubSystemPowerProvider)tile, Collections.unmodifiableList(new ArrayList(0))));
                    }
                }
            }
            connections.add(new Pair<TileEntity, ForgeDirection>(tile, direction));
        }
        while (!connections.isEmpty()) {
            List<IRouteProvider.RouteInfo> list;
            IPipeInformationProvider currentPipe;
            CoreRoutedPipe CRP;
            Pair pair = (Pair)connections.pollFirst();
            TileEntity tile = (TileEntity)pair.getValue1();
            ForgeDirection direction = (ForgeDirection)pair.getValue2();
            EnumSet<PipeRoutingConnectionType> nextConnectionFlags = EnumSet.copyOf(connectionFlags);
            boolean isDirectConnection = false;
            int resistance = 0;
            if (root) {
                Collection<TileEntity> list2 = SimpleServiceLocator.specialtileconnection.getConnectedPipes(tile);
                if (!list2.isEmpty()) {
                    for (TileEntity pipe : list2) {
                        connections.add(new Pair<TileEntity, ForgeDirection>(pipe, direction));
                    }
                    this.listTileEntity(tile);
                    continue;
                }
                if (!startPipe.getRoutingPipe().getUpgradeManager().hasPowerPassUpgrade()) {
                    nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
                }
            }
            if (tile instanceof IInventory && startPipe.isRoutingPipe() && startPipe.getRoutingPipe() instanceof IDirectRoutingConnection && SimpleServiceLocator.connectionManager.hasDirectConnection(startPipe.getRoutingPipe().getRouter()) && (CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(startPipe.getRoutingPipe().getRouter())) != null) {
                tile = CRP.container;
                isDirectConnection = true;
                resistance = ((IDirectRoutingConnection)((Object)startPipe.getRoutingPipe())).getConnectionResistance();
            }
            if (tile == null || (currentPipe = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile)) == null || !currentPipe.isRouterInitialized() || !isDirectConnection && !SimpleServiceLocator.pipeInformationManager.canConnect(startPipe, currentPipe, direction, true)) continue;
            this.listTileEntity(tile);
            if (this.setVisited.contains(new LPPosition(tile))) continue;
            if (side != pair.getValue2() && !root) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
            }
            if (isDirectConnection) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerFrom);
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
            }
            if (currentPipe.divideNetwork()) continue;
            if (currentPipe.powerOnly()) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRouteTo);
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRequestFrom);
            }
            if (startPipe.isOnewayPipe() && !startPipe.isOutputOpen(direction)) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRouteTo);
            }
            if (currentPipe.isOnewayPipe()) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
                if (!currentPipe.isOutputOpen(direction.getOpposite())) {
                    nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRequestFrom);
                    nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerFrom);
                }
            }
            if (nextConnectionFlags.isEmpty()) continue;
            int beforeRecurseCount = foundPipes.size();
            HashMap<CoreRoutedPipe, ExitRoute> result = null;
            if (currentPipe instanceof IRouteProvider && (list = ((IRouteProvider)((Object)currentPipe)).getConnectedPipes(direction.getOpposite())) != null) {
                result = new HashMap();
                LPPosition pos = new LPPosition(currentPipe);
                for (IRouteProvider.RouteInfo info : list) {
                    if (info.getPipe() == startPipe || this.setVisited.contains(new LPPosition(info.getPipe()))) continue;
                    this.distances.put(pos, currentPipe.getDistance() + (double)info.getLength());
                    result.putAll(this.getConnectedRoutingPipes(info.getPipe(), nextConnectionFlags, direction));
                    this.distances.remove(pos);
                }
            }
            if (result == null) {
                result = this.getConnectedRoutingPipes(currentPipe, nextConnectionFlags, direction);
            }
            for (Map.Entry pipeEntry : result.entrySet()) {
                ((ExitRoute)pipeEntry.getValue()).exitOrientation = direction;
                ExitRoute foundPipe = foundPipes.get(pipeEntry.getKey());
                if (foundPipe == null) {
                    foundPipes.put((CoreRoutedPipe)pipeEntry.getKey(), (ExitRoute)pipeEntry.getValue());
                    ((ExitRoute)pipeEntry.getValue()).distanceToDestination += (double)resistance;
                    continue;
                }
                if (!(((ExitRoute)pipeEntry.getValue()).distanceToDestination + (double)resistance < foundPipe.distanceToDestination)) continue;
                foundPipes.put((CoreRoutedPipe)pipeEntry.getKey(), (ExitRoute)pipeEntry.getValue());
                ((ExitRoute)pipeEntry.getValue()).distanceToDestination += (double)resistance;
            }
            if (foundPipes.size() <= beforeRecurseCount || this.pathPainter == null) continue;
            this.pathPainter.addLaser(startPipe.getWorld(), new LaserData(startPipe.getX(), startPipe.getY(), startPipe.getZ(), direction, connectionFlags));
        }
        this.setVisited.remove(new LPPosition(startPipe));
        this.distances.remove(new LPPosition(startPipe));
        if (startPipe.isRoutingPipe()) {
            for (ExitRoute e : foundPipes.values()) {
                e.root = startPipe.getRoutingPipe().getRouter();
            }
        }
        if (startPipe.isFirewallPipe() && root) {
            for (ExitRoute e : foundPipes.values()) {
                e.filters = new OneList<IFilter>(startPipe.getFirewallFilter());
            }
        }
        return foundPipes;
    }

    private void listTileEntity(TileEntity tile) {
        if (this.changeListener != null && tile instanceof ILPTEInformation && ((ILPTEInformation)tile).getObject() != null) {
            if (!((ILPTEInformation)tile).getObject().changeListeners.contains(this.changeListener)) {
                ((ILPTEInformation)tile).getObject().changeListeners.add(this.changeListener);
            }
            this.listenedPipes.add(((ILPTEInformation)tile).getObject().changeListeners);
            this.touchedPipes.add(((ILPTEInformation)tile).getObject());
        }
    }

    public static int messureDistanceToNextRoutedPipe(LPPosition lpPosition, ForgeDirection exitOrientation, World world) {
        int dis = 1;
        TileEntity tile = lpPosition.getTileEntity(world);
        if (tile instanceof LogisticsTileGenericPipe) {
            tile = ((LogisticsTileGenericPipe)tile).getTile(exitOrientation);
        }
        if (tile == null) {
            return 0;
        }
        IPipeInformationProvider info = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile);
        while (info != null && !info.isRoutingPipe()) {
            tile = info.getTile(exitOrientation);
            if (tile == null) {
                info = null;
                continue;
            }
            info = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile);
            ++dis;
        }
        return dis;
    }
}

