/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.factory.gadgets.MachineMoistener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Moistener")
public class Moistener {
    public static final String name = "Forestry Moistener";

    @ZenMethod
    public static void addRecipe(IItemStack product, IItemStack resource, int timePerItem) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineMoistener.Recipe(InputHelper.toStack(resource), InputHelper.toStack(product), timePerItem)));
    }

    @Deprecated
    @ZenMethod
    public static void addRecipe(int timePerItem, IItemStack resource, IItemStack product) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineMoistener.Recipe(InputHelper.toStack(resource), InputHelper.toStack(product), timePerItem)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<MachineMoistener.Recipe> recipes = new LinkedList<MachineMoistener.Recipe>();
        for (MachineMoistener.Recipe recipe : MachineMoistener.RecipeManager.recipes) {
            if (recipe == null || recipe.product == null || !StackHelper.matches(output, InputHelper.toIItemStack(recipe.product))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(IItemStack item, IItemStack product, int moistenerValue, int stage) {
        if (stage >= 0) {
            MineTweakerAPI.apply((IUndoableAction)new AddFuel(new MoistenerFuel(InputHelper.toStack(item), InputHelper.toStack(product), moistenerValue, stage)));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe add for %s. Stage parameter must positive!", name, item.toString()));
        }
    }

    @ZenMethod
    public static void removeFuel(IIngredient moistenerItem) {
        HashMap<ItemStack, MoistenerFuel> fuelItems = new HashMap<ItemStack, MoistenerFuel>();
        for (Map.Entry fuelItem : FuelManager.moistenerResource.entrySet()) {
            if (fuelItem == null || !StackHelper.matches(moistenerItem, InputHelper.toIItemStack(((MoistenerFuel)fuelItem.getValue()).item))) continue;
            fuelItems.put((ItemStack)fuelItem.getKey(), (MoistenerFuel)fuelItem.getValue());
        }
        if (!fuelItems.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(fuelItems));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, moistenerItem.toString()));
        }
    }

    private static class RemoveFuel
    extends BaseMapRemoval<ItemStack, MoistenerFuel> {
        public RemoveFuel(Map<ItemStack, MoistenerFuel> recipes) {
            super(Moistener.name, FuelManager.moistenerResource, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<ItemStack, MoistenerFuel> fuelEntry) {
            return LogHelper.getStackDescription(fuelEntry.getKey());
        }
    }

    private static class AddFuel
    extends BaseMapAddition<ItemStack, MoistenerFuel> {
        public AddFuel(MoistenerFuel fuelEntry) {
            super(Moistener.name, FuelManager.moistenerResource);
            this.recipes.put(fuelEntry.item, fuelEntry);
        }

        @Override
        public String getRecipeInfo(Map.Entry<ItemStack, MoistenerFuel> fuelEntry) {
            return LogHelper.getStackDescription(fuelEntry.getKey());
        }
    }

    private static class Remove
    extends BaseListRemoval<MachineMoistener.Recipe> {
        public Remove(List<MachineMoistener.Recipe> recipes) {
            super(Moistener.name, MachineMoistener.RecipeManager.recipes, recipes);
        }

        @Override
        public String getRecipeInfo(MachineMoistener.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.product);
        }
    }

    private static class Add
    extends BaseListAddition<MachineMoistener.Recipe> {
        public Add(MachineMoistener.Recipe recipe) {
            super(Moistener.name, MachineMoistener.RecipeManager.recipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(MachineMoistener.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.product);
        }
    }
}

