/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.lib.util;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRecord
implements Comparable<BlockRecord> {
    public int x;
    public int y;
    public int z;
    public Block block;
    public int meta;
    public TileEntity tileEntity;
    public World world;

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public BlockRecord(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public BlockRecord(int X, int Y, int Z) {
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public BlockRecord(BlockRecord Record) {
        this.x = Record.x;
        this.y = Record.y;
        this.z = Record.z;
    }

    public void Shift(ForgeDirection Direction) {
        this.x += Direction.offsetX;
        this.y += Direction.offsetY;
        this.z += Direction.offsetZ;
    }

    public BlockRecord NextInDirection(ForgeDirection Direction) {
        return new BlockRecord(this.x + Direction.offsetX, this.y + Direction.offsetY, this.z + Direction.offsetZ);
    }

    @Override
    public int compareTo(BlockRecord Target) {
        int Result2 = this.x - Target.x;
        if (Result2 == 0 && (Result2 = this.y - Target.y) == 0) {
            Result2 = this.z - Target.z;
        }
        return Result2;
    }

    public void Identify(World World2) {
        this.world = World2;
        this.block = World2.func_147439_a(this.x, this.y, this.z);
        this.meta = World2.func_72805_g(this.x, this.y, this.z);
        this.tileEntity = World2.func_147438_o(this.x, this.y, this.z);
    }

    public static BlockRecord Identified(TileEntity Anchor, int X, int Y, int Z) {
        BlockRecord Record = new BlockRecord(X, Y, Z);
        Record.Identify(Anchor.func_145831_w());
        return Record;
    }

    public int hashCode() {
        return this.x << 20 ^ this.y << 10 ^ this.z;
    }

    public int distanceSquared(BlockRecord r) {
        return this.sq(this.x - r.x) + this.sq(this.y - r.y) + this.sq(this.z - r.z);
    }

    private int sq(int i) {
        return i * i;
    }
}

