/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.lib.util;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public abstract class SneakyWorldUtil {
    public static boolean setBlock(World world, int x, int y, int z, Block newBlock, int meta) {
        TileEntity tileentity;
        TileEntity te;
        int chunkX = x & 0xF;
        int chunkZ = z & 0xF;
        Chunk chunk = world.func_72938_d(x, z);
        if (chunk == null) {
            return false;
        }
        int xzCombinedPosition = chunkZ << 4 | chunkX;
        if (y >= chunk.field_76638_b[xzCombinedPosition] - 1) {
            chunk.field_76638_b[xzCombinedPosition] = -999;
        }
        int heightMapAtTarget = chunk.field_76634_f[xzCombinedPosition];
        Block oldBlock = chunk.func_150810_a(chunkX, y, chunkZ);
        int metadata = chunk.func_76628_c(chunkX, y, chunkZ);
        if (oldBlock == newBlock && metadata == meta) {
            return false;
        }
        ExtendedBlockStorage xbs = chunk.field_76652_q[y >> 4];
        boolean heightMapChanged = false;
        if (xbs == null) {
            if (newBlock == Blocks.field_150350_a) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, !world.field_73011_w.field_76576_e);
            chunk.field_76652_q[y >> 4] = extendedBlockStorage;
            xbs = extendedBlockStorage;
            heightMapChanged = y >= heightMapAtTarget;
        }
        int oldOpacity = oldBlock.getLightOpacity((IBlockAccess)world, x, y, z);
        xbs.func_150818_a(chunkX, y & 0xF, chunkZ, newBlock);
        xbs.func_76654_b(chunkX, y & 0xF, chunkZ, meta);
        if (!world.field_72995_K) {
            te = chunk.getTileEntityUnsafe(chunkX & 0xF, y, chunkZ & 0xF);
            if (te != null && te.shouldRefresh(oldBlock, chunk.func_150810_a(chunkX & 0xF, y, chunkZ & 0xF), metadata, chunk.func_76628_c(chunkX & 0xF, y, chunkZ & 0xF), world, x, y, z)) {
                world.restoringBlockSnapshots = true;
                chunk.func_150805_f(chunkX & 0xF, y, chunkZ & 0xF);
                world.restoringBlockSnapshots = false;
            }
        } else if (oldBlock.hasTileEntity(metadata) && (te = chunk.getTileEntityUnsafe(chunkX & 0xF, y, chunkZ & 0xF)) != null && te.shouldRefresh(oldBlock, newBlock, metadata, meta, world, x, y, z)) {
            world.restoringBlockSnapshots = true;
            world.func_147475_p(x, y, z);
            world.restoringBlockSnapshots = false;
        }
        if (xbs.func_150819_a(chunkX, y & 0xF, chunkZ) != newBlock) {
            return false;
        }
        xbs.func_76654_b(chunkX, y & 0xF, chunkZ, meta);
        if (heightMapChanged) {
            chunk.func_76603_b();
        } else {
            int newOpacity = newBlock.getLightOpacity((IBlockAccess)world, x, y, z);
            if (newOpacity > 0) {
                if (y >= heightMapAtTarget) {
                    SneakyWorldUtil.relightChunkBlock(chunk, chunkX, y, chunkZ);
                }
            } else if (y == heightMapAtTarget - 1) {
                SneakyWorldUtil.relightChunkBlock(chunk, chunkX, y, chunkZ);
            }
            if (newOpacity != oldOpacity && (newOpacity < oldOpacity || chunk.func_76614_a(EnumSkyBlock.Sky, chunkX, y, chunkZ) > 0 || chunk.func_76614_a(EnumSkyBlock.Block, chunkX, y, chunkZ) > 0)) {
                chunk.func_76595_e(chunkX, chunkZ);
            }
        }
        if (newBlock.hasTileEntity(meta) && (tileentity = chunk.func_150806_e(chunkX, y, chunkZ)) != null) {
            tileentity.func_145836_u();
            tileentity.field_145847_g = meta;
        }
        chunk.field_76643_l = true;
        world.func_147451_t(x, y, z);
        if (chunk.func_150802_k()) {
            world.func_147471_g(x, y, z);
        }
        return true;
    }

    public static void setTileEntity(World world, int X, int Y, int Z, TileEntity entity) {
        if (entity == null) {
            throw new NullPointerException();
        }
        world.addTileEntity(entity);
        world.restoringBlockSnapshots = true;
        world.func_72938_d(X, Z).func_150812_a(X & 0xF, Y, Z & 0xF, entity);
        world.restoringBlockSnapshots = false;
    }

    public static void notifyBlocks(World world, int X, int Y, int Z, Block OldId, Block NewId) {
        world.func_147444_c(X, Y, Z, OldId);
        if (NewId == null) {
            return;
        }
        if (world.func_147438_o(X, Y, Z) != null || NewId.func_149740_M()) {
            world.func_147453_f(X, Y, Z, NewId);
        }
    }

    public static void refreshBlock(World world, int X, int Y, int Z, Block OldId, Block NewId) {
        SneakyWorldUtil.notifyBlocks(world, X, Y, Z, OldId, NewId);
    }

    public static void relightBlock(World w, int x, int y, int z) {
        w.func_72938_d(x, z).func_76615_h(x & 0xF, y, z & 0xF);
    }

    public static void relightChunkBlock(Chunk c, int cx, int y, int cz) {
    }

    public static void fixLighting(Chunk c, int cx, int y, int cz) {
    }
}

