/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.item;

import java.util.Collections;
import java.util.List;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.player.IPlayer;

public class IngredientStack
implements IIngredient {
    private final IIngredient ingredient;
    private final int amount;

    public IngredientStack(IIngredient ingredient, int amount) {
        this.ingredient = ingredient;
        this.amount = amount;
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<IItemStack> getItems() {
        return this.ingredient.getItems();
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this.ingredient, amount);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientStack(this.ingredient.transform(transformer), this.amount);
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientStack(this.ingredient.only(condition), this.amount);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientStack(this.ingredient.marked(mark), this.amount);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        return item.getAmount() == this.amount && this.ingredient.matches(item);
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        return this.ingredient.contains(ingredient);
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return this.ingredient.applyTransform(item, byPlayer);
    }

    @Override
    public Object getInternal() {
        return null;
    }

    @Override
    public boolean hasTransformers() {
        return this.ingredient.hasTransformers();
    }
}

