/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.emc.GraphMapper;
import moze_intel.projecte.emc.IValueArithmetic;

public class ComplexGraphMapper<T, V extends Comparable<V>>
extends GraphMapper<T, V> {
    public ComplexGraphMapper(IValueArithmetic arithmetic) {
        super(arithmetic);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public Map<T, V> generateValues() {
        HashMap valueFor = Maps.newHashMap();
        HashMap solvableThings = Maps.newHashMap();
        for (Object someThing : this.usedIn.keySet()) {
            if (this.conversionsFor.containsKey(someThing) && ((List)this.conversionsFor.get(someThing)).size() != 0) continue;
            solvableThings.put(someThing, this.arithmetic.getZero());
        }
        solvableThings.putAll(this.fixValueBeforeInherit);
        HashSet lookAt = Sets.newHashSet(this.conversionsFor.keySet());
        while (!solvableThings.isEmpty() || !lookAt.isEmpty()) {
            while (true) {
                for (Object something : lookAt) {
                    if (this.getConversionsFor(something).size() == 0) {
                        solvableThings.put(something, this.arithmetic.getZero());
                        ComplexGraphMapper.debugFormat("Set value for %s to %s because 0 conversions left\n", something.toString(), 0);
                        continue;
                    }
                    if (this.getNoDependencyConversionCountFor(something) != this.getConversionsFor(something).size()) continue;
                    Object minValue = this.arithmetic.getZero();
                    for (GraphMapper.Conversion conversion : this.getConversionsFor(something)) {
                        assert (conversion.ingredientsWithAmount == null || conversion.ingredientsWithAmount.size() == 0);
                        Object thisValue = this.arithmetic.div(conversion.value, conversion.outnumber);
                        assert (thisValue.compareTo(this.arithmetic.getZero()) >= 0);
                        if (!this.arithmetic.isZero(minValue) && (thisValue.compareTo(this.arithmetic.getZero()) <= 0 || thisValue.compareTo(minValue) >= 0)) continue;
                        minValue = thisValue;
                    }
                    assert (minValue.compareTo(this.arithmetic.getZero()) >= 0);
                    assert (!solvableThings.containsKey(something));
                    solvableThings.put(something, minValue);
                    ComplexGraphMapper.debugFormat("Set value for %s to %d because %d/%d Conversions solved\n", something.toString(), minValue, this.getNoDependencyConversionCountFor(something), this.getConversionsFor(something).size());
                }
                System.out.format("lookat: %d solvable: %d\n", lookAt.size(), solvableThings.size());
                lookAt.clear();
                if (solvableThings.isEmpty()) break;
                for (Map.Entry solvableThing : solvableThings.entrySet()) {
                    if (valueFor.containsKey(solvableThing.getKey())) continue;
                    if (!this.arithmetic.isFree((Comparable)solvableThing.getValue())) {
                        valueFor.put(solvableThing.getKey(), solvableThing.getValue());
                    }
                    if (((Comparable)solvableThing.getValue()).compareTo(this.arithmetic.getZero()) > 0 || this.arithmetic.isFree((Comparable)solvableThing.getValue())) {
                        for (GraphMapper.Conversion use : this.getUsesFor(solvableThing.getKey())) {
                            assert (use.ingredientsWithAmount != null);
                            Integer amount = use.ingredientsWithAmount.get(solvableThing.getKey());
                            if (amount == null) {
                                throw new RuntimeException("F u!");
                            }
                            if (!this.arithmetic.isFree((Comparable)solvableThing.getValue())) {
                                use.value = this.arithmetic.add(this.arithmetic.mul(amount, (Comparable)solvableThing.getValue()), use.value);
                            }
                            use.ingredientsWithAmount.remove(solvableThing.getKey());
                            if (use.ingredientsWithAmount.size() != 0) continue;
                            this.increaseNoDependencyConversionCountFor(use.output);
                            lookAt.add(use.output);
                        }
                        continue;
                    }
                    for (GraphMapper.Conversion use : this.getUsesFor(solvableThing.getKey())) {
                        for (Object ingredient : use.ingredientsWithAmount.keySet()) {
                            if (ingredient.equals(solvableThing.getKey())) continue;
                            this.getUsesFor(ingredient).remove(use);
                        }
                        use.markInvalid();
                        this.getConversionsFor(use.output).remove(use);
                        lookAt.add(use.output);
                    }
                }
                ComplexGraphMapper.debugPrintln("Finished solvableThings...");
                solvableThings.clear();
            }
            ComplexGraphMapper.debugPrintln("No Solvables left... Trying to remove Conversions");
            LinkedList<GraphMapper.Conversion> toRemove = new LinkedList<GraphMapper.Conversion>();
            boolean foundMinSolve = false;
            for (Map.Entry entry : this.conversionsFor.entrySet()) {
                ComplexGraphMapper.debugFormat("Looking at %s with %d/%d\n", entry, this.getNoDependencyConversionCountFor(entry.getKey()), ((List)entry.getValue()).size());
                if (this.getNoDependencyConversionCountFor(entry.getKey()) == ((List)entry.getValue()).size() || valueFor.containsKey(entry.getKey())) continue;
                Comparable<Object> minValue = null;
                Object minValueAll = null;
                for (GraphMapper.Conversion conversion : (List)entry.getValue()) {
                    Object conversionValue = this.arithmetic.div(conversion.value, conversion.outnumber);
                    if (!(conversion.ingredientsWithAmount != null && conversion.ingredientsWithAmount.size() != 0 || conversionValue.compareTo(this.arithmetic.getZero()) <= 0 || minValue != null && conversionValue.compareTo((Comparable)minValue) >= 0)) {
                        minValue = conversionValue;
                    }
                    if (minValueAll != null && conversionValue.compareTo(minValueAll) >= 0) continue;
                    minValueAll = conversionValue;
                }
                ComplexGraphMapper.debugFormat("minValue for %s: %d ALL: %s\n", entry.getKey().toString(), minValue, minValueAll);
                if (minValue != null && minValue.compareTo(minValueAll) <= 0) {
                    solvableThings.put(entry.getKey(), minValue);
                    foundMinSolve = true;
                    continue;
                }
                if (foundMinSolve) continue;
                for (GraphMapper.Conversion conversion : (List)entry.getValue()) {
                    if (conversion.ingredientsWithAmount != null && conversion.ingredientsWithAmount.size() > 0) {
                        System.out.println("Starting recursion...");
                        int count = this.findDeepIngredientCountForConversion(conversion, conversion.output, new HashSet());
                        System.out.println(count);
                        if (count >= conversion.outnumber) {
                            ComplexGraphMapper.debugFormat("Removing %s. Count: %s: %d -> %d; %d/%d, min: %s this: %s\n", conversion.toString(), conversion.output, count, conversion.outnumber, this.getNoDependencyConversionCountFor(conversion.output), this.getConversionsFor(conversion.output).size(), minValue, this.arithmetic.div(conversion.value, conversion.outnumber));
                            for (Object ingredient : conversion.ingredientsWithAmount.keySet()) {
                                ComplexGraphMapper.debugFormat("%s %d/%d\n", ingredient.toString(), this.getNoDependencyConversionCountFor(ingredient), this.getConversionsFor(ingredient).size());
                            }
                            toRemove.add(conversion);
                            continue;
                        }
                        if (count == 0) {
                            if (this.hasSolvedDependency(conversion)) continue;
                            ComplexGraphMapper.debugFormat("Removing %s because it has no other solved dependencys\n", conversion);
                            toRemove.add(conversion);
                            continue;
                        }
                        ComplexGraphMapper.debugFormat("NOT Removing %s. Count: %s: %d -> %d; %d/%d, min: %s this: %s\n", conversion.toString(), conversion.output, count, conversion.outnumber, this.getNoDependencyConversionCountFor(conversion.output), this.getConversionsFor(conversion.output).size(), minValue, this.arithmetic.div(conversion.value, conversion.outnumber));
                        continue;
                    }
                    ComplexGraphMapper.debugFormat("Skipping %s\n", conversion);
                }
            }
            if (foundMinSolve) continue;
            for (GraphMapper.Conversion conversion : toRemove) {
                this.getConversionsFor(conversion.output).remove(conversion);
                for (Object ingredient : conversion.ingredientsWithAmount.keySet()) {
                    this.getUsesFor(ingredient).remove(conversion);
                }
                lookAt.add(conversion.output);
            }
        }
        for (Map.Entry fixedValueAfterInherit : this.fixValueAfterInherit.entrySet()) {
            valueFor.put(fixedValueAfterInherit.getKey(), fixedValueAfterInherit.getValue());
        }
        return valueFor;
    }

    protected boolean hasSolvedDependency(GraphMapper.Conversion conversion) {
        if (conversion.ingredientsWithAmount != null && conversion.ingredientsWithAmount.size() > 0) {
            for (Object ingredient : conversion.ingredientsWithAmount.keySet()) {
                if (!this.hasSolvedConversionDependency(ingredient, Sets.newHashSet(Collections.singletonList(conversion.output)))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean hasSolvedConversionDependency(T something, Set<T> visited) {
        if (visited.contains(something)) {
            return false;
        }
        visited.add(something);
        for (GraphMapper.Conversion conversion : this.getConversionsFor(something)) {
            if (conversion.ingredientsWithAmount == null || conversion.ingredientsWithAmount.size() == 0) {
                return true;
            }
            for (Object ingredient : conversion.ingredientsWithAmount.keySet()) {
                if (!this.hasSolvedConversionDependency(ingredient, visited)) continue;
                return true;
            }
        }
        return false;
    }

    protected int findDeepIngredientCountForConversion(GraphMapper.Conversion conversion, T something, Set<T> visited) {
        int count = 0;
        if (conversion.ingredientsWithAmount != null) {
            for (Object ingredient : conversion.ingredientsWithAmount.keySet()) {
                if (something.equals(ingredient)) {
                    Integer i = conversion.ingredientsWithAmount.get(ingredient);
                    if (i == null || i <= 0) continue;
                    count += i.intValue();
                    continue;
                }
                if (visited.contains(ingredient)) {
                    return 0;
                }
                int minCount = Integer.MAX_VALUE;
                visited.add(ingredient);
                for (GraphMapper.Conversion ingredientConversion : this.getConversionsFor(ingredient)) {
                    int ingredientConversionCount = this.findDeepIngredientCountForConversion(ingredientConversion, something, visited);
                    if (ingredientConversionCount >= minCount) continue;
                    minCount = ingredientConversionCount;
                }
                count += minCount;
            }
        }
        return count;
    }
}

