/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.utils.MetaBlock;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TransmutationRenderingEvent {
    private Minecraft mc = Minecraft.func_71410_x();
    private final List<AxisAlignedBB> renderList = Lists.newArrayList();
    private double playerX;
    private double playerY;
    private double playerZ;
    private MetaBlock transmutationResult;

    @SubscribeEvent
    public void preDrawHud(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && this.transmutationResult != null) {
            RenderItem.getInstance().func_77015_a(this.mc.field_71466_p, this.mc.func_110434_K(), this.transmutationResult.toItemStack(), 0, 0);
        }
    }

    @SubscribeEvent
    public void onOverlay(DrawBlockHighlightEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.field_70170_p;
        ItemStack stack = player.func_70694_bm();
        if (stack == null || stack.func_77973_b() != ObjHandler.philosStone) {
            if (this.transmutationResult != null) {
                this.transmutationResult = null;
            }
            return;
        }
        this.playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialTicks;
        this.playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialTicks;
        this.playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialTicks;
        MovingObjectPosition mop = event.target;
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            ForgeDirection orientation = ForgeDirection.getOrientation((int)mop.field_72310_e);
            MetaBlock current = new MetaBlock(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            this.transmutationResult = WorldTransmutations.getWorldTransmutation(current, player.func_70093_af());
            if (this.transmutationResult != null) {
                byte charge = ((ItemMode)stack.func_77973_b()).getCharge(stack);
                switch (((ItemMode)stack.func_77973_b()).getMode(stack)) {
                    case 0: {
                        for (int x = mop.field_72311_b - charge; x <= mop.field_72311_b + charge; ++x) {
                            for (int y = mop.field_72312_c - charge; y <= mop.field_72312_c + charge; ++y) {
                                for (int z = mop.field_72309_d - charge; z <= mop.field_72309_d + charge; ++z) {
                                    this.addBlockToRenderList(world, current, x, y, z);
                                }
                            }
                        }
                        break;
                    }
                    case 1: {
                        int side;
                        int n = orientation.offsetY != 0 ? 0 : (side = orientation.offsetX != 0 ? 1 : 2);
                        if (side == 0) {
                            for (int x = mop.field_72311_b - charge; x <= mop.field_72311_b + charge; ++x) {
                                for (int z = mop.field_72309_d - charge; z <= mop.field_72309_d + charge; ++z) {
                                    this.addBlockToRenderList(world, current, x, mop.field_72312_c, z);
                                }
                            }
                        } else if (side == 1) {
                            for (int y = mop.field_72312_c - charge; y <= mop.field_72312_c + charge; ++y) {
                                for (int z = mop.field_72309_d - charge; z <= mop.field_72309_d + charge; ++z) {
                                    this.addBlockToRenderList(world, current, mop.field_72311_b, y, z);
                                }
                            }
                        } else {
                            for (int x = mop.field_72311_b - charge; x <= mop.field_72311_b + charge; ++x) {
                                for (int y = mop.field_72312_c - charge; y <= mop.field_72312_c + charge; ++y) {
                                    this.addBlockToRenderList(world, current, x, y, mop.field_72309_d);
                                }
                            }
                        }
                        break;
                    }
                    case 2: {
                        boolean side;
                        String dir = Direction.field_82373_c[MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3];
                        boolean bl = orientation.offsetX != 0 ? false : (orientation.offsetZ != 0 ? true : (side = !dir.equals("NORTH") && !dir.equals("SOUTH")));
                        if (!side) {
                            for (int z = mop.field_72309_d - charge; z <= mop.field_72309_d + charge; ++z) {
                                this.addBlockToRenderList(world, current, mop.field_72311_b, mop.field_72312_c, z);
                            }
                        } else {
                            for (int x = mop.field_72311_b - charge; x <= mop.field_72311_b + charge; ++x) {
                                this.addBlockToRenderList(world, current, x, mop.field_72312_c, mop.field_72309_d);
                            }
                        }
                        break;
                    }
                }
                this.drawAll();
                this.renderList.clear();
            } else if (this.transmutationResult != null) {
                this.transmutationResult = null;
            }
        } else if (this.transmutationResult != null) {
            this.transmutationResult = null;
        }
    }

    private void drawAll() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(ProjectEConfig.pulsatingOverlay ? this.getPulseProportion() * 0.6f : 0.35f));
        Tessellator tessellator = Tessellator.field_78398_a;
        for (AxisAlignedBB b : this.renderList) {
            tessellator.func_78382_b();
            tessellator.func_78377_a(b.field_72340_a, b.field_72337_e, b.field_72339_c);
            tessellator.func_78377_a(b.field_72336_d, b.field_72337_e, b.field_72339_c);
            tessellator.func_78377_a(b.field_72336_d, b.field_72337_e, b.field_72334_f);
            tessellator.func_78377_a(b.field_72340_a, b.field_72337_e, b.field_72334_f);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78377_a(b.field_72340_a, b.field_72338_b, b.field_72339_c);
            tessellator.func_78377_a(b.field_72336_d, b.field_72338_b, b.field_72339_c);
            tessellator.func_78377_a(b.field_72336_d, b.field_72338_b, b.field_72334_f);
            tessellator.func_78377_a(b.field_72340_a, b.field_72338_b, b.field_72334_f);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78377_a(b.field_72336_d, b.field_72337_e, b.field_72334_f);
            tessellator.func_78377_a(b.field_72340_a, b.field_72337_e, b.field_72334_f);
            tessellator.func_78377_a(b.field_72340_a, b.field_72338_b, b.field_72334_f);
            tessellator.func_78377_a(b.field_72336_d, b.field_72338_b, b.field_72334_f);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78377_a(b.field_72336_d, b.field_72338_b, b.field_72339_c);
            tessellator.func_78377_a(b.field_72340_a, b.field_72338_b, b.field_72339_c);
            tessellator.func_78377_a(b.field_72340_a, b.field_72337_e, b.field_72339_c);
            tessellator.func_78377_a(b.field_72336_d, b.field_72337_e, b.field_72339_c);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78377_a(b.field_72340_a, b.field_72337_e, b.field_72334_f);
            tessellator.func_78377_a(b.field_72340_a, b.field_72337_e, b.field_72339_c);
            tessellator.func_78377_a(b.field_72340_a, b.field_72338_b, b.field_72339_c);
            tessellator.func_78377_a(b.field_72340_a, b.field_72338_b, b.field_72334_f);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78377_a(b.field_72336_d, b.field_72337_e, b.field_72334_f);
            tessellator.func_78377_a(b.field_72336_d, b.field_72337_e, b.field_72339_c);
            tessellator.func_78377_a(b.field_72336_d, b.field_72338_b, b.field_72339_c);
            tessellator.func_78377_a(b.field_72336_d, b.field_72338_b, b.field_72334_f);
            tessellator.func_78381_a();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void addBlockToRenderList(World world, MetaBlock current, int x, int y, int z) {
        if (new MetaBlock(world, x, y, z).equals(current)) {
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((float)x - 0.02f), (double)((float)y - 0.02f), (double)((float)z - 0.02f), (double)((float)x + 1.02f), (double)((float)y + 1.02f), (double)((float)z + 1.02f));
            box = box.func_72317_d(-this.playerX, -this.playerY, -this.playerZ);
            this.renderList.add(box);
        }
    }

    private float getPulseProportion() {
        return (float)(0.5 * Math.sin((double)System.currentTimeMillis() / 350.0) + 0.5);
    }
}

