/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container.inventory;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.playerData.Transmutation;
import moze_intel.projecte.utils.Comparators;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.ItemSearchHelper;
import moze_intel.projecte.utils.NBTWhitelist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TransmutationInventory
implements IInventory {
    public double emc;
    private EntityPlayer player = null;
    private static final int LOCK_INDEX = 8;
    private static final int[] MATTER_INDEXES = new int[]{12, 11, 13, 10, 14, 21, 15, 20, 16, 19, 17, 18};
    private static final int[] FUEL_INDEXES = new int[]{22, 23, 24, 25};
    private ItemStack[] inventory = new ItemStack[27];
    public int learnFlag = 0;
    public int unlearnFlag = 0;
    public String filter = "";
    public int searchpage = 0;
    public List<ItemStack> knowledge = Lists.newArrayList();

    public TransmutationInventory(EntityPlayer player) {
        this.player = player;
    }

    public void handleKnowledge(ItemStack stack) {
        if (stack.field_77994_a > 1) {
            stack.field_77994_a = 1;
        }
        if (!stack.func_77981_g() && stack.func_77958_k() != 0 && stack.func_77960_j() != 0) {
            stack.func_77964_b(0);
        }
        if (!Transmutation.hasKnowledgeForStack(stack, this.player) && !Transmutation.hasFullKnowledge(this.player)) {
            this.learnFlag = 300;
            if (stack.func_77973_b() == ObjHandler.tome) {
                Transmutation.setFullKnowledge(this.player);
            } else {
                if (stack.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT(stack)) {
                    stack.field_77990_d = null;
                }
                Transmutation.addKnowledge(stack, this.player);
            }
            if (!this.player.field_70170_p.field_72995_K) {
                Transmutation.sync(this.player);
            }
        }
        this.updateOutputs();
    }

    public void handleUnlearn(ItemStack stack) {
        if (stack.field_77994_a > 1) {
            stack.field_77994_a = 1;
        }
        if (!stack.func_77981_g() && stack.func_77958_k() != 0 && stack.func_77960_j() != 0) {
            stack.func_77964_b(0);
        }
        if (Transmutation.hasKnowledgeForStack(stack, this.player) && !Transmutation.hasFullKnowledge(this.player)) {
            this.unlearnFlag = 300;
            if (stack.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT(stack)) {
                stack.field_77990_d = null;
            }
            Transmutation.removeKnowledge(stack, this.player);
            if (!this.player.field_70170_p.field_72995_K) {
                Transmutation.sync(this.player);
            }
        }
        this.updateOutputs();
    }

    public void checkForUpdates() {
        int fuelEmc;
        int maxEmc;
        int matterEmc = EMCHelper.getEmcValue(this.inventory[MATTER_INDEXES[0]]);
        int n = maxEmc = matterEmc > (fuelEmc = EMCHelper.getEmcValue(this.inventory[FUEL_INDEXES[0]])) ? matterEmc : fuelEmc;
        if ((double)maxEmc > this.emc) {
            this.updateOutputs();
        }
    }

    public void updateOutputs() {
        this.updateOutputs(false);
    }

    public void updateOutputs(boolean async) {
        if (!this.player.field_70170_p.field_72995_K) {
            return;
        }
        this.knowledge = Lists.newArrayList(Transmutation.getKnowledge(this.player));
        for (int i : MATTER_INDEXES) {
            this.inventory[i] = null;
        }
        for (int i : FUEL_INDEXES) {
            this.inventory[i] = null;
        }
        ItemStack lockCopy = null;
        Collections.sort(this.knowledge, Comparators.ITEMSTACK_EMC_DESCENDING);
        ItemSearchHelper searchHelper = ItemSearchHelper.create(this.filter);
        if (this.inventory[8] != null) {
            int reqEmc = EMCHelper.getEmcValue(this.inventory[8]);
            if (this.emc < (double)reqEmc) {
                return;
            }
            lockCopy = ItemHelper.getNormalizedStack(this.inventory[8]);
            if (lockCopy.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT(lockCopy)) {
                lockCopy.func_77982_d(new NBTTagCompound());
            }
            Iterator<ItemStack> iter = this.knowledge.iterator();
            int pagecounter = 0;
            while (iter.hasNext()) {
                ItemStack stack = iter.next();
                if (EMCHelper.getEmcValue(stack) > reqEmc) {
                    iter.remove();
                    continue;
                }
                if (ItemHelper.basicAreStacksEqual(lockCopy, stack)) {
                    iter.remove();
                    continue;
                }
                if (!searchHelper.doesItemMatchFilter(stack)) {
                    iter.remove();
                    continue;
                }
                if (pagecounter >= this.searchpage * 12) continue;
                ++pagecounter;
                iter.remove();
            }
        } else {
            Iterator<ItemStack> iter = this.knowledge.iterator();
            int pagecounter = 0;
            while (iter.hasNext()) {
                ItemStack stack = iter.next();
                if (this.emc < (double)EMCHelper.getEmcValue(stack)) {
                    iter.remove();
                    continue;
                }
                if (!searchHelper.doesItemMatchFilter(stack)) {
                    iter.remove();
                    continue;
                }
                if (pagecounter >= this.searchpage * 12) continue;
                ++pagecounter;
                iter.remove();
            }
        }
        int matterCounter = 0;
        int fuelCounter = 0;
        if (lockCopy != null) {
            if (FuelMapper.isStackFuel(lockCopy)) {
                this.inventory[TransmutationInventory.FUEL_INDEXES[0]] = lockCopy;
                ++fuelCounter;
            } else {
                this.inventory[TransmutationInventory.MATTER_INDEXES[0]] = lockCopy;
                ++matterCounter;
            }
        }
        for (ItemStack stack : this.knowledge) {
            if (FuelMapper.isStackFuel(stack)) {
                if (fuelCounter >= 4) continue;
                this.inventory[TransmutationInventory.FUEL_INDEXES[fuelCounter]] = stack;
                ++fuelCounter;
                continue;
            }
            if (matterCounter >= 12) continue;
            this.inventory[TransmutationInventory.MATTER_INDEXES[matterCounter]] = stack;
            ++matterCounter;
        }
    }

    public void writeIntoOutputSlot(int slot, ItemStack item) {
        this.inventory[slot] = EMCHelper.doesItemHaveEmc(item) && (double)EMCHelper.getEmcValue(item) <= this.emc && Transmutation.hasKnowledgeForStack(item, this.player) ? item : null;
    }

    public List<ItemStack> getOutputSlots() {
        return Arrays.asList(this.inventory).subList(10, 26);
    }

    public int func_70302_i_() {
        return 26;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int qty) {
        ItemStack stack = this.inventory[slot];
        if (stack != null) {
            if (stack.field_77994_a <= qty) {
                this.inventory[slot] = null;
            } else {
                stack = stack.func_77979_a(qty);
                if (stack.field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack stack = this.inventory[slot];
            this.inventory[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "item.pe_transmutation_tablet.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
        this.emc = Transmutation.getEmc(this.player);
        ItemStack[] inputLocks = Transmutation.getInputsAndLock(this.player);
        System.arraycopy(inputLocks, 0, this.inventory, 0, 9);
        if (this.player.field_70170_p.field_72995_K) {
            this.updateOutputs(true);
        }
    }

    public void func_70305_f() {
        if (!this.player.field_70170_p.field_72995_K) {
            Transmutation.setEmc(this.player, this.emc);
            Transmutation.setInputsAndLocks(Arrays.copyOfRange(this.inventory, 0, 9), this.player);
            Transmutation.sync(this.player);
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public void func_70296_d() {
    }

    public void addEmc(double value) {
        this.emc += value;
        if (this.emc >= 1.073741824E9 || this.emc < 0.0) {
            this.emc = 1.073741824E9;
        }
    }

    public void removeEmc(double value) {
        this.emc -= value;
        if (this.emc < 0.0) {
            this.emc = 0.0;
        }
    }

    public boolean hasMaxedEmc() {
        return this.emc >= 1.073741824E9;
    }
}

