/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.container.inventory.AlchBagInventory;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.playerData.AlchemicalBags;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityLootBall
extends Entity {
    private final int lifespan = 6000;
    private List<ItemStack> items;
    private int age;

    public EntityLootBall(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityLootBall(World world, ItemStack[] drops, double x, double y, double z) {
        this(world, Arrays.asList(drops), x, y, z);
    }

    public EntityLootBall(World world, List<ItemStack> drops, double x, double y, double z) {
        super(world);
        this.items = drops;
        this.func_70105_a(0.25f, 0.25f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.func_70107_b(x, y, z);
        this.field_70159_w = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.field_70181_x = 0.2f;
        this.field_70179_y = (float)(Math.random() * (double)0.2f - (double)0.1f);
        ItemHelper.compactItemList(this.items);
    }

    public List<ItemStack> getItemList() {
        return this.items;
    }

    public void func_70071_h_() {
        boolean flag;
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.field_70145_X = this.func_145771_j(this.field_70165_t, (this.field_70121_D.field_72338_b + this.field_70121_D.field_72337_e) / 2.0, this.field_70161_v);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        boolean bl = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v;
        if ((flag || this.field_70173_aa % 25 == 0) && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() == Material.field_151587_i) {
            this.field_70181_x = 0.2f;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.func_85030_a("random.fizz", 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        float f = 0.98f;
        if (this.field_70122_E) {
            f = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= -0.5;
        }
        ++this.age;
        if (!this.field_70170_p.field_72995_K) {
            if (this.age > 6000 || this.items.isEmpty()) {
                this.func_70106_y();
            }
            if (this.field_70173_aa % 60 == 0 && !this.field_70128_L) {
                List nearby = this.field_70170_p.func_72872_a(EntityLootBall.class, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
                for (EntityLootBall e : nearby) {
                    this.mergeWith(e);
                }
            }
        }
    }

    public void mergeWith(EntityLootBall other) {
        if (other == this) {
            return;
        }
        other.func_70106_y();
        this.items.addAll(Lists.newArrayList(other.getItemList()));
        other.getItemList().clear();
        ItemHelper.compactItemList(this.items);
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        boolean playSound = false;
        ArrayList list = Lists.newArrayList();
        if (player.field_71070_bA instanceof AlchBagContainer) {
            AlchBagInventory inv = ((AlchBagContainer)player.field_71070_bA).inventory;
            if (ItemHelper.invContainsItem(inv, new ItemStack(ObjHandler.blackHole, 1, 1))) {
                for (ItemStack stack : this.items) {
                    ItemStack remain = ItemHelper.pushStackInInv(inv, stack);
                    if (remain == null) {
                        if (playSound) continue;
                        playSound = true;
                        continue;
                    }
                    if ((remain = ItemHelper.pushStackInInv((IInventory)player.field_71071_by, remain)) == null) {
                        if (playSound) continue;
                        playSound = true;
                        continue;
                    }
                    list.add(remain);
                    if (playSound || ItemHelper.areItemStacksEqual(stack, remain)) continue;
                    playSound = true;
                }
                if (playSound) {
                    this.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                if (list.size() > 0) {
                    this.items = list;
                } else {
                    this.func_70106_y();
                }
                return;
            }
        } else {
            ItemStack bag = AlchemicalBag.getFirstBagWithSuctionItem(player, player.field_71071_by.field_70462_a);
            if (bag != null) {
                ItemStack[] inv = AlchemicalBags.get(player, (byte)bag.func_77960_j());
                for (ItemStack stack : this.items) {
                    ItemStack remain = ItemHelper.pushStackInInv(inv, stack);
                    if (remain == null) {
                        if (playSound) continue;
                        playSound = true;
                        continue;
                    }
                    if ((remain = ItemHelper.pushStackInInv((IInventory)player.field_71071_by, remain)) == null) {
                        if (playSound) continue;
                        playSound = true;
                        continue;
                    }
                    list.add(remain);
                    if (playSound || ItemHelper.areItemStacksEqual(stack, remain)) continue;
                    playSound = true;
                }
                if (playSound) {
                    AlchemicalBags.set(player, (byte)bag.func_77960_j(), inv);
                    AlchemicalBags.syncPartial(player, bag.func_77960_j());
                }
            } else {
                for (ItemStack stack : this.items) {
                    ItemStack remaining = ItemHelper.pushStackInInv((IInventory)player.field_71071_by, stack);
                    if (remaining == null) {
                        if (playSound) continue;
                        playSound = true;
                        continue;
                    }
                    list.add(remaining);
                    if (playSound || ItemHelper.areItemStacksEqual(stack, remaining)) continue;
                    playSound = true;
                }
            }
            if (playSound) {
                this.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            if (list.size() > 0) {
                this.items = list;
            } else {
                this.func_70106_y();
            }
        }
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_151586_h, (Entity)this);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.age = nbt.func_74765_d("Age");
        this.items = Lists.newArrayList();
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound listTag = list.func_150305_b(i);
            this.items.add(ItemStack.func_77949_a((NBTTagCompound)listTag));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74777_a("Age", (short)this.age);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.items) {
            NBTTagCompound subNBT = new NBTTagCompound();
            item.func_77955_b(subNBT);
            list.func_74742_a((NBTBase)subNBT);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public void setItemList(List<ItemStack> itemList) {
        this.items = itemList;
    }
}

