/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cpw.mods.fml.common.Optional;
import java.util.List;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class Arcana
extends ItemPE
implements IBauble,
IModeChanger,
IFlightProvider,
IFireProtector,
IExtraFunction,
IProjectileShooter {
    private IIcon[] icons = new IIcon[4];
    private IIcon[] iconsOn = new IIcon[4];

    public Arcana() {
        this.func_77655_b("arcana_ring");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77642_a(this);
    }

    public boolean func_77630_h(ItemStack stack) {
        return false;
    }

    @Override
    public byte getMode(ItemStack stack) {
        return (byte)stack.func_77960_j();
    }

    @Override
    public void changeMode(EntityPlayer player, ItemStack stack) {
        stack.func_77964_b((stack.func_77960_j() + 1) % 4);
    }

    private void tick(ItemStack stack, World world, EntityPlayerMP player) {
        if (stack.func_77978_p().func_74767_n("Active")) {
            switch (stack.func_77960_j()) {
                case 0: {
                    WorldHelper.freezeInBoundingBox(world, player.field_70121_D.func_72314_b(5.0, 5.0, 5.0), (EntityPlayer)player, true);
                    break;
                }
                case 1: {
                    WorldHelper.igniteNearby(world, (EntityPlayer)player);
                    break;
                }
                case 2: {
                    WorldHelper.growNearbyRandomly(true, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, (EntityPlayer)player);
                    break;
                }
                case 3: {
                    WorldHelper.repelEntitiesInAABBFromPoint(world, player.field_70121_D.func_72314_b(5.0, 5.0, 5.0), player.field_70165_t, player.field_70163_u, player.field_70161_v, true);
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (world.field_72995_K || slot > 8 || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        this.tick(stack, world, (EntityPlayerMP)entity);
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        this.tick(stack, entity.field_70170_p, (EntityPlayerMP)entity);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack stack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public IIcon func_77650_f(ItemStack stack) {
        boolean active = stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active");
        return (active ? this.iconsOn : this.icons)[MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)3)];
    }

    public void func_94581_a(IIconRegister register) {
        int i;
        for (i = 0; i < 4; ++i) {
            this.icons[i] = register.func_94245_a(this.getTexture("rings", "arcana_" + i));
        }
        for (i = 0; i < 4; ++i) {
            this.iconsOn[i] = register.func_94245_a(this.getTexture("rings", "arcana_" + i + "_on"));
        }
        this.field_77791_bV = this.icons[0];
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        if (stack.func_77942_o()) {
            if (!stack.field_77990_d.func_74767_n("Active")) {
                list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"pe.arcana.inactive"));
            } else {
                list.add(StatCollector.func_74838_a((String)"pe.arcana.mode") + EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)("pe.arcana.mode." + stack.func_77960_j())));
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            NBTTagCompound compound;
            compound.func_74757_a("Active", !(compound = stack.func_77978_p()).func_74767_n("Active"));
        }
        return stack;
    }

    @Override
    public void doExtraFunction(ItemStack stack, EntityPlayer player) {
        block16: {
            World world = player.field_70170_p;
            if (world.field_72995_K) {
                return;
            }
            switch (stack.func_77960_j()) {
                case 1: {
                    switch (MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) {
                        case 0: 
                        case 2: {
                            int x = (int)(player.field_70165_t - 30.0);
                            while ((double)x <= player.field_70165_t + 30.0) {
                                int y = (int)(player.field_70163_u - 5.0);
                                while ((double)y <= player.field_70163_u + 5.0) {
                                    int z = (int)(player.field_70161_v - 3.0);
                                    while ((double)z <= player.field_70161_v + 3.0) {
                                        if (world.func_147437_c(x, y, z)) {
                                            PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, x, y, z, (Block)Blocks.field_150480_ab, 0);
                                        }
                                        ++z;
                                    }
                                    ++y;
                                }
                                ++x;
                            }
                            break block16;
                        }
                        case 1: 
                        case 3: {
                            int x = (int)(player.field_70165_t - 3.0);
                            while ((double)x <= player.field_70165_t + 3.0) {
                                int y = (int)(player.field_70163_u - 5.0);
                                while ((double)y <= player.field_70163_u + 5.0) {
                                    int z = (int)(player.field_70161_v - 30.0);
                                    while ((double)z <= player.field_70161_v + 30.0) {
                                        if (world.func_147437_c(x, y, z)) {
                                            PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, x, y, z, (Block)Blocks.field_150480_ab, 0);
                                        }
                                        ++z;
                                    }
                                    ++y;
                                }
                                ++x;
                            }
                            break block0;
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean shootProjectile(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return false;
        }
        switch (stack.func_77960_j()) {
            case 0: {
                EntitySnowball snowball = new EntitySnowball(world, (EntityLivingBase)player);
                world.func_72838_d((Entity)snowball);
                world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f);
                break;
            }
            case 1: {
                EntityFireProjectile fire = new EntityFireProjectile(world, player);
                world.func_72838_d((Entity)fire);
                world.func_72956_a((Entity)player, "projecte:item.pepower", 1.0f, 1.0f);
                break;
            }
            case 3: {
                EntitySWRGProjectile lightning = new EntitySWRGProjectile(world, player);
                world.func_72838_d((Entity)lightning);
            }
        }
        return true;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, EntityPlayerMP player) {
        return true;
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, EntityPlayerMP player) {
        return true;
    }
}

