/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.ParticlePKT;
import moze_intel.projecte.utils.Coordinates;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.oredict.OreDictionary;

public abstract class PEToolBase
extends ItemMode {
    public static final float HAMMER_BASE_ATTACK = 13.0f;
    public static final float DARKSWORD_BASE_ATTACK = 12.0f;
    public static final float REDSWORD_BASE_ATTACK = 16.0f;
    public static final float STAR_BASE_ATTACK = 20.0f;
    public static final float KATAR_BASE_ATTACK = 23.0f;
    protected String pePrimaryToolClass;
    protected String peToolMaterial;
    protected Set<Material> harvestMaterials = Sets.newHashSet();
    protected Set<String> secondaryClasses = Sets.newHashSet();

    public PEToolBase(String unlocalName, byte numCharge, String[] modeDescrp) {
        super(unlocalName, numCharge, modeDescrp);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.harvestMaterials.contains(block.func_149688_o());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.pePrimaryToolClass.equals(toolClass) || this.secondaryClasses.contains(toolClass)) {
            return 4;
        }
        return -1;
    }

    public float getDigSpeed(ItemStack stack, Block block, int metadata) {
        if ("dm_tools".equals(this.peToolMaterial)) {
            if (this.canHarvestBlock(block, stack) || ForgeHooks.canToolHarvestBlock((Block)block, (int)metadata, (ItemStack)stack)) {
                return 14.0f + 12.0f * (float)this.getCharge(stack);
            }
        } else if ("rm_tools".equals(this.peToolMaterial) && (this.canHarvestBlock(block, stack) || ForgeHooks.canToolHarvestBlock((Block)block, (int)metadata, (ItemStack)stack))) {
            return 16.0f + 14.0f * (float)this.getCharge(stack);
        }
        return 1.0f;
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.getTexture(this.peToolMaterial, this.pePrimaryToolClass));
    }

    protected void clearOdAOE(World world, ItemStack stack, EntityPlayer player, String odName, int emcCost) {
        byte charge = this.getCharge(stack);
        if (charge == 0 || world.field_72995_K) {
            return;
        }
        ArrayList drops = Lists.newArrayList();
        int x = (int)player.field_70165_t - 5 * charge;
        while ((double)x <= player.field_70165_t + (double)(5 * charge)) {
            int y = (int)player.field_70163_u - 10 * charge;
            while ((double)y <= player.field_70163_u + (double)(10 * charge)) {
                int z = (int)player.field_70161_v - 5 * charge;
                while ((double)z <= player.field_70161_v + (double)(5 * charge)) {
                    block7: {
                        String oreName;
                        Block block;
                        block9: {
                            int[] oreIds;
                            block8: {
                                block = world.func_147439_a(x, y, z);
                                if (block == Blocks.field_150350_a) break block7;
                                ItemStack s = new ItemStack(block);
                                oreIds = OreDictionary.getOreIDs((ItemStack)s);
                                if (oreIds.length != 0) break block8;
                                if (block != Blocks.field_150420_aW && block != Blocks.field_150419_aX) break block7;
                                oreName = "logWood";
                                break block9;
                            }
                            oreName = OreDictionary.getOreName((int)oreIds[0]);
                        }
                        if (odName.equals(oreName)) {
                            ArrayList<ItemStack> blockDrops = WorldHelper.getBlockDrops(world, player, block, stack, x, y, z);
                            if (PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y, z) && PEToolBase.consumeFuel(player, stack, emcCost, true)) {
                                drops.addAll(blockDrops);
                                world.func_147468_f(x, y, z);
                                if (world.field_73012_v.nextInt(5) == 0) {
                                    PacketHandler.sendToAllAround(new ParticlePKT("largesmoke", x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)(y + 1), (double)z, 32.0));
                                }
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        WorldHelper.createLootDrop(drops, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        PlayerHelper.swingItem(player);
    }

    protected void tillAOE(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int meta, int emcCost) {
        byte charge = this.getCharge(stack);
        boolean hasAction = false;
        boolean hasSoundPlayed = false;
        for (int i = x - charge; i <= x + charge; ++i) {
            for (int j = z - charge; j <= z + charge; ++j) {
                Block block = world.func_147439_a(i, y, j);
                Block blockAbove = world.func_147439_a(i, y + 1, j);
                if (blockAbove.func_149662_c() || block != Blocks.field_150349_c && block != Blocks.field_150346_d) continue;
                if (!hasSoundPlayed) {
                    world.func_72908_a((double)((float)i + 0.5f), (double)((float)y + 0.5f), (double)((float)j + 0.5f), Blocks.field_150458_ak.field_149762_H.func_150498_e(), (Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f);
                    hasSoundPlayed = true;
                }
                if (world.field_72995_K) {
                    return;
                }
                if (MinecraftForge.EVENT_BUS.post((Event)new UseHoeEvent(player, stack, world, i, y, j)) || (i != x || j != z) && !PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
                PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, i, y, j, Blocks.field_150458_ak, 0);
                if ((blockAbove.func_149688_o() == Material.field_151585_k || blockAbove.func_149688_o() == Material.field_151582_l) && !(blockAbove instanceof ITileEntityProvider) && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, i, y + 1, j)) {
                    world.func_147480_a(i, y + 1, j, true);
                }
                if (hasAction) continue;
                hasAction = true;
            }
        }
        if (hasAction) {
            player.field_70170_p.func_72956_a((Entity)player, "projecte:item.pecharge", 1.0f, 1.0f);
        }
    }

    protected void digBasedOnMode(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        int dir;
        if (world.field_72995_K || !(living instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)living;
        byte mode = this.getMode(stack);
        if (mode == 0) {
            return;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)mop.field_72310_e);
        AxisAlignedBB box = mode == 1 ? AxisAlignedBB.func_72330_a((double)x, (double)(y - 1), (double)z, (double)x, (double)(y + 1), (double)z) : (mode == 2 ? (direction.offsetX != 0 ? AxisAlignedBB.func_72330_a((double)x, (double)y, (double)(z - 1), (double)x, (double)y, (double)(z + 1)) : (direction.offsetZ != 0 ? AxisAlignedBB.func_72330_a((double)(x - 1), (double)y, (double)z, (double)(x + 1), (double)y, (double)z) : ((dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 || dir == 2 ? AxisAlignedBB.func_72330_a((double)x, (double)y, (double)(z - 1), (double)x, (double)y, (double)(z + 1)) : AxisAlignedBB.func_72330_a((double)(x - 1), (double)y, (double)z, (double)(x + 1), (double)y, (double)z)))) : (direction.offsetX == 1 ? AxisAlignedBB.func_72330_a((double)(x - 2), (double)y, (double)z, (double)x, (double)y, (double)z) : (direction.offsetX == -1 ? AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 2), (double)y, (double)z) : (direction.offsetZ == 1 ? AxisAlignedBB.func_72330_a((double)x, (double)y, (double)(z - 2), (double)x, (double)y, (double)z) : (direction.offsetZ == -1 ? AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)(z + 2)) : (direction.offsetY == 1 ? AxisAlignedBB.func_72330_a((double)x, (double)(y - 2), (double)z, (double)x, (double)y, (double)z) : AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)(y + 2), (double)z)))))));
        ArrayList drops = Lists.newArrayList();
        int i = (int)box.field_72340_a;
        while ((double)i <= box.field_72336_d) {
            int j = (int)box.field_72338_b;
            while ((double)j <= box.field_72337_e) {
                int k = (int)box.field_72339_c;
                while ((double)k <= box.field_72334_f) {
                    Block b = world.func_147439_a(i, j, k);
                    if (b != Blocks.field_150350_a && b.func_149712_f(world, i, j, k) != -1.0f && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, i, j, k) && (this.canHarvestBlock(block, stack) || ForgeHooks.canToolHarvestBlock((Block)block, (int)world.func_72805_g(i, j, k), (ItemStack)stack))) {
                        drops.addAll(WorldHelper.getBlockDrops(world, player, b, stack, i, j, k));
                        world.func_147468_f(i, j, k);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        WorldHelper.createLootDrop(drops, world, x, y, z);
    }

    protected void digAOE(ItemStack stack, World world, EntityPlayer player, boolean affectDepth, int emcCost) {
        if (world.field_72995_K || this.getCharge(stack) == 0) {
            return;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        AxisAlignedBB box = affectDepth ? WorldHelper.getBroadDeepBox(new Coordinates(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d), ForgeDirection.getOrientation((int)mop.field_72310_e), this.getCharge(stack)) : WorldHelper.getFlatYBox(new Coordinates(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d), this.getCharge(stack));
        ArrayList drops = Lists.newArrayList();
        int i = (int)box.field_72340_a;
        while ((double)i <= box.field_72336_d) {
            int j = (int)box.field_72338_b;
            while ((double)j <= box.field_72337_e) {
                int k = (int)box.field_72339_c;
                while ((double)k <= box.field_72334_f) {
                    Block b = world.func_147439_a(i, j, k);
                    if (b != Blocks.field_150350_a && b.func_149712_f(world, i, j, k) != -1.0f && this.canHarvestBlock(b, stack) && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, i, j, k) && PEToolBase.consumeFuel(player, stack, emcCost, true)) {
                        drops.addAll(WorldHelper.getBlockDrops(world, player, b, stack, i, j, k));
                        world.func_147468_f(i, j, k);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        WorldHelper.createLootDrop(drops, world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        PlayerHelper.swingItem(player);
        if (!drops.isEmpty()) {
            world.func_72956_a((Entity)player, "projecte:item.pedestruct", 1.0f, 1.0f);
        }
    }

    protected void attackWithCharge(ItemStack stack, EntityLivingBase damaged, EntityLivingBase damager, float baseDmg) {
        if (!(damager instanceof EntityPlayer) || damager.field_70170_p.field_72995_K) {
            return;
        }
        DamageSource dmg = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)damager));
        byte charge = this.getCharge(stack);
        float totalDmg = baseDmg;
        if (charge > 0) {
            dmg.func_76348_h();
            totalDmg += (float)charge;
        }
        damaged.func_70097_a(dmg, totalDmg);
    }

    protected void attackAOE(ItemStack stack, EntityPlayer player, boolean slayAll, float damage, int emcCost) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        byte charge = this.getCharge(stack);
        float factor = 2.5f * (float)charge;
        AxisAlignedBB aabb = player.field_70121_D.func_72314_b((double)factor, (double)factor, (double)factor);
        List toAttack = player.field_70170_p.func_72839_b((Entity)player, aabb);
        DamageSource src = DamageSource.func_76365_a((EntityPlayer)player);
        src.func_76348_h();
        for (Entity entity : toAttack) {
            if (!PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
            if (entity instanceof IMob) {
                entity.func_70097_a(src, damage);
                continue;
            }
            if (!(entity instanceof EntityLivingBase) || !slayAll) continue;
            entity.func_70097_a(src, damage);
        }
        player.field_70170_p.func_72956_a((Entity)player, "projecte:item.pecharge", 1.0f, 1.0f);
        PlayerHelper.swingItem(player);
    }

    protected void shearBlock(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(stack, (IBlockAccess)player.field_70170_p, x, y, z) && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y, z)) {
            ArrayList drops = target.onSheared(stack, (IBlockAccess)player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
            Random rand = new Random();
            for (ItemStack drop : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, drop);
                entityitem.field_145804_b = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
    }

    protected void shearEntityAOE(ItemStack stack, EntityPlayer player, int emcCost) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            byte charge = this.getCharge(stack);
            int offset = (int)Math.pow(2.0, 2 + charge);
            AxisAlignedBB bBox = player.field_70121_D.func_72314_b((double)offset, (double)(offset / 2), (double)offset);
            List list = world.func_72872_a(IShearable.class, bBox);
            ArrayList drops = Lists.newArrayList();
            for (Entity ent : list) {
                ArrayList entDrops;
                IShearable target = (IShearable)ent;
                if (target.isShearable(stack, (IBlockAccess)ent.field_70170_p, (int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v) && PEToolBase.consumeFuel(player, stack, emcCost, true) && !(entDrops = target.onSheared(stack, (IBlockAccess)ent.field_70170_p, (int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack))).isEmpty()) {
                    for (ItemStack drop : entDrops) {
                        drop.field_77994_a *= 2;
                    }
                    drops.addAll(entDrops);
                }
                if (!(Math.random() < 0.01)) continue;
                Entity e = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)ent), (World)world);
                e.func_82141_a(ent, true);
                if (e instanceof EntitySheep) {
                    ((EntitySheep)e).func_70891_b(MathUtils.randomIntInRange(0, 16));
                }
                if (e instanceof EntityAgeable) {
                    ((EntityAgeable)e).func_70873_a(-24000);
                }
                world.func_72838_d(e);
            }
            WorldHelper.createLootDrop(drops, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            PlayerHelper.swingItem(player);
        }
    }

    protected void tryVeinMine(ItemStack stack, EntityPlayer player, MovingObjectPosition mop) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        AxisAlignedBB aabb = WorldHelper.getBroadDeepBox(new Coordinates(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d), ForgeDirection.getOrientation((int)mop.field_72310_e), this.getCharge(stack));
        Block target = player.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        if (target.func_149712_f(player.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) <= -1.0f || !this.canHarvestBlock(target, stack) && !ForgeHooks.canToolHarvestBlock((Block)target, (int)player.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d), (ItemStack)stack)) {
            return;
        }
        ArrayList drops = Lists.newArrayList();
        int i = (int)aabb.field_72340_a;
        while ((double)i <= aabb.field_72336_d) {
            int j = (int)aabb.field_72338_b;
            while ((double)j <= aabb.field_72337_e) {
                int k = (int)aabb.field_72339_c;
                while ((double)k <= aabb.field_72334_f) {
                    Block b = player.field_70170_p.func_147439_a(i, j, k);
                    if (b == target) {
                        WorldHelper.harvestVein(player.field_70170_p, player, stack, new Coordinates(i, j, k), b, drops, 0);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        WorldHelper.createLootDrop(drops, player.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        if (!drops.isEmpty()) {
            player.field_70170_p.func_72956_a((Entity)player, "projecte:item.pedestruct", 1.0f, 1.0f);
        }
    }

    protected void mineOreVeinsInAOE(ItemStack stack, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        int offset = this.getCharge(stack) + 3;
        AxisAlignedBB box = player.field_70121_D.func_72314_b((double)offset, (double)offset, (double)offset);
        ArrayList drops = Lists.newArrayList();
        World world = player.field_70170_p;
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    Block block = world.func_147439_a(x, y, z);
                    if (ItemHelper.isOre(block, world.func_72805_g(x, y, z)) && block.func_149712_f(player.field_70170_p, x, y, z) != -1.0f && (this.canHarvestBlock(block, stack) || ForgeHooks.canToolHarvestBlock((Block)block, (int)world.func_72805_g(x, y, z), (ItemStack)stack))) {
                        WorldHelper.harvestVein(world, player, stack, new Coordinates(x, y, z), block, drops, 0);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (!drops.isEmpty()) {
            WorldHelper.createLootDrop(drops, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            PlayerHelper.swingItem(player);
        }
    }
}

