/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.handlers;

import com.google.common.collect.Sets;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Set;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.IStepAssister;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public final class PlayerChecks {
    private static final Set<EntityPlayerMP> swrgOverrides = Sets.newHashSet();
    private static final Set<EntityPlayerMP> gemArmorReadyChecks = Sets.newHashSet();
    private static final Set<EntityPlayerMP> hadFlightItem = Sets.newHashSet();
    private static final TObjectIntHashMap<EntityPlayerMP> projectileCooldowns = new TObjectIntHashMap();

    public static void resetCooldown(EntityPlayerMP player) {
        projectileCooldowns.put((Object)player, ProjectEConfig.projectileCooldown);
    }

    public static int getCooldown(EntityPlayerMP player) {
        return projectileCooldowns.containsKey((Object)player) ? projectileCooldowns.get((Object)player) : -1;
    }

    public static void setGemState(EntityPlayerMP player, boolean state) {
        if (state) {
            gemArmorReadyChecks.add(player);
        } else {
            gemArmorReadyChecks.remove(player);
        }
    }

    public static boolean getGemState(EntityPlayerMP player) {
        return gemArmorReadyChecks.contains(player);
    }

    public static void update(EntityPlayerMP player) {
        if (projectileCooldowns.containsKey((Object)player) && projectileCooldowns.get((Object)player) > 0) {
            projectileCooldowns.adjustValue((Object)player, -1);
        }
        if (!PlayerChecks.shouldPlayerFly(player) && hadFlightItem.contains(player)) {
            if (player.field_71075_bZ.field_75101_c) {
                PlayerHelper.updateClientServerFlight(player, false);
            }
            hadFlightItem.remove(player);
        } else if (PlayerChecks.shouldPlayerFly(player) && !hadFlightItem.contains(player)) {
            if (!player.field_71075_bZ.field_75101_c) {
                PlayerHelper.updateClientServerFlight(player, true);
            }
            hadFlightItem.add(player);
        }
        if (!PlayerChecks.shouldPlayerResistFire(player)) {
            if (player.func_70045_F()) {
                PlayerHelper.setPlayerFireImmunity((EntityPlayer)player, false);
            }
        } else if (!player.func_70045_F()) {
            PlayerHelper.setPlayerFireImmunity((EntityPlayer)player, true);
        }
        if (!PlayerChecks.shouldPlayerStep(player)) {
            if (player.field_70138_W > 0.5f) {
                PlayerHelper.updateClientServerStepHeight(player, 0.5f);
            }
        } else if (player.field_70138_W < 1.0f) {
            PlayerHelper.updateClientServerStepHeight(player, 1.0f);
        }
    }

    public static void onPlayerChangeDimension(EntityPlayerMP playerMP) {
        PlayerHelper.updateClientServerFlight(playerMP, playerMP.field_71075_bZ.field_75101_c);
        PlayerHelper.updateClientServerStepHeight(playerMP, PlayerChecks.shouldPlayerStep(playerMP) ? 1.0f : 0.5f);
    }

    private static boolean shouldPlayerFly(EntityPlayerMP player) {
        if (!PlayerChecks.hasSwrg(player)) {
            PlayerChecks.disableSwrgFlightOverride(player);
        }
        if (player.field_71075_bZ.field_75098_d || swrgOverrides.contains(player)) {
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack == null || !(stack.func_77973_b() instanceof IFlightProvider) || !((IFlightProvider)stack.func_77973_b()).canProvideFlight(stack, player)) continue;
            return true;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IFlightProvider) || !((IFlightProvider)stack.func_77973_b()).canProvideFlight(stack, player)) continue;
            return true;
        }
        IInventory baubles = PlayerHelper.getBaubles((EntityPlayer)player);
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack stack = baubles.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof IFlightProvider) || !((IFlightProvider)stack.func_77973_b()).canProvideFlight(stack, player)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean shouldPlayerResistFire(EntityPlayerMP player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack == null || !(stack.func_77973_b() instanceof IFireProtector) || !((IFireProtector)stack.func_77973_b()).canProtectAgainstFire(stack, player)) continue;
            return true;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IFireProtector) || !((IFireProtector)stack.func_77973_b()).canProtectAgainstFire(stack, player)) continue;
            return true;
        }
        IInventory baubles = PlayerHelper.getBaubles((EntityPlayer)player);
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack stack = baubles.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof IFireProtector) || !((IFireProtector)stack.func_77973_b()).canProtectAgainstFire(stack, player)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean shouldPlayerStep(EntityPlayerMP player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack == null || !(stack.func_77973_b() instanceof IStepAssister) || !((IStepAssister)stack.func_77973_b()).canAssistStep(stack, player)) continue;
            return true;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IStepAssister) || !((IStepAssister)stack.func_77973_b()).canAssistStep(stack, player)) continue;
            return true;
        }
        IInventory baubles = PlayerHelper.getBaubles((EntityPlayer)player);
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack stack = baubles.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof IStepAssister) || !((IStepAssister)stack.func_77973_b()).canAssistStep(stack, player)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasSwrg(EntityPlayerMP player) {
        for (int i = 0; i <= 8; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != ObjHandler.swrg) continue;
            return true;
        }
        IInventory baubles = PlayerHelper.getBaubles((EntityPlayer)player);
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                if (baubles.func_70301_a(i) == null || baubles.func_70301_a(i).func_77973_b() != ObjHandler.swrg) continue;
                return true;
            }
        }
        return false;
    }

    public static void enableSwrgFlightOverride(EntityPlayerMP player) {
        swrgOverrides.add(player);
    }

    public static void disableSwrgFlightOverride(EntityPlayerMP player) {
        swrgOverrides.remove(player);
    }

    public static void clearLists() {
        swrgOverrides.clear();
        gemArmorReadyChecks.clear();
        hadFlightItem.clear();
        projectileCooldowns.clear();
    }

    public static void removePlayerFromLists(EntityPlayerMP player) {
        swrgOverrides.remove(player);
        gemArmorReadyChecks.remove(player);
        hadFlightItem.remove(player);
        projectileCooldowns.remove((Object)player);
    }
}

