/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.api.item.IItemCharge;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.gameObjs.items.armor.GemChest;
import moze_intel.projecte.gameObjs.items.armor.GemFeet;
import moze_intel.projecte.gameObjs.items.armor.GemHelmet;
import moze_intel.projecte.handlers.PlayerChecks;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class KeyPressPKT
implements IMessage {
    private PEKeybind key;

    public KeyPressPKT() {
    }

    public KeyPressPKT(PEKeybind key) {
        this.key = key;
    }

    public void fromBytes(ByteBuf buf) {
        this.key = PEKeybind.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.key.ordinal());
    }

    public static class Handler
    implements IMessageHandler<KeyPressPKT, IMessage> {
        public IMessage onMessage(KeyPressPKT message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = player.func_70694_bm();
            switch (message.key) {
                case ARMOR_TOGGLE: {
                    if (player.func_70093_af()) {
                        ItemStack helm = player.field_71071_by.func_70440_f(3);
                        if (helm == null || helm.func_77973_b() != ObjHandler.gemHelmet) break;
                        GemHelmet.toggleNightVision(helm, (EntityPlayer)player);
                        break;
                    }
                    ItemStack boots = player.field_71071_by.func_70440_f(0);
                    if (boots == null || boots.func_77973_b() != ObjHandler.gemFeet) break;
                    ((GemFeet)ObjHandler.gemFeet).toggleStepAssist(boots, (EntityPlayer)player);
                    break;
                }
                case CHARGE: {
                    if (stack != null && stack.func_77973_b() instanceof IItemCharge) {
                        ((IItemCharge)stack.func_77973_b()).changeCharge((EntityPlayer)player, stack);
                        break;
                    }
                    if (stack != null && !ProjectEConfig.unsafeKeyBinds || !GemArmorBase.hasAnyPiece((EntityPlayer)player)) break;
                    PlayerChecks.setGemState(player, !PlayerChecks.getGemState(player));
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation(PlayerChecks.getGemState(player) ? "pe.gem.activate" : "pe.gem.deactivate", new Object[0]));
                    break;
                }
                case EXTRA_FUNCTION: {
                    if (stack != null && stack.func_77973_b() instanceof IExtraFunction) {
                        ((IExtraFunction)stack.func_77973_b()).doExtraFunction(stack, (EntityPlayer)player);
                        break;
                    }
                    if (stack != null && !ProjectEConfig.unsafeKeyBinds || !PlayerChecks.getGemState(player) || player.field_71071_by.field_70460_b[2] == null || player.field_71071_by.field_70460_b[2].func_77973_b() != ObjHandler.gemChest) break;
                    ((GemChest)ObjHandler.gemChest).doExplode((EntityPlayer)player);
                    break;
                }
                case FIRE_PROJECTILE: {
                    if (stack != null && stack.func_77973_b() instanceof IProjectileShooter) {
                        if (PlayerChecks.getCooldown(player) > 0) break;
                        if (((IProjectileShooter)stack.func_77973_b()).shootProjectile((EntityPlayer)player, stack)) {
                            PlayerHelper.swingItem((EntityPlayer)player);
                        }
                        PlayerChecks.resetCooldown(player);
                        break;
                    }
                    if (stack != null && !ProjectEConfig.unsafeKeyBinds || !PlayerChecks.getGemState(player) || player.field_71071_by.field_70460_b[3] == null || player.field_71071_by.field_70460_b[3].func_77973_b() != ObjHandler.gemHelmet) break;
                    ((GemHelmet)ObjHandler.gemHelmet).doZap((EntityPlayer)player);
                    break;
                }
                case MODE: {
                    if (stack == null || !(stack.func_77973_b() instanceof IModeChanger)) break;
                    ((IModeChanger)stack.func_77973_b()).changeMode((EntityPlayer)player, stack);
                }
            }
            return null;
        }
    }
}

