/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.computer;

import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.reference.GuiIDs;
import com.bluepowermod.tile.tier3.TileCPU;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCPU
extends BlockContainerBase {
    @SideOnly(value=Side.CLIENT)
    protected IIcon topTexture;
    @SideOnly(value=Side.CLIENT)
    protected IIcon frontTexture;
    @SideOnly(value=Side.CLIENT)
    protected IIcon sideTexture;
    @SideOnly(value=Side.CLIENT)
    protected IIcon backTexture;
    @SideOnly(value=Side.CLIENT)
    protected IIcon bottomTexture;

    public BlockCPU() {
        super(Material.field_151573_f, TileCPU.class);
        this.func_149663_c("cpu");
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileCPU) {
            // empty if block
        }
    }

    @Override
    public GuiIDs getGuiID() {
        return GuiIDs.CPU;
    }

    public int func_149738_a(World world) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        if (side == dir.ordinal()) {
            return this.topTexture;
        }
        if (side == dir.getOpposite().ordinal()) {
            return this.bottomTexture;
        }
        if (side == ForgeDirection.WEST.ordinal()) {
            return this.frontTexture;
        }
        if (side == ForgeDirection.EAST.ordinal()) {
            return this.backTexture;
        }
        return this.sideTexture;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileCPU tile = (TileCPU)world.func_147438_o(x, y, z);
        ForgeDirection dir = tile.getFacingDirection();
        if (dir.ordinal() == side) {
            return this.frontTexture;
        }
        if (dir.getOpposite().ordinal() == side) {
            return this.backTexture;
        }
        if (ForgeDirection.UP.ordinal() == side) {
            return this.topTexture;
        }
        if (ForgeDirection.DOWN.ordinal() == side) {
            return this.bottomTexture;
        }
        return this.sideTexture;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.frontTexture = iconRegister.func_94245_a("bluepower:machines/cpu_front");
        this.sideTexture = iconRegister.func_94245_a("bluepower:machines/cpu_side");
        this.topTexture = iconRegister.func_94245_a("bluepower:machines/cpu_top");
        this.backTexture = iconRegister.func_94245_a("bluepower:machines/cpu_back");
        this.bottomTexture = iconRegister.func_94245_a("bluepower:machines/cpu_bottom");
    }
}

