/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.worldgen;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCrop
extends BlockCrops
implements IGrowable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockCrop() {
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149649_H();
        this.func_149663_c("flax_crop");
        this.func_149658_d("bluepower:flax_crop");
    }

    public String func_149739_a() {
        return String.format("tile.%s:%s", "bluepower", this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    String getUnwrappedUnlocalizedName(String name) {
        return name.substring(name.indexOf(".") + 1);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        if (l <= 2) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
        } else if (l <= 4) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else if (l <= 6) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (world.func_147439_a(x, y, z) instanceof BlockCrop && world.func_72805_g(x, y, z) == 8) {
            world.func_72921_c(x, y - 1, z, 5, 2);
        }
    }

    protected boolean func_149854_a(Block block) {
        return block == Blocks.field_150458_ak;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.func_72957_l(x, y + 1, z) >= 9) {
            int meta = world.func_72805_g(x, y, z);
            if (meta < 7 && world.func_147439_a(x, y - 1, z) instanceof BlockFarmland && random.nextInt(30) == 0) {
                world.func_72921_c(x, y, z, meta + 1, 2);
            }
            if (meta == 7 && world.func_147439_a(x, y - 1, z) instanceof BlockFarmland && world.func_147439_a(x, y + 1, z) instanceof BlockAir) {
                world.func_147465_d(x, y + 1, z, BPBlocks.flax_crop, 8, 2);
            }
            if (meta > 7 && world.func_147439_a(x, y - 1, z) instanceof BlockFarmland) {
                world.func_72921_c(x, y, z, 7, 2);
                world.func_147465_d(x, y + 1, z, BPBlocks.flax_crop, 8, 2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta > 8) {
            meta = 8;
        }
        return this.iconArray[meta];
    }

    public int func_149645_b() {
        return 6;
    }

    protected Item func_149866_i() {
        return BPItems.flax_seeds;
    }

    protected Item func_149865_P() {
        return Items.field_151007_F;
    }

    public void func_149690_a(World world, int x, int y, int z, int p_149690_5_, float p_149690_6_, int p_149690_7_) {
        super.func_149690_a(world, x, y, z, p_149690_5_, p_149690_6_, 0);
    }

    public Item func_149650_a(int meta, Random random, int p_149650_3_) {
        return meta == 8 ? this.func_149865_P() : this.func_149866_i();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        return world.func_72805_g(x, y, z) < 7;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return this.func_149866_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconArray = new IIcon[9];
        for (int i = 0; i < this.iconArray.length; ++i) {
            int tex = 0;
            if (i == 0 || i == 1) {
                tex = 0;
            } else if (i == 2) {
                tex = 1;
            } else if (i == 3 || i == 4) {
                tex = 2;
            } else if (i == 5 || i == 6) {
                tex = 3;
            } else if (i == 7) {
                tex = 4;
            } else if (i == 8) {
                tex = 5;
            }
            this.iconArray[i] = iconRegister.func_94245_a(this.func_149641_N() + "_stage_" + tex);
        }
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (world.func_147439_a(x, y + 1, z) instanceof BlockAir && meta < 7 && !(world.func_147439_a(x, y - 1, z) instanceof BlockCrop)) {
            if ((meta += MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5)) > 6) {
                world.func_72921_c(x, y, z, 7, 2);
                world.func_147465_d(x, y + 1, z, BPBlocks.flax_crop, 8, 2);
            } else {
                world.func_72921_c(x, y, z, meta, 2);
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata >= 8) {
            for (int i = 0; i < 3 + fortune; ++i) {
                if (world.field_73012_v.nextInt(15) > metadata) continue;
                ret.add(new ItemStack(this.func_149865_P(), 1, 0));
            }
            if (world.field_73012_v.nextBoolean()) {
                ret.add(new ItemStack(this.func_149866_i(), 1, 0));
            }
        } else if (metadata == 7) {
            ret.add(new ItemStack(this.func_149866_i(), 1 + world.field_73012_v.nextInt(2), 0));
        } else {
            ret.add(new ItemStack(this.func_149866_i(), 1, 0));
        }
        return ret;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && world.func_147437_c(x, y + 1, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (world.func_72805_g(x, y, z) == 7 && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (world.func_72805_g(x, y, z) == 8 && world.func_72805_g(x, y - 1, z) != 7) {
            world.func_147468_f(x, y, z);
        }
        if (world.func_72805_g(x, y, z) < 8 && world.func_147439_a(x, y - 1, z) instanceof BlockCrop) {
            world.func_147468_f(x, y, z);
        }
        this.func_149855_e(world, x, y, z);
    }

    protected void func_149855_e(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            int l = world.func_72805_g(x, y, z);
            this.func_149697_b(world, x, y, z, l, 0);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this) {
            return super.func_149718_j(world, x, y, z);
        }
        if (world.func_147439_a(x, y - 1, z).canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this) && world.func_147439_a(x, y - 1, z).isFertile(world, x, y - 1, z)) {
            return true;
        }
        return world.func_147439_a(x, y - 1, z) instanceof BlockCrop && world.func_72805_g(x, y - 1, z) == 7;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }
}

