/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui;

import com.bluepowermod.BluePower;
import com.bluepowermod.client.gui.GuiCircuitTable;
import com.bluepowermod.container.ContainerCircuitDatabaseSharing;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageCircuitDatabaseTemplate;
import com.bluepowermod.network.message.MessageGuiUpdate;
import com.bluepowermod.tile.tier3.TileCircuitDatabase;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import uk.co.qmunity.lib.client.gui.widget.BaseWidget;
import uk.co.qmunity.lib.client.gui.widget.IGuiWidget;
import uk.co.qmunity.lib.client.gui.widget.WidgetTab;

@SideOnly(value=Side.CLIENT)
public class GuiCircuitDatabaseSharing
extends GuiCircuitTable {
    private final TileCircuitDatabase circuitDatabase;
    private int curDeletingTemplate = -1;

    public GuiCircuitDatabaseSharing(InventoryPlayer invPlayer, TileCircuitDatabase circuitDatabase) {
        super(circuitDatabase, (Container)new ContainerCircuitDatabaseSharing(invPlayer, circuitDatabase), guiTexture);
        this.circuitDatabase = circuitDatabase;
        this.field_146291_p = true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        WidgetTab widget = new WidgetTab(1, this.field_147003_i - 32, this.field_147009_r + 10, 33, 35, 198, 3, "bluepower:textures/gui/circuit_database.png"){

            protected void addTooltip(int curHoveredTab, List<String> curTip, boolean shiftPressed) {
                switch (curHoveredTab) {
                    case 0: {
                        curTip.add("gui.bluepower:circuitDatabase.tab.copyAndShare");
                        break;
                    }
                    case 1: {
                        curTip.add("gui.bluepower:circuitDatabase.tab.private");
                        break;
                    }
                    case 2: {
                        curTip.add("gui.bluepower:circuitDatabase.tab.server");
                        if (!Minecraft.func_71410_x().func_71356_B()) break;
                        curTip.add("gui.bluepower:circuitDatabase.info.serverOnly");
                    }
                }
            }
        };
        widget.value = this.circuitDatabase.clientCurrentTab;
        widget.enabledTabs[2] = !Minecraft.func_71410_x().func_71356_B();
        this.addWidget((IGuiWidget)widget);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void func_146984_a(Slot slot, int p_146984_2_, int p_146984_3_, int p_146984_4_) {
        block5: {
            block6: {
                if (slot == null || !slot.func_75216_d() || slot.field_75224_c != this.circuitDatabase.circuitInventory) break block6;
                if (BluePower.proxy.isSneakingInGui()) {
                    if (slot.getSlotIndex() != this.curDeletingTemplate) {
                        this.curDeletingTemplate = slot.getSlotIndex();
                        return;
                    }
                    if (this.circuitDatabase.clientCurrentTab == 1) {
                        this.circuitDatabase.stackDatabase.deleteStack(slot.func_75211_c());
                        this.circuitDatabase.updateGateInventory();
                        break block5;
                    } else {
                        BPNetworkHandler.INSTANCE.sendToServer((IMessage)new MessageCircuitDatabaseTemplate(this.circuitDatabase, slot.func_75211_c(), true));
                    }
                    break block5;
                } else {
                    this.circuitDatabase.clientCurrentTab = 0;
                    BPNetworkHandler.INSTANCE.sendToServer((IMessage)new MessageCircuitDatabaseTemplate(this.circuitDatabase, slot.func_75211_c()));
                }
                break block5;
            }
            super.func_146984_a(slot, p_146984_2_, p_146984_3_, p_146984_4_);
        }
        this.curDeletingTemplate = -1;
    }

    public ItemStack getCurrentDeletingTemplate() {
        return this.curDeletingTemplate == -1 ? null : this.field_147002_h.func_75139_a(this.curDeletingTemplate).func_75211_c();
    }

    @Override
    protected boolean shouldDisplayRed(ItemStack stack) {
        if ((this.circuitDatabase.clientCurrentTab == 1 || this.circuitDatabase.clientCurrentTab == 2) && this.circuitDatabase.copyInventory.func_70301_a(1) != null) {
            return !this.circuitDatabase.copy((EntityPlayer)Minecraft.func_71410_x().field_71439_g, stack, this.circuitDatabase.copyInventory.func_70301_a(1), true);
        }
        return false;
    }

    public void actionPerformed(IGuiWidget widget) {
        if (widget.getID() == 1) {
            this.circuitDatabase.clientCurrentTab = ((BaseWidget)widget).value;
        }
        BPNetworkHandler.INSTANCE.sendToServer((IMessage)new MessageGuiUpdate(this.circuitDatabase, widget.getID(), ((BaseWidget)widget).value));
    }

    protected boolean isInfoStatLeftSided() {
        return false;
    }
}

