/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui.gate;

import com.bluepowermod.api.misc.Accessibility;
import com.bluepowermod.api.wireless.IFrequency;
import com.bluepowermod.client.gui.gate.GuiGate;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageWirelessNewFreq;
import com.bluepowermod.network.message.MessageWirelessRemoveFreq;
import com.bluepowermod.network.message.MessageWirelessSaveFreq;
import com.bluepowermod.part.PartManager;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.wireless.Frequency;
import com.bluepowermod.part.gate.wireless.IWirelessGate;
import com.bluepowermod.part.gate.wireless.WirelessManager;
import com.bluepowermod.part.gate.wireless.WirelessMode;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.gui.widget.IGuiWidget;
import uk.co.qmunity.lib.client.gui.widget.WidgetMode;
import uk.co.qmunity.lib.util.AlphanumComparator;

@SideOnly(value=Side.CLIENT)
public class GuiGateWireless
extends GuiGate {
    private static final ResourceLocation resLoc = new ResourceLocation("bluepower", "textures/gui/wirelessRedstone.png");
    private WidgetMode filterAccessLevel;
    private WidgetMode accessLevel;
    private WidgetMode addFrequency;
    private WidgetMode removeFrequency;
    private WidgetMode saveFrequency;
    private WidgetMode modeSelector;
    private GuiTextField frequencyName;
    private Accessibility acc = Accessibility.PUBLIC;
    private IWirelessGate gate;
    private Frequency selected = null;
    private String filter = "";
    private int scrolled = 0;

    public GuiGateWireless(GateBase<?, ?, ?, ?, ?, ?> gate, boolean bundled, WirelessMode mode) {
        super(gate, 228, 184);
        this.gate = (IWirelessGate)((Object)gate);
    }

    @Override
    protected ResourceLocation getTexture() {
        return resLoc;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        Mouse.getDWheel();
        this.accessLevel = new WidgetMode(0, this.guiLeft + 10, this.guiTop + this.ySize - 24, 228, 0, Accessibility.values().length, new String[]{"bluepower:textures/gui/wirelessRedstone.png"}){

            public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
                curTip.add((((GuiGateWireless)GuiGateWireless.this).accessLevel.enabled ? "" : EnumChatFormatting.GRAY) + "Accessability");
            }
        };
        this.addWidget((IGuiWidget)this.accessLevel);
        this.filterAccessLevel = new WidgetMode(1, this.guiLeft + 12, this.guiTop + 35, 228, 0, Accessibility.values().length + 2, new String[]{"bluepower:textures/gui/wirelessRedstone.png"});
        this.addWidget((IGuiWidget)this.filterAccessLevel);
        this.filterAccessLevel.value = 4;
        this.addFrequency = new WidgetMode(3, this.guiLeft + 10, this.guiTop + this.ySize - 24 - 14 - 3, 242, 0, 1, new String[]{"bluepower:textures/gui/wirelessRedstone.png"}){

            public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
                curTip.add((((GuiGateWireless)GuiGateWireless.this).addFrequency.enabled ? "" : EnumChatFormatting.GRAY) + "Add frequency");
            }
        };
        this.addWidget((IGuiWidget)this.addFrequency);
        this.saveFrequency = new WidgetMode(4, this.guiLeft + 37, this.guiTop + this.ySize - 24 - 14 - 3, 242, 28, 1, new String[]{"bluepower:textures/gui/wirelessRedstone.png"}){

            public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
                curTip.add((((GuiGateWireless)GuiGateWireless.this).saveFrequency.enabled ? "" : EnumChatFormatting.GRAY) + "Save changes");
            }
        };
        this.addWidget((IGuiWidget)this.saveFrequency);
        this.removeFrequency = new WidgetMode(5, this.guiLeft + 88 - 10 - 14, this.guiTop + this.ySize - 24 - 14 - 3, 242, 14, 1, new String[]{"bluepower:textures/gui/wirelessRedstone.png"}){

            public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
                if (GuiGateWireless.this.gate.getFrequency() != null && (GuiGateWireless.this.selected == null || GuiGateWireless.this.selected.equals(GuiGateWireless.this.gate.getFrequency()))) {
                    curTip.add("Unselect frequency");
                } else if (GuiGateWireless.this.selected != null) {
                    curTip.add("Remove frequency");
                } else {
                    curTip.add(EnumChatFormatting.GRAY + "Select a frequency");
                }
            }
        };
        this.addWidget((IGuiWidget)this.removeFrequency);
        this.modeSelector = new WidgetMode(6, this.guiLeft + 10, this.guiTop + 57, 228, 70, 3, new String[]{"bluepower:textures/gui/wirelessRedstone.png"});
        this.addWidget((IGuiWidget)this.modeSelector);
        this.modeSelector.value = this.gate.getMode().ordinal();
        this.frequencyName = new GuiTextField(this.field_146289_q, this.guiLeft + 88, this.guiTop + 22, 133, 10);
        this.accessLevel.enabled = false;
        this.saveFrequency.enabled = false;
        this.addFrequency.enabled = false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char c, int key) {
        super.func_73869_a(c, key);
        if (c == '\r') {
            this.actionPerformed((IGuiWidget)this.addFrequency);
            return;
        }
        this.frequencyName.func_146201_a(c, key);
        if (this.selected == null) {
            this.filter = this.frequencyName.func_146179_b().trim();
            this.fixScrollWheel();
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.frequencyName.func_146192_a(x, y, button);
        if (x > this.frequencyName.field_146209_f && x < this.frequencyName.field_146209_f + this.frequencyName.field_146218_h && y > this.frequencyName.field_146210_g && y < this.frequencyName.field_146210_g + this.frequencyName.field_146219_i && button == 1) {
            this.frequencyName.func_146180_a("");
            if (this.selected == null) {
                this.filter = "";
            }
        }
        List<Frequency> frequencies = this.getFrequencies();
        if (x > this.guiLeft + 88 && x <= this.guiLeft + 88 + 133 - (frequencies.size() > 12 ? 11 : 0)) {
            for (int i = 0; i < Math.min(frequencies.size(), 12); ++i) {
                int yPos;
                Frequency f = frequencies.get(i + this.scrolled);
                if (f.isBundled() != this.gate.isBundled() || y <= (yPos = this.guiTop + 22 + 10 + 2 + i * 12) || y >= yPos + 11) continue;
                if (button == 0) {
                    if (f.equals(this.selected)) {
                        BPNetworkHandler.INSTANCE.sendToServer((IMessage)new MessageWirelessNewFreq(this.gate, f.getAccessibility(), f.getFrequencyName(), f.isBundled()));
                    } else {
                        this.selected = f;
                        this.frequencyName.func_146180_a(f.getFrequencyName());
                        this.acc = f.getAccessibility();
                        this.accessLevel.value = this.acc.ordinal();
                    }
                } else if (button == 1) {
                    this.selected = null;
                    this.frequencyName.func_146180_a(this.filter);
                }
                return;
            }
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int scrolled = Mouse.getEventDWheel();
        if (scrolled != 0) {
            this.scrolled = scrolled < 0 ? ++this.scrolled : --this.scrolled;
            this.fixScrollWheel();
        }
    }

    private void fixScrollWheel() {
        this.scrolled = Math.max(Math.min(this.scrolled, this.getFrequencies().size() - 12), 0);
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        super.actionPerformed(widget);
        if (widget == this.filterAccessLevel) {
            if (this.filterAccessLevel.value == 3 && !Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                ++this.filterAccessLevel.value;
            }
            if (this.selected != null && !this.selected.equals(this.gate.getFrequency())) {
                this.frequencyName.func_146180_a("");
                this.filter = "";
            }
            this.selected = null;
        }
        if (widget == this.modeSelector) {
            this.sendToServer(0, this.modeSelector.value);
        }
        if (widget == this.addFrequency) {
            BPNetworkHandler.INSTANCE.sendToServer((IMessage)new MessageWirelessNewFreq(this.gate, this.acc, this.frequencyName.func_146179_b().trim(), this.gate.isBundled()));
        }
        if (widget == this.saveFrequency) {
            BPNetworkHandler.INSTANCE.sendToServer((IMessage)new MessageWirelessSaveFreq(this.selected, this.acc, this.frequencyName.func_146179_b().trim()));
            this.filter = "";
        }
        if (widget == this.removeFrequency) {
            if (this.gate.getFrequency() != null && (this.selected == null || this.selected.equals(this.gate.getFrequency()))) {
                this.sendToServer(1, 0);
            } else if (this.selected != null) {
                BPNetworkHandler.INSTANCE.sendToServer((IMessage)new MessageWirelessRemoveFreq(this.selected));
                this.selected = null;
            }
        }
        if (widget == this.accessLevel) {
            this.acc = Accessibility.values()[this.accessLevel.value];
        }
    }

    @Override
    protected void renderGUI(int x, int y, float partialTick) {
        int yPos;
        Frequency f;
        int i;
        super.renderGUI(x, y, partialTick);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        String txt = this.frequencyName.func_146179_b();
        this.removeFrequency.enabled = this.gate.getFrequency() != null && (this.gate.getFrequency().getOwner().equals(player.func_146103_bH().getId()) || player.field_71075_bZ.field_75098_d) || this.selected != null && (this.selected.getOwner().equals(player.func_146103_bH().getId()) || player.field_71075_bZ.field_75098_d);
        this.accessLevel.enabled = this.selected != null || txt.trim().length() > 0 && this.checkNoMatches();
        this.saveFrequency.enabled = this.selected != null && (this.acc != this.selected.getAccessibility() || txt.trim().length() > 0 && !txt.trim().equals(this.selected.getFrequencyName()));
        this.addFrequency.enabled = this.selected == null && txt.trim().length() > 0 && this.checkNoMatches();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"bluepower.gui.wireless", (Object[])new Object[0]), this.guiLeft + this.xSize / 2, this.guiTop + 8, 0xEFEFEF);
        this.func_73732_a(this.field_146289_q, "Filter", this.guiLeft + 45, this.guiTop + 22 + 3, 0xEFEFEF);
        String accessLevelLabel = this.filterAccessLevel.value == 0 ? "bluepower.accessability.public" : (this.filterAccessLevel.value == 1 ? "bluepower.accessability.shared" : (this.filterAccessLevel.value == 2 ? "bluepower.accessability.private" : (this.filterAccessLevel.value == 3 ? "bluepower.gui.admin" : "bluepower.gui.none")));
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)accessLevelLabel, (Object[])new Object[0]), this.guiLeft + 12 + 14 + 3, this.guiTop + 35 + 3, this.filterAccessLevel.enabled ? 0xEFEFEF : 0x565656);
        accessLevelLabel = this.accessLevel.value == 0 ? "bluepower.accessability.public" : (this.accessLevel.value == 1 ? "bluepower.accessability.shared" : "bluepower.accessability.private");
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)accessLevelLabel, (Object[])new Object[0]), this.guiLeft + 10 + 14 + 3, this.guiTop + this.ySize - 24 + 3, this.accessLevel.enabled ? 0xEFEFEF : 0x565656);
        String modeLabel = this.modeSelector.value == 0 ? "bluepower.mode.sendreceive" : (this.modeSelector.value == 1 ? "bluepower.mode.send" : "bluepower.mode.receive");
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)modeLabel, (Object[])new Object[0]), this.guiLeft + 10 + 14 + 3, this.guiTop + 57 + 3, 0xEFEFEF);
        this.frequencyName.func_146194_f();
        List<Frequency> frequencies = this.getFrequencies();
        for (i = 0; i < Math.min(frequencies.size(), 12); ++i) {
            int color;
            f = frequencies.get(i + this.scrolled);
            yPos = this.guiTop + 22 + 10 + 2 + i * 12;
            int n = f.equals(this.gate.getFrequency()) ? 52428 : (f.equals(this.selected) ? 0x888888 : (x > this.guiLeft + 88 && x <= this.guiLeft + 88 + 133 - (frequencies.size() > 12 ? 11 : 0) && y > yPos && y <= yPos + 11 && f.isBundled() == this.gate.isBundled() ? 0xAAAAAA : (color = 0x333333)));
            int textColor = f.equals(this.gate.getFrequency()) ? 0x333333 : (f.isBundled() != this.gate.isBundled() ? 0x999999 : 0xFFFFFF);
            GuiGateWireless.func_73734_a((int)(this.guiLeft + 88), (int)yPos, (int)(this.guiLeft + 88 + 133 - (frequencies.size() > 12 ? 11 : 0)), (int)(yPos + 11), (int)(-16777216 + color));
            String format = f.isBundled() != this.gate.isBundled() ? EnumChatFormatting.STRIKETHROUGH.toString() : "";
            String txt2 = format + f.getFrequencyName() + (this.filterAccessLevel.value == 3 || this.filterAccessLevel.value == 4 ? " [" + StringUtils.capitalize((String)f.getAccessibility().name().toLowerCase()) + "]" : "");
            this.field_146289_q.func_85187_a(txt2, this.guiLeft + 88 + 2 + 12 + 2, yPos + 2, textColor, !f.equals(this.gate.getFrequency()));
            ItemStack item = PartManager.getPartInfo("wire.bluestone" + (f.isBundled() ? ".bundled" : "")).getStack();
            GL11.glPushMatrix();
            if (f.isBundled() != this.gate.isBundled()) {
                GL11.glEnable((int)2896);
            }
            GL11.glTranslated((double)(this.guiLeft + 88 + 1), (double)(yPos - 2), (double)0.0);
            GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
            ForgeHooksClient.renderInventoryItem((RenderBlocks)RenderBlocks.getInstance(), (TextureManager)Minecraft.func_71410_x().field_71446_o, (ItemStack)item, (boolean)true, (float)1.0f, (float)1.0f, (float)1.0f);
            if (f.isBundled() != this.gate.isBundled()) {
                GL11.glDisable((int)2896);
            }
            GL11.glPopMatrix();
        }
        if (frequencies.size() > 12) {
            GuiGateWireless.func_73734_a((int)(this.guiLeft + 88 + 133 - 10), (int)(this.guiTop + 22 + 10 + 2), (int)(this.guiLeft + 88 + 133), (int)(this.guiTop + 22 + 10 + 1 + 144), (int)-11119018);
        }
        for (i = 0; i < Math.min(frequencies.size(), 12); ++i) {
            f = frequencies.get(i + this.scrolled);
            yPos = this.guiTop + 22 + 10 + 2 + i * 12;
            if (x <= this.guiLeft + 88 || x > this.guiLeft + 88 + 133 - (frequencies.size() > 12 ? 11 : 0) || y <= yPos || y > yPos + 11 || f.isBundled() != this.gate.isBundled()) continue;
            this.func_146283_a(Arrays.asList("Frequency: " + f.getFrequencyName(), EnumChatFormatting.GRAY + "Accessibility: " + StringUtils.capitalize((String)f.getAccessibility().name().toLowerCase()), EnumChatFormatting.GRAY + "Owner: " + f.getOwnerName(), "Devices: " + f.getDevices()), x, y);
        }
    }

    private boolean checkNoMatches() {
        for (IFrequency f : WirelessManager.CLIENT_INSTANCE.getFrequencies()) {
            if (f.getAccessibility() != this.acc || !f.getFrequencyName().toLowerCase().equals(this.frequencyName.func_146179_b().trim().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private List<Frequency> getFrequencies() {
        ArrayList<Frequency> frequencies = new ArrayList<Frequency>();
        for (IFrequency f : WirelessManager.CLIENT_INSTANCE.getFrequencies()) {
            if (f.getAccessibility().ordinal() != this.filterAccessLevel.value && this.filterAccessLevel.value != 3 && this.filterAccessLevel.value != 4 || !f.getFrequencyName().toLowerCase().contains(this.filter.toLowerCase())) continue;
            frequencies.add((Frequency)f);
        }
        Collections.sort(frequencies, new FrequencySorter(this));
        return frequencies;
    }

    private static class FrequencySorter
    implements Comparator<Frequency> {
        private GuiGateWireless gui;

        public FrequencySorter(GuiGateWireless gui) {
            this.gui = gui;
        }

        @Override
        public int compare(Frequency o1, Frequency o2) {
            if (o1.isBundled() != o2.isBundled()) {
                if (o1.isBundled() == this.gui.gate.isBundled()) {
                    return Integer.MIN_VALUE;
                }
                if (o2.isBundled() == this.gui.gate.isBundled()) {
                    return Integer.MAX_VALUE;
                }
            }
            if (o1.getAccessibility() != o2.getAccessibility()) {
                return o1.getAccessibility().compareTo(o2.getAccessibility());
            }
            return new AlphanumComparator().compare(o1.getFrequencyName(), o2.getFrequencyName());
        }
    }
}

