/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.compat.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.bluepowermod.client.gui.GuiAlloyFurnace;
import com.bluepowermod.recipe.AlloyFurnaceRegistry;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class AlloyFurnaceHandler
extends FurnaceRecipeHandler {
    public String getRecipeName() {
        return "Alloy Furnace";
    }

    public String getGuiTexture() {
        return "bluepower:textures/gui/alloy_furnace.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiAlloyFurnace.class;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(17, 43, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(97, 24, 22, 14), this.getRecipesID(), new Object[0]));
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(17, 43, 177, 0, 14, 14, 48, 7);
        this.drawProgressBar(97, 24, 177, 14, 24, 16, 48, 0);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipesID())) {
            for (IAlloyFurnaceRecipe recipe : AlloyFurnaceRegistry.getInstance().getAllRecipes()) {
                if (!(recipe instanceof AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe)) continue;
                this.arecipes.add(new AlloyRecipe((AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe)recipe));
            }
        } else if (!outputId.equals("fuel")) {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    private String getRecipesID() {
        return "alloyFurnace";
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IAlloyFurnaceRecipe recipe : AlloyFurnaceRegistry.getInstance().getAllRecipes()) {
            if (!(recipe instanceof AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe) || !NEIClientUtils.areStacksSameTypeCrafting((ItemStack)recipe.getCraftingResult(null), (ItemStack)result)) continue;
            this.arecipes.add(new AlloyRecipe((AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe)recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (IAlloyFurnaceRecipe recipe : AlloyFurnaceRegistry.getInstance().getAllRecipes()) {
            if (!(recipe instanceof AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe)) continue;
            AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe standardAlloyRecipe = (AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe)recipe;
            for (ItemStack input : standardAlloyRecipe.getRequiredItems()) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)input, (ItemStack)ingredient)) continue;
                this.arecipes.add(new AlloyRecipe(standardAlloyRecipe));
                continue block0;
            }
        }
    }

    public class AlloyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final PositionedStack craftingResult;
        private final List<PositionedStack> requiredItems;

        public AlloyRecipe(AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe alloyRecipe) {
            super((TemplateRecipeHandler)AlloyFurnaceHandler.this);
            this.craftingResult = new PositionedStack((Object)alloyRecipe.getCraftingResult(null), 129, 24);
            this.requiredItems = new ArrayList<PositionedStack>();
            int x = 0;
            int y = 0;
            for (ItemStack requiredItem : alloyRecipe.getRequiredItems()) {
                this.requiredItems.add(new PositionedStack((Object)requiredItem, 42 + x * 18, 6 + y * 18));
                if (++x <= 2) continue;
                x = 0;
                ++y;
            }
        }

        public PositionedStack getResult() {
            return this.craftingResult;
        }

        public List<PositionedStack> getIngredients() {
            return this.requiredItems;
        }

        public PositionedStack getOtherStack() {
            PositionedStack stack = ((FurnaceRecipeHandler.FuelPair)FurnaceRecipeHandler.afuels.get((int)(AlloyFurnaceHandler.this.cycleticks / 48 % FurnaceRecipeHandler.afuels.size()))).stack;
            stack = stack.copy();
            stack.relx = 16;
            stack.rely = 24;
            return stack;
        }
    }
}

