/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.event;

import com.bluepowermod.ClientProxy;
import com.bluepowermod.client.gui.GuiCircuitDatabaseSharing;
import com.bluepowermod.container.ContainerSeedBag;
import com.bluepowermod.container.inventory.InventoryItem;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPEnchantments;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.item.ItemSeedBag;
import com.bluepowermod.item.ItemSickle;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageServerTickTime;
import com.bluepowermod.part.PartManager;
import com.bluepowermod.util.Achievements;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import uk.co.qmunity.lib.helper.MathHelper;

public class BPEventHandler {
    private boolean isAttacking = false;

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.world.func_72820_D() % 200L == 0L) {
            double tickTime = (double)MathHelper.mean((long[])MinecraftServer.func_71276_C().field_71311_j) * 1.0E-6;
            BPNetworkHandler.INSTANCE.sendToDimension((IMessage)new MessageServerTickTime(tickTime), event.world.field_73011_w.field_76574_g);
        }
    }

    @SubscribeEvent
    public void onAnvilEvent(AnvilUpdateEvent event) {
        if (event.left != null && event.left.func_77973_b() == BPItems.screwdriver && event.right != null && event.right.func_77973_b() == Items.field_151134_bR && EnchantmentHelper.func_82781_a((ItemStack)event.right).get(Enchantment.field_77348_q.field_77352_x) != null) {
            event.output = new ItemStack(BPItems.silky_screwdriver, 1, event.left.func_77960_j());
            event.cost = 20;
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack heldItem;
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && event.entityPlayer.field_71075_bZ.field_75098_d && (heldItem = event.entityPlayer.func_71045_bC()) != null && heldItem.func_77973_b() instanceof ItemSickle) {
            heldItem.func_77973_b().func_150894_a(heldItem, event.world, event.world.func_147439_a(event.x, event.y, event.z), event.x, event.y, event.z, (EntityLivingBase)event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void itemPickUp(EntityItemPickupEvent event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack pickUp = event.item.func_92059_d();
        if (!(player.field_71070_bA instanceof ContainerSeedBag)) {
            for (ItemStack is : player.field_71071_by.field_70462_a) {
                ItemStack seedType;
                if (is == null || !(is.func_77973_b() instanceof ItemSeedBag) || (seedType = ItemSeedBag.getSeedType(is)) == null || !seedType.func_77969_a(pickUp)) continue;
                InventoryItem inventory = InventoryItem.getItemInventory(is, "Seed Bag", 9);
                inventory.func_70295_k_();
                ItemStack pickedUp = TileEntityHopper.func_145889_a((IInventory)inventory, (ItemStack)pickUp, (int)-1);
                inventory.closeInventory(is);
                if (pickedUp == null) {
                    event.setResult(Event.Result.ALLOW);
                    event.item.func_70106_y();
                    return;
                }
                event.item.func_92058_a(pickedUp);
            }
        }
        if (pickUp.func_77973_b().equals(Item.func_150898_a((Block)BPBlocks.tungsten_ore))) {
            player.func_71064_a((StatBase)Achievements.tungstenAchievement, 1);
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        EntityDamageSource entitySource;
        if (!this.isAttacking && event.source instanceof EntityDamageSource && (entitySource = (EntityDamageSource)event.source).func_76346_g() instanceof EntityPlayer) {
            EntityPlayer killer = (EntityPlayer)entitySource.func_76346_g();
            if (killer.field_71071_by.func_70448_g() != null && EnchantmentHelper.func_82781_a((ItemStack)killer.field_71071_by.func_70448_g()).containsKey(BPEnchantments.disjunction.field_77352_x) && (event.entityLiving instanceof EntityEnderman || event.entityLiving instanceof EntityDragon)) {
                int level = EnchantmentHelper.func_77506_a((int)BPEnchantments.disjunction.field_77352_x, (ItemStack)killer.field_71071_by.func_70448_g());
                this.isAttacking = true;
                event.entityLiving.func_70097_a(event.source, event.ammount * ((float)level * 0.5f + 1.0f));
                this.isAttacking = false;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityDamageSource entitySource;
        if (event.source instanceof EntityDamageSource && (entitySource = (EntityDamageSource)event.source).func_76346_g() instanceof EntityPlayer) {
            EntityPlayer killer = (EntityPlayer)entitySource.func_76346_g();
            if (killer.field_71071_by.func_70448_g() != null && EnchantmentHelper.func_82781_a((ItemStack)killer.field_71071_by.func_70448_g()).containsKey(BPEnchantments.vorpal.field_77352_x)) {
                int level = EnchantmentHelper.func_77506_a((int)BPEnchantments.vorpal.field_77352_x, (ItemStack)killer.field_71071_by.func_70448_g());
                if (level == 1) {
                    if (killer.field_70170_p.field_73012_v.nextInt(6) == 1) {
                        this.dropHeads(event);
                    }
                } else if (level == 2 && killer.field_70170_p.field_73012_v.nextInt(3) == 1) {
                    this.dropHeads(event);
                }
            }
        }
    }

    private void dropHeads(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityCreeper) {
            event.entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
        }
        if (event.entityLiving instanceof EntityPlayer) {
            ItemStack drop = new ItemStack(Items.field_151144_bL, 1, 3);
            drop.field_77990_d = new NBTTagCompound();
            drop.field_77990_d.func_74778_a("SkullOwner", ((EntityPlayer)event.entityLiving).getDisplayName());
            event.entityLiving.func_70099_a(drop, 0.0f);
        }
        if (event.entityLiving instanceof EntitySkeleton) {
            EntitySkeleton sk = (EntitySkeleton)event.entityLiving;
            if (sk.func_82202_m() == 0) {
                event.entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
            } else {
                event.entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 1), 0.0f);
            }
        }
        if (event.entityLiving instanceof EntityZombie) {
            event.entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.itemStack.func_77942_o() && event.itemStack.func_77978_p().func_74764_b("tileData") && !event.itemStack.func_77978_p().func_74767_n("hideSilkyTooltip")) {
            event.toolTip.add(I18n.func_135052_a((String)"gui.tooltip.hasSilkyData", (Object[])new Object[0]));
        }
        if (ClientProxy.getOpenedGui() instanceof GuiCircuitDatabaseSharing) {
            ItemStack deletingStack = ((GuiCircuitDatabaseSharing)ClientProxy.getOpenedGui()).getCurrentDeletingTemplate();
            if (deletingStack != null && deletingStack == event.itemStack) {
                event.toolTip.add(I18n.func_135052_a((String)"gui.circuitDatabase.info.sneakClickToConfirmDeleting", (Object[])new Object[0]));
            } else {
                event.toolTip.add(I18n.func_135052_a((String)"gui.circuitDatabase.info.sneakClickToDelete", (Object[])new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        if (item == null) {
            return;
        }
        if (item.equals(BPItems.blue_doped_wafer) || item.equals(BPItems.red_doped_wafer)) {
            event.player.func_71064_a((StatBase)Achievements.dopeAchievement, 1);
        } else if (item.equals(PartManager.getPartInfo("pneumaticTube").getItem())) {
            event.player.func_71064_a((StatBase)Achievements.tubeAchievement, 1);
        } else if (item.equals(Item.func_150898_a((Block)BPBlocks.sorting_machine))) {
            event.player.func_71064_a((StatBase)Achievements.sortAchievement, 1);
        } else if (item.equals(PartManager.getPartInfo("magTube").getItem())) {
            event.player.func_71064_a((StatBase)Achievements.magTubeAchievement, 1);
        } else if (item.equals(PartManager.getPartInfo("integratedCircuit3x3").getItem()) || item.equals(PartManager.getPartInfo("integratedCircuit5x5").getItem()) || item.equals(PartManager.getPartInfo("integratedCircuit7x7").getItem())) {
            event.player.func_71064_a((StatBase)Achievements.circuitCeptionAchievement, 1);
        }
    }

    @SubscribeEvent
    public void onBonemealEvent(BonemealEvent event) {
        if (!event.world.field_72995_K && event.block instanceof BlockGrass) {
            for (int x = event.x - 2; x < event.x + 3; ++x) {
                for (int z = event.z - 2; z < event.z + 3; ++z) {
                    if (!event.world.func_147437_c(x, event.y + 1, z) || event.world.field_73012_v.nextInt(50) != 1 || !BPBlocks.indigo_flower.func_149718_j(event.world, event.x, event.y + 1, event.z)) continue;
                    event.world.func_147449_b(event.x, event.y + 1, event.z, BPBlocks.indigo_flower);
                }
            }
        }
    }
}

