/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.component;

import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.component.GateComponent;
import java.awt.image.BufferedImage;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.transform.Translation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class GateComponentSolarPanel
extends GateComponent {
    private boolean state = false;
    private int layoutColor = -1;
    private double x = 0.0;
    private double z = 0.0;

    public GateComponentSolarPanel(GateBase<?, ?, ?, ?, ?, ?> gate, int color) {
        super(gate);
        this.layoutColor = color;
        this.onLayoutRefresh();
    }

    public GateComponentSolarPanel(GateBase<?, ?, ?, ?, ?, ?> gate, double x, double z) {
        super(gate);
        this.x = x;
        this.z = z;
    }

    @Override
    public void renderStatic(Vec3i translation, RenderHelper renderer, int pass) {
        renderer.addTransformation((Transformation)new Translation(-0.1875 + this.x, 0.0, -0.25 + this.z));
        renderer.renderBox(new Vec3dCube(0.1875, 0.125, 0.25, 0.8125, 0.25, 0.75), null, IconSupplier.gateSolarPanel, IconSupplier.gateButton, IconSupplier.gateButton, IconSupplier.gateButton, IconSupplier.gateButton);
        renderer.removeTransformation();
    }

    @Override
    public void renderDynamic(Vec3d translation, double delta, int pass) {
    }

    @Override
    public void onLayoutRefresh() {
        if (this.layoutColor == -1) {
            return;
        }
        BufferedImage img = ((GateBase)this.getGate()).getLayout().getLayout(this.layoutColor);
        this.x = img.getWidth();
        this.z = img.getHeight();
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getWidth(); ++y) {
                if ((img.getRGB(x, y) & 0xFFFFFF) == 0) continue;
                this.x = Math.min(this.x, (double)x);
                this.z = Math.min(this.z, (double)y);
            }
        }
        this.x /= (double)img.getWidth();
        this.z /= (double)img.getHeight();
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public boolean getState() {
        return this.state;
    }
}

