/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.component;

import com.bluepowermod.api.gate.IGate;
import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.part.BPPart;
import com.bluepowermod.part.BPPartFace;
import com.bluepowermod.part.BPPartFaceRotate;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.component.GateComponent;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.transform.Translation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class GateComponentTorch
extends GateComponent {
    private final Random rnd = new Random();
    protected boolean state = false;
    private int layoutColor = -1;
    protected double x = 0.0;
    protected double z = 0.0;
    protected double height;
    private boolean digital;

    public GateComponentTorch(GateBase<?, ?, ?, ?, ?, ?> gate, int color, double height, boolean digital) {
        super(gate);
        this.layoutColor = color;
        this.onLayoutRefresh();
        this.height = height;
        this.digital = digital;
    }

    public GateComponentTorch(GateBase<?, ?, ?, ?, ?, ?> gate, double x, double z, double height, boolean digital) {
        super(gate);
        this.x = x;
        this.z = z;
        this.height = height;
        this.digital = digital;
    }

    @Override
    public void renderStatic(Vec3i translation, RenderHelper renderer, int pass) {
        IIcon icon = this.digital ? (this.state ? IconSupplier.bluestoneTorchOn : IconSupplier.bluestoneTorchOff) : (this.state ? Blocks.field_150429_aA.func_149691_a(0, 0) : Blocks.field_150437_az.func_149691_a(0, 0));
        IIcon override = renderer.getOverrideTexture();
        renderer.setOverrideTexture(null);
        double height = 0.625 - this.height;
        renderer.addTransformation((Transformation)new Translation(this.x - 0.4375, 0.125 - height, this.z - 0.4375));
        renderer.setRenderSides(false, false, false, false, true, true);
        renderer.renderBox(new Vec3dCube(0.0, height, 0.4375, 1.0, 1.0, 0.5625), icon);
        renderer.setRenderSides(false, false, true, true, false, false);
        renderer.renderBox(new Vec3dCube(0.4375, height, 0.0, 0.5625, 1.0, 1.0), icon);
        renderer.addTransformation((Transformation)new Translation(0.0, 0.0, 0.0625));
        renderer.setRenderSides(false, true, false, false, false, false);
        renderer.renderBox(new Vec3dCube(0.4375, 0.625, 0.375, 0.5625, 0.625, 0.5), icon);
        renderer.resetRenderedSides();
        renderer.removeTransformations(2);
        renderer.setOverrideTexture(override);
    }

    @Override
    public void onLayoutRefresh() {
        if (this.layoutColor == -1) {
            return;
        }
        BufferedImage img = ((GateBase)this.getGate()).getLayout().getLayout(this.layoutColor);
        this.x = img.getWidth();
        this.z = img.getHeight();
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getWidth(); ++y) {
                if ((img.getRGB(x, y) & 0xFFFFFF) == 0) continue;
                this.x = Math.min(this.x, (double)x);
                this.z = Math.min(this.z, (double)y);
            }
        }
        this.x /= (double)img.getWidth();
        this.z /= (double)img.getHeight();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.state) {
            return;
        }
        IGate gate = this.getGate();
        if (!((BPPart)((Object)gate)).getWorld().field_72995_K) {
            return;
        }
        Vec3d v = new Vec3d(this.x + 0.0625, this.height + 0.125, this.z + 0.0625).sub(Vec3d.center).rotate(0.0, (double)(90 * -((BPPartFaceRotate)((Object)gate)).getRotation()), 0.0).add(Vec3d.center).rotate(((BPPartFace)((Object)gate)).getFace(), Vec3d.center);
        if (this.rnd.nextInt(10) == 0) {
            ((BPPart)((Object)gate)).getWorld().func_72869_a("reddust", (double)((BPPart)((Object)gate)).getX() + v.getX(), (double)((BPPart)((Object)gate)).getY() + v.getY(), (double)((BPPart)((Object)gate)).getZ() + v.getZ(), this.digital ? -1.0 : 0.0, 0.0, this.digital ? 1.0 : 0.0);
        }
    }

    public GateComponentTorch setState(boolean state) {
        if (state != this.state) {
            this.setNeedsSyncing(true);
        }
        this.state = state;
        return this;
    }

    public boolean getState() {
        return this.state;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("state", this.state);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.state = tag.func_74767_n("state");
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        super.writeData(buffer);
        buffer.writeBoolean(this.state);
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        super.readData(buffer);
        this.state = buffer.readBoolean();
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getZ() {
        return this.z;
    }
}

