/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.connection;

import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.part.BPPart;
import com.bluepowermod.part.BPPartFace;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.redstone.DummyRedstoneDevice;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.helper.RedstoneHelper;
import uk.co.qmunity.lib.util.Dir;

public class GateConnectionAnalogue
extends GateConnectionBase {
    private byte input = 0;
    private byte output = 0;
    private byte lastOutput = 0;

    public GateConnectionAnalogue(GateBase<?, ?, ?, ?, ?, ?> gate, Dir direction) {
        super(gate, direction);
    }

    @Override
    public void refresh() {
        IConnection<IRedstoneDevice> c = this.gate.getRedstoneConnectionCache().getConnectionOnSide(this.getForgeDirection());
        if (c == null || c.getB() instanceof DummyRedstoneDevice) {
            this.input = (byte)MathHelper.map((int)RedstoneHelper.getInput((World)((BPPart)((Object)this.getGate())).getWorld(), (int)((BPPart)((Object)this.getGate())).getX(), (int)((BPPart)((Object)this.getGate())).getY(), (int)((BPPart)((Object)this.getGate())).getZ(), (ForgeDirection)this.getForgeDirection(), (ForgeDirection)((BPPartFace)((Object)this.getGate())).getFace()), (int)0, (int)15, (int)0, (int)255);
        }
    }

    @Override
    public boolean canConnect(IRedstoneDevice device) {
        return true;
    }

    @Override
    public boolean canConnect(IBundledDevice device) {
        return false;
    }

    @Override
    public boolean isBundled() {
        return false;
    }

    @Override
    public byte getRedstoneOutput() {
        return this.output;
    }

    @Override
    public byte[] getBundledOutput() {
        return new byte[16];
    }

    @Override
    public void setRedstonePower(byte power) {
        this.input = power;
    }

    @Override
    public void setBundledPower(byte[] power) {
    }

    public byte getInput() {
        return this.input;
    }

    public byte getOutput() {
        return this.output;
    }

    public GateConnectionAnalogue setInput(byte input) {
        if (this.input != input) {
            this.setNeedsSyncing(true);
        }
        this.input = input;
        return this;
    }

    public GateConnectionAnalogue setOutput(byte output) {
        if (this.output != output) {
            this.setNeedsSyncing(true);
        }
        this.output = output;
        return this;
    }

    @Override
    public GateConnectionAnalogue disable() {
        super.disable();
        return this;
    }

    @Override
    public GateConnectionAnalogue enable() {
        super.enable();
        return this;
    }

    @Override
    public GateConnectionAnalogue setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public GateConnectionAnalogue setOutputOnly() {
        super.setOutputOnly();
        return this;
    }

    @Override
    public GateConnectionAnalogue setBidirectional() {
        super.setBidirectional();
        return this;
    }

    @Override
    public double getSignal() {
        int tot = this.output & 0xFF;
        if (!this.isOutputOnly()) {
            tot = Math.max(tot, this.input & 0xFF);
        }
        return (double)tot / 255.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("input", this.input);
        tag.func_74774_a("output", this.output);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.input = tag.func_74771_c("input");
        this.output = tag.func_74771_c("output");
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        super.writeData(buffer);
        buffer.writeByte(this.input);
        buffer.writeByte(this.output);
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        super.readData(buffer);
        this.input = buffer.readByte();
        this.output = buffer.readByte();
    }

    @Override
    public void notifyUpdate() {
        super.notifyUpdate();
        this.lastOutput = this.output;
    }

    @Override
    public void notifyUpdateIfNeeded() {
        if (this.lastOutput != this.output) {
            this.notifyUpdate();
        }
    }

    @Override
    public GateConnectionAnalogue reset() {
        super.reset();
        this.input = 0;
        this.output = 0;
        this.lastOutput = (byte)-1;
        return this;
    }
}

