/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.connection;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.util.Dir;

public class GateConnectionBundledDigital
extends GateConnectionBase {
    private boolean[] input = new boolean[16];
    private boolean[] output = new boolean[16];

    public GateConnectionBundledDigital(GateBase<?, ?, ?, ?, ?, ?> gate, Dir direction) {
        super(gate, direction);
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean canConnect(IRedstoneDevice device) {
        return false;
    }

    @Override
    public boolean canConnect(IBundledDevice device) {
        return true;
    }

    @Override
    public boolean isBundled() {
        return true;
    }

    @Override
    public byte getRedstoneOutput() {
        return 0;
    }

    @Override
    public byte[] getBundledOutput() {
        byte[] out = new byte[16];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (byte)(this.output[i] ? 255 : 0);
        }
        return out;
    }

    @Override
    public void setRedstonePower(byte power) {
    }

    @Override
    public void setBundledPower(byte[] power) {
        for (int i = 0; i < power.length; ++i) {
            this.input[i] = (power[i] & 0xFF) > 0;
        }
    }

    public boolean[] getInput() {
        return this.input;
    }

    public boolean[] getOutput() {
        return this.output;
    }

    public boolean getInput(MinecraftColor color) {
        return this.input[color.ordinal()];
    }

    public boolean getOutput(MinecraftColor color) {
        return this.output[color.ordinal()];
    }

    public void setInput(boolean[] input) {
        this.input = input;
    }

    public void setOutput(boolean[] output) {
        this.output = output;
    }

    public void setInput(boolean input, MinecraftColor color) {
        this.input[color.ordinal()] = input;
    }

    public void setOutput(boolean output, MinecraftColor color) {
        this.output[color.ordinal()] = output;
    }

    @Override
    public GateConnectionBundledDigital disable() {
        super.disable();
        return this;
    }

    @Override
    public GateConnectionBundledDigital enable() {
        super.enable();
        return this;
    }

    @Override
    public GateConnectionBundledDigital setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public GateConnectionBundledDigital setOutputOnly() {
        super.setOutputOnly();
        return this;
    }

    @Override
    public GateConnectionBundledDigital setBidirectional() {
        super.setBidirectional();
        return this;
    }

    @Override
    public double getSignal() {
        return 0.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        int i;
        super.writeToNBT(tag);
        for (i = 0; i < 16; ++i) {
            tag.func_74757_a("input_" + i, this.input[i]);
        }
        for (i = 0; i < 16; ++i) {
            tag.func_74757_a("output_" + i, this.output[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        int i;
        super.readFromNBT(tag);
        for (i = 0; i < 16; ++i) {
            this.input[i] = tag.func_74767_n("input_" + i);
        }
        for (i = 0; i < 16; ++i) {
            this.output[i] = tag.func_74767_n("output_" + i);
        }
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        int i;
        super.writeData(buffer);
        for (i = 0; i < 16; ++i) {
            buffer.writeBoolean(this.input[i]);
        }
        for (i = 0; i < 16; ++i) {
            buffer.writeBoolean(this.output[i]);
        }
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        int i;
        super.readData(buffer);
        for (i = 0; i < 16; ++i) {
            this.input[i] = buffer.readBoolean();
        }
        for (i = 0; i < 16; ++i) {
            this.output[i] = buffer.readBoolean();
        }
    }

    @Override
    public void notifyUpdateIfNeeded() {
    }

    @Override
    public GateConnectionBundledDigital reset() {
        super.reset();
        this.input = new boolean[16];
        this.output = new boolean[16];
        return this;
    }
}

