/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.ic;

import com.bluepowermod.api.gate.IGateComponent;
import com.bluepowermod.api.gate.IGateLogic;
import com.bluepowermod.api.gate.IIntegratedCircuitPart;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IBundledDeviceWrapper;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDeviceWrapper;
import com.bluepowermod.item.ItemPart;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.ic.FakeMultipartTileIC;
import com.bluepowermod.part.gate.ic.FakeWorldIC;
import com.bluepowermod.util.DebugHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartFace;
import uk.co.qmunity.lib.part.IPartPlacement;
import uk.co.qmunity.lib.part.IPartTicking;
import uk.co.qmunity.lib.part.IPartUpdateListener;
import uk.co.qmunity.lib.part.PartRegistry;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.tile.TileMultipart;
import uk.co.qmunity.lib.transform.Rotation;
import uk.co.qmunity.lib.transform.Scale;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.transform.Translation;
import uk.co.qmunity.lib.vec.Vec2d;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class GateIntegratedCircuit
extends GateBase<GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase>
implements IGateLogic<GateIntegratedCircuit>,
IRedstoneDeviceWrapper,
IBundledDeviceWrapper {
    private int size;
    private IIntegratedCircuitPart[][] parts = null;
    private TileMultipart[][] tiles = null;
    private double border = 0.0625;
    private int updateChannel = -1;

    public GateIntegratedCircuit(Integer size) {
        this.size = size;
        this.parts = new IIntegratedCircuitPart[size.intValue()][size.intValue()];
        this.tiles = new TileMultipart[size.intValue()][size.intValue()];
    }

    @Override
    protected String getGateType() {
        return "integratedCircuit" + this.getSize() + "x" + this.getSize();
    }

    @Override
    protected void initConnections() {
    }

    @Override
    protected void initComponents() {
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public boolean changeMode() {
        return false;
    }

    @Override
    public IGateLogic<? extends GateBase<GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase>> logic() {
        return this;
    }

    @Override
    public GateIntegratedCircuit getGate() {
        return this;
    }

    @Override
    public boolean canPlaceOnIntegratedCircuit() {
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public IIntegratedCircuitPart[][] getParts() {
        return this.parts;
    }

    public IIntegratedCircuitPart getPart(int x, int z) {
        if (x >= 0 && z >= 0 && x < this.getSize() && z < this.getSize()) {
            return this.parts[x][z];
        }
        return null;
    }

    public TileMultipart[][] getTiles() {
        return this.tiles;
    }

    public TileMultipart getTile(int x, int z) {
        if (x >= 0 && z >= 0 && x < this.getSize() && z < this.getSize()) {
            return this.tiles[x][z];
        }
        return null;
    }

    public void loadWorld() {
        FakeWorldIC.getInstance().setIC(this);
    }

    public void unloadWorld() {
        FakeWorldIC.getInstance().setIC(null);
    }

    private List<IIntegratedCircuitPart> allParts() {
        ArrayList<IIntegratedCircuitPart> l = new ArrayList<IIntegratedCircuitPart>();
        for (int x = 0; x < this.getSize(); ++x) {
            for (int z = 0; z < this.getSize(); ++z) {
                IIntegratedCircuitPart part = this.parts[x][z];
                if (part == null) continue;
                l.add(part);
            }
        }
        return l;
    }

    public void setPart(int x, int z, IIntegratedCircuitPart part) {
        IIntegratedCircuitPart p;
        this.loadWorld();
        FakeMultipartTileIC tmp = new FakeMultipartTileIC(this);
        tmp.func_145834_a(FakeWorldIC.getInstance());
        tmp.field_145851_c = x;
        tmp.field_145848_d = 64;
        tmp.field_145849_e = z;
        this.tiles[x][z] = tmp;
        this.parts[x][z] = part;
        if (part instanceof IPartFace) {
            ((IPartFace)part).setFace(ForgeDirection.DOWN);
        }
        tmp.addPart(part);
        for (int x_ = x - 1; x_ <= x + 1; ++x_) {
            if (x_ == x || (p = this.getPart(x_, z)) == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onNeighborBlockChange();
        }
        for (int z_ = z - 1; z_ <= z + 1; ++z_) {
            if (z_ == z || (p = this.getPart(x, z_)) == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onNeighborBlockChange();
        }
        this.unloadWorld();
    }

    @Override
    public int getRotation() {
        return 0;
    }

    @Override
    public void doLogic() {
        this.loadWorld();
        IIntegratedCircuitPart part = this.getPart(0, (this.getSize() - 1) / 2);
        if (part instanceof IPartUpdateListener) {
            ((IPartUpdateListener)part).onNeighborBlockChange();
        }
        if ((part = this.getPart(this.getSize() - 1, (this.getSize() - 1) / 2)) instanceof IPartUpdateListener) {
            ((IPartUpdateListener)part).onNeighborBlockChange();
        }
        if ((part = this.getPart((this.getSize() - 1) / 2, 0)) instanceof IPartUpdateListener) {
            ((IPartUpdateListener)part).onNeighborBlockChange();
        }
        if ((part = this.getPart((this.getSize() - 1) / 2, this.getSize() - 1)) instanceof IPartUpdateListener) {
            ((IPartUpdateListener)part).onNeighborBlockChange();
        }
        this.unloadWorld();
    }

    @Override
    public void tick() {
        this.loadWorld();
        for (IIntegratedCircuitPart part : this.allParts()) {
            if (!(part instanceof IPartTicking)) continue;
            ((IPartTicking)part).update();
        }
        this.unloadWorld();
    }

    @Override
    public void addSelectionBoxes(List<Vec3dCube> boxes) {
        boxes.add(new Vec3dCube(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0));
        boxes.add(new Vec3dCube(0.0, 0.0625, 0.0, 1.0, 0.125, 0.0625));
        boxes.add(new Vec3dCube(0.0, 0.0625, 0.9375, 1.0, 0.125, 1.0));
        boxes.add(new Vec3dCube(0.0, 0.0625, 0.0, 0.0625, 0.125, 1.0));
        boxes.add(new Vec3dCube(0.9375, 0.0625, 0.0, 1.0, 0.125, 1.0));
    }

    @Override
    public QMovingObjectPosition rayTrace(Vec3d start, Vec3d end) {
        QMovingObjectPosition mop = super.rayTrace(start, end);
        if (mop != null && mop.getPart() == this) {
            return new QMovingObjectPosition((MovingObjectPosition)mop, (IPart)this, new Vec3dCube(0.0, 0.0, 0.0, 1.0, 0.125, 1.0));
        }
        return mop;
    }

    @Override
    public boolean onActivated(EntityPlayer player, QMovingObjectPosition hit, ItemStack item) {
        IPart part;
        int z;
        Vec2d v = new Vec2d(hit.field_72307_f.field_72450_a - (double)hit.field_72311_b, hit.field_72307_f.field_72449_c - (double)hit.field_72309_d).sub(0.5, 0.5).rotate((double)(90 * -this.getRotation())).add(0.5, 0.5);
        int x = (int)(v.getX() * (double)this.getSize());
        if (this.getPart(x, z = (int)(v.getY() * (double)this.getSize())) == null && item != null && item.func_77973_b() instanceof ItemPart && (part = ((ItemPart)item.func_77973_b()).createPart(item, player, this.getWorld(), (MovingObjectPosition)hit)) instanceof IIntegratedCircuitPart) {
            if (!this.getWorld().field_72995_K) {
                this.setPart(x, z, (IIntegratedCircuitPart)part);
                this.sendUpdatePacket(part, -1);
            }
            return true;
        }
        return super.onActivated(player, hit, item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        switch (this.getFace()) {
            case DOWN: {
                break;
            }
            case UP: {
                renderer.addTransformation((Transformation)new Rotation(180.0, 180.0, 0.0, Vec3d.center));
                break;
            }
            case NORTH: {
                renderer.addTransformation((Transformation)new Rotation(90.0, 0.0, 0.0, Vec3d.center));
                break;
            }
            case SOUTH: {
                renderer.addTransformation((Transformation)new Rotation(-90.0, 0.0, 0.0, Vec3d.center));
                break;
            }
            case WEST: {
                renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, -90.0, Vec3d.center));
                break;
            }
            case EAST: {
                renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, 90.0, Vec3d.center));
                break;
            }
        }
        int rotation = this.getRotation();
        if (rotation != -1) {
            renderer.addTransformation((Transformation)new Rotation(0.0, (double)(90 * -rotation), 0.0));
        }
        IIcon[] icons = new IIcon[]{this.getIcon(ForgeDirection.DOWN), this.getIcon(ForgeDirection.UP), this.getIcon(ForgeDirection.WEST), this.getIcon(ForgeDirection.EAST), this.getIcon(ForgeDirection.NORTH), this.getIcon(ForgeDirection.SOUTH)};
        renderer.renderBox(new Vec3dCube(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), icons);
        renderer.renderBox(new Vec3dCube(0.0, 0.0625, 0.0, 1.0, 0.125, 0.0625), icons);
        renderer.renderBox(new Vec3dCube(0.0, 0.0625, 0.9375, 1.0, 0.125, 1.0), icons);
        renderer.renderBox(new Vec3dCube(0.0, 0.0625, 0.0, 0.0625, 0.125, 1.0), icons);
        renderer.renderBox(new Vec3dCube(0.9375, 0.0625, 0.0, 1.0, 0.125, 1.0), icons);
        for (IGateComponent c : this.getComponents()) {
            c.renderStatic(translation, renderer, pass);
        }
        double scale = (1.0 - this.border * 2.0) / (double)this.getSize();
        renderer.addTransformation((Transformation)new Scale(scale, scale, scale));
        for (int x = 0; x < this.getSize(); ++x) {
            for (int z = 0; z < this.getSize(); ++z) {
                IIntegratedCircuitPart part = this.getPart(x, z);
                if (part == null) continue;
                int s = this.getSize();
                if (s % 2 == 1) {
                    --s;
                }
                double a = (double)(this.getSize() - 1) / 2.0;
                renderer.addTransformation((Transformation)new Translation(-((double)(s - x) - a), -a, -((double)(s - z) - a)));
                part.renderStatic(translation, renderer, renderBlocks, pass);
                renderer.addTransformation((Transformation)new Translation((double)(s - x) - a, a, (double)(s - z) - a));
            }
        }
        renderer.removeTransformation();
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagList l = new NBTTagList();
        this.writeParts(l);
        tag.func_74782_a("parts", (NBTBase)l);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        NBTTagList l = tag.func_150295_c("parts", (int)new NBTTagCompound().func_74732_a());
        this.readParts(l);
    }

    private void writeParts(NBTTagList l) {
        for (int x = 0; x < this.getSize(); ++x) {
            for (int z = 0; z < this.getSize(); ++z) {
                IIntegratedCircuitPart p = this.getPart(x, z);
                if (p == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", x);
                tag.func_74768_a("z", z);
                tag.func_74778_a("type", p.getType());
                NBTTagCompound data = new NBTTagCompound();
                p.writeToNBT(data);
                tag.func_74782_a("data", (NBTBase)data);
                l.func_74742_a((NBTBase)tag);
            }
        }
    }

    private void readParts(NBTTagList l) {
        for (int i = 0; i < l.func_74745_c(); ++i) {
            int z;
            NBTTagCompound tag = l.func_150305_b(i);
            int x = tag.func_74762_e("x");
            IIntegratedCircuitPart p = this.getPart(x, z = tag.func_74762_e("z"));
            if (p == null) {
                p = PartRegistry.createPart((String)tag.func_74779_i("type"), (boolean)false);
                if (p == null || !(p instanceof IIntegratedCircuitPart)) continue;
                this.setPart(x, z, p);
            }
            p.readFromNBT(tag.func_74775_l("data"));
        }
    }

    public void sendUpdatePacket(IPart part, int channel) {
        int x = 0;
        int z = 0;
        for (int x_ = 0; x_ < this.getSize(); ++x_) {
            boolean found = false;
            for (int z_ = 0; z_ < this.getSize(); ++z_) {
                IIntegratedCircuitPart p = this.getPart(x_, z_);
                if (p != part) continue;
                found = true;
                x = x_;
                z = z_;
                break;
            }
            if (found) break;
        }
        int c = z * this.getSize() + x + 10;
        this.updateChannel = channel;
        this.sendUpdatePacket(c);
    }

    public void writeUpdateData(DataOutput buffer, int channel) throws IOException {
        int z;
        super.writeUpdateData(buffer, channel);
        if (channel < 10) {
            return;
        }
        int c = channel - 10;
        int x = c % this.getSize();
        IIntegratedCircuitPart p = this.getPart(x, z = (c - x) / this.getSize());
        if (p == null) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        buffer.writeUTF(p.getType());
        buffer.writeInt(this.updateChannel);
        p.writeUpdateData(buffer, this.updateChannel);
    }

    public void readUpdateData(DataInput buffer, int channel) throws IOException {
        super.readUpdateData(buffer, channel);
        this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
        if (channel < 10) {
            return;
        }
        int c = channel - 10;
        int x = c % this.getSize();
        int z = (c - x) / this.getSize();
        if (!buffer.readBoolean()) {
            return;
        }
        String type = buffer.readUTF();
        IIntegratedCircuitPart p = this.getPart(x, z);
        if (p == null) {
            p = PartRegistry.createPart((String)type, (boolean)true);
            this.setPart(x, z, p);
        }
        if (p == null) {
            return;
        }
        this.updateChannel = buffer.readInt();
        p.readUpdateData(buffer, this.updateChannel);
    }

    public IIntegratedCircuitPart getCircuitPartOnSide(ForgeDirection side) {
        if (side.offsetY != 0 || side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return this.getPart(side.offsetX == 0 ? (this.getSize() - 1) / 2 : (side.offsetX > 0 ? this.getSize() - 1 : 0), side.offsetZ == 0 ? (this.getSize() - 1) / 2 : (side.offsetZ > 0 ? this.getSize() - 1 : 0));
    }

    @Override
    public IRedstoneDevice getDeviceOnSide(ForgeDirection side) {
        IIntegratedCircuitPart p = this.getCircuitPartOnSide(side = new Vec3d(0.0, 0.0, 0.0).add(side).rotate(0.0, (double)(90 * -this.getRotation()), 0.0).toForgeDirection());
        if (p == null) {
            return null;
        }
        if (p instanceof IRedstoneDevice) {
            return (IRedstoneDevice)((Object)p);
        }
        return null;
    }

    @Override
    public IBundledDevice getBundledDeviceOnSide(ForgeDirection side) {
        IIntegratedCircuitPart p = this.getCircuitPartOnSide(side = new Vec3d(0.0, 0.0, 0.0).add(side).rotate(0.0, (double)(90 * -this.getRotation()), 0.0).toForgeDirection());
        if (p == null) {
            return null;
        }
        if (p instanceof IBundledDevice) {
            return (IBundledDevice)((Object)p);
        }
        return null;
    }

    @Override
    public IPartPlacement getPlacement(IPart part, World world, Vec3i location, ForgeDirection face, MovingObjectPosition mop, EntityPlayer player) {
        if (!DebugHelper.isDebugModeEnabled()) {
            return null;
        }
        return super.getPlacement(part, world, location, face, mop, player);
    }

    @Override
    public void addTooltip(ItemStack item, List<String> tip) {
        if (!DebugHelper.isDebugModeEnabled()) {
            tip.add((Object)((Object)MinecraftColor.RED) + I18n.func_135052_a((String)"Disabled temporarily. Still not fully working.", (Object[])new Object[0]));
        } else {
            tip.add((Object)((Object)MinecraftColor.CYAN) + I18n.func_135052_a((String)"Disabled temporarily. Still not fully working.", (Object[])new Object[0]));
        }
    }
}

