/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.tube;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.part.tube.PneumaticTube;
import com.bluepowermod.part.tube.RestrictionTubeOpaque;
import com.bluepowermod.part.wire.redstone.WireHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.transform.Rotation;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class PneumaticTubeOpaque
extends PneumaticTube {
    @Override
    public String getType() {
        return "pneumaticTubeOpaque";
    }

    @Override
    public String getUnlocalizedName() {
        return "pneumaticTubeOpaque";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IIcon getSideIcon() {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i loc, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        if (pass == 0) {
            IIcon icon;
            boolean renderFully = false;
            int count = 0;
            for (int i = 0; i < 6; ++i) {
                if (this.connections[i] || this.redstoneConnections[i]) {
                    ++count;
                }
                if (i % 2 != 0 || this.connections[i] == this.connections[i + 1]) continue;
                renderFully = true;
            }
            IIcon iIcon = this instanceof RestrictionTubeOpaque ? (renderFully ? IconSupplier.restrictionTubeNodeOpaque : IconSupplier.restrictionTubeSideOpaque) : (icon = (renderFully |= count > 2 || count == 0) ? IconSupplier.pneumaticTubeOpaqueNode : IconSupplier.pneumaticTubeOpaqueSide);
            if (this.shouldRenderConnection(ForgeDirection.EAST) || this.shouldRenderConnection(ForgeDirection.WEST)) {
                renderer.setTextureRotations(1, 1, 0, 0, 1, 1);
            }
            if (this.shouldRenderConnection(ForgeDirection.NORTH) || this.shouldRenderConnection(ForgeDirection.SOUTH)) {
                renderer.setTextureRotations(0, 0, 1, 1, 0, 0);
            }
            renderer.renderBox(new Vec3dCube(0.25, 0.25, 0.25, 0.75, 0.75, 0.75), icon);
            renderer.resetTextureRotations();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                if (!this.shouldRenderConnection(d)) continue;
                renderer.addTransformation((Transformation)new Rotation(d));
                renderer.renderBox(new Vec3dCube(0.25, 0.0, 0.25, 0.75, 0.25, 0.75), IconSupplier.pneumaticTubeOpaqueNode, null, icon, icon, icon, icon);
                renderer.removeTransformation();
            }
            if (this.getRedwireType() != null) {
                double wireSize = (double)this.getSize() / 16.0;
                double frameSeparation = 0.375 - (wireSize - 0.125);
                double frameThickness = 0.0625;
                this.renderFrame(renderer, wireSize, frameSeparation -= 0.03125, frameThickness /= 1.5, renderFully || this.shouldRenderConnection(ForgeDirection.DOWN), renderFully || this.shouldRenderConnection(ForgeDirection.UP), renderFully || this.shouldRenderConnection(ForgeDirection.WEST), renderFully || this.shouldRenderConnection(ForgeDirection.EAST), renderFully || this.shouldRenderConnection(ForgeDirection.NORTH), renderFully || this.shouldRenderConnection(ForgeDirection.SOUTH), this.redstoneConnections[ForgeDirection.DOWN.ordinal()], this.redstoneConnections[ForgeDirection.UP.ordinal()], this.redstoneConnections[ForgeDirection.WEST.ordinal()], this.redstoneConnections[ForgeDirection.EAST.ordinal()], this.redstoneConnections[ForgeDirection.NORTH.ordinal()], this.redstoneConnections[ForgeDirection.SOUTH.ordinal()], this.getParent() != null && this.getWorld() != null, IconSupplier.wire, WireHelper.getColorForPowerLevel(this.getRedwireType(), this.getPower()));
            }
            Vec3dCube side = new Vec3dCube(0.2890625, 0.0, 0.2421875, 0.3203125, 0.25, 0.265625);
            Vec3dCube side2 = new Vec3dCube(0.2421875, 0.0, 0.2890625, 0.265625, 0.25, 0.3203125);
            Vec3dCube side3 = new Vec3dCube(0.2421875, 0.2421875, 0.2890625, 0.265625, 0.265625, 0.7109375);
            Vec3dCube side4 = new Vec3dCube(0.2890625, 0.2421875, 0.2890625, 0.3203125, 0.265625, 0.6875);
            Vec3dCube side5 = new Vec3dCube(0.2890625, 0.2421875, 0.2421875, 0.3203125, 0.265625, 0.7578125);
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IPneumaticTube.TubeColor c = this.color[d.ordinal()];
                if (c == IPneumaticTube.TubeColor.NONE) continue;
                try {
                    int i;
                    renderer.setColor(MinecraftColor.values()[15 - c.ordinal()].getHex());
                    if (this.connections[d.ordinal()]) {
                        for (i = 0; i < 4; ++i) {
                            renderer.renderBox(side.clone().rotate(0, i * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                            renderer.renderBox(side2.clone().rotate(0, i * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                            if (!renderFully) continue;
                            renderer.renderBox(side3.clone().rotate(0, i * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                        }
                    } else if (renderFully) {
                        for (i = 0; i < 4; ++i) {
                            renderer.renderBox(side4.clone().rotate(0, i * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                        }
                    } else {
                        for (i = 1; i < 4; i += 2) {
                            renderer.renderBox(side5.clone().rotate(0, (i + (this.shouldRenderConnection(ForgeDirection.NORTH) || this.shouldRenderConnection(ForgeDirection.UP) && (d == ForgeDirection.NORTH || d == ForgeDirection.SOUTH) ? 1 : 0)) * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                        }
                    }
                    renderer.setColor(0xFFFFFF);
                }
                catch (Exception ex) {
                    System.out.println("Err on side " + d + ". Color: " + (Object)((Object)c));
                }
            }
        }
        return true;
    }
}

