/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.tube;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.api.tube.ITubeConnection;
import com.bluepowermod.api.tube.IWeightedTubeInventory;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.Config;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageRedirectTubeStack;
import com.bluepowermod.part.tube.PneumaticTube;
import com.bluepowermod.part.tube.TubeStack;
import com.bluepowermod.tile.IFuzzyRetrieving;
import com.bluepowermod.tile.tier3.TileManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.network.LocatedPacket;
import uk.co.qmunity.lib.network.PacketHelper;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;
import uk.co.qmunity.lib.vec.Vec3d;

public class TubeLogic
implements IPneumaticTube {
    private final PneumaticTube tube;
    private TubeNode connectionNode;
    public List<TubeStack> tubeStacks = new ArrayList<TubeStack>();
    private int roundRobinCounter;

    public TubeLogic(PneumaticTube tube) {
        this.tube = tube;
    }

    public void onClientTubeRedirectPacket(TubeStack stack) {
        for (TubeStack s : this.tubeStacks) {
            if (!ItemStack.func_77989_b((ItemStack)s.stack, (ItemStack)stack.stack) || stack.color != s.color) continue;
            this.tubeStacks.remove(s);
            break;
        }
        this.tubeStacks.add(stack);
    }

    public void clearNodeCaches() {
        ArrayList<PneumaticTube> clearedTubes = new ArrayList<PneumaticTube>();
        Stack<PneumaticTube> todoTubes = new Stack<PneumaticTube>();
        this.clearNodeCache();
        boolean firstRun = true;
        todoTubes.push(this.tube);
        while (!todoTubes.isEmpty()) {
            PneumaticTube tube = (PneumaticTube)todoTubes.pop();
            if (tube.getParent() != null && tube.getWorld() != null) {
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    PneumaticTube neighbor = tube.getPartCache(d);
                    if (neighbor == null || clearedTubes.contains(neighbor)) continue;
                    neighbor.getLogic().clearNodeCache();
                    clearedTubes.add(neighbor);
                    if (!firstRun && neighbor.isCrossOver) continue;
                    todoTubes.push(neighbor);
                }
            }
            firstRun = false;
        }
    }

    private void clearNodeCache() {
        if (this.connectionNode != null) {
            this.connectionNode.edges = null;
        }
    }

    TubeNode getNode() {
        if (this.connectionNode == null && this.tube.getWorld() != null) {
            this.connectionNode = new TubeNode(this.tube);
            this.connectionNode.init();
        } else if (this.connectionNode != null && this.connectionNode.edges == null) {
            this.connectionNode.init();
        }
        return this.connectionNode;
    }

    public void update() {
        if (!Config.enableTubeCaching) {
            this.clearNodeCache();
        }
        Iterator<TubeStack> iterator = this.tubeStacks.iterator();
        block0: while (iterator.hasNext()) {
            TubeStack tubeStack = iterator.next();
            if (tubeStack.update(this.tube.getWorld())) {
                if (!this.tube.isCrossOver) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        if (!this.tube.connections[dir.ordinal()] || dir == tubeStack.heading.getOpposite()) continue;
                        tubeStack.heading = dir;
                        continue block0;
                    }
                    continue;
                }
                if (!this.tube.getWorld().field_72995_K) {
                    Pair<ForgeDirection, TileEntity> heading = this.getHeadingForItem(tubeStack, false);
                    if (heading == null) {
                        for (int i = 0; i < 6; ++i) {
                            TubeEdge edge = this.getNode().edges[i];
                            if (edge == null) continue;
                            tubeStack.heading = ForgeDirection.getOrientation((int)i);
                            if (!this.canPassThroughMask(tubeStack.color, edge.colorMask)) continue;
                            tubeStack.heading = ForgeDirection.getOrientation((int)i);
                            break;
                        }
                    } else {
                        tubeStack.heading = (ForgeDirection)heading.getKey();
                    }
                    BPNetworkHandler.INSTANCE.sendToAllAround((LocatedPacket)new MessageRedirectTubeStack(this.tube, tubeStack), this.tube.getWorld());
                    continue;
                }
                tubeStack.enabled = false;
                continue;
            }
            if (tubeStack.progress >= 1.0) {
                TileEntity output = this.tube.getTileCache(tubeStack.heading);
                PneumaticTube tube = this.tube.getPartCache(tubeStack.heading);
                if (tube != null) {
                    TubeLogic logic = tube.getLogic();
                    tubeStack.progress = 0.0;
                    tubeStack.oldProgress = -tubeStack.getSpeed() * TubeStack.tickTimeMultiplier;
                    logic.tubeStacks.add(tubeStack);
                    iterator.remove();
                    continue;
                }
                if (!this.tube.getWorld().field_72995_K) {
                    Object remainder = tubeStack.stack;
                    if (output instanceof ITubeConnection && ((ITubeConnection)output).isConnectedTo(tubeStack.heading.getOpposite())) {
                        TubeStack rem = ((ITubeConnection)output).acceptItemFromTube(tubeStack, tubeStack.heading.getOpposite(), false);
                        remainder = rem != null ? rem.stack : null;
                    }
                    if (remainder != null) {
                        remainder = IOHelper.insert(output, remainder, tubeStack.heading.getOpposite(), tubeStack.color, false);
                    }
                    if (remainder != null) {
                        if (this.injectStack((ItemStack)remainder, tubeStack.heading.getOpposite(), tubeStack.color, true)) {
                            tubeStack.stack = remainder;
                            tubeStack.progress = 0.0;
                            tubeStack.oldProgress = 0.0;
                            tubeStack.heading = tubeStack.heading.getOpposite();
                            this.tube.sendUpdatePacket();
                            continue;
                        }
                        EntityItem entity = new EntityItem(this.tube.getWorld(), (double)this.tube.getX() + 0.5 + (double)tubeStack.heading.offsetX * tubeStack.progress * 0.5, (double)this.tube.getY() + 0.5 + (double)tubeStack.heading.offsetY * tubeStack.progress * 0.5, (double)this.tube.getZ() + 0.5 + (double)tubeStack.heading.offsetX * tubeStack.progress * 0.5, remainder);
                        this.tube.getWorld().func_72838_d((Entity)entity);
                        iterator.remove();
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                iterator.remove();
                continue;
            }
            if (tubeStack.idleCounter <= 100) continue;
            iterator.remove();
        }
    }

    public boolean retrieveStack(TileEntity target, ForgeDirection dirToRetrieveInto, ItemStack filter) {
        return this.retrieveStack(target, dirToRetrieveInto, filter, IPneumaticTube.TubeColor.NONE);
    }

    public boolean retrieveStack(TileEntity target, ForgeDirection dirToRetrieveInto, ItemStack filter, IPneumaticTube.TubeColor color) {
        if (this.tube.getWorld() == null) {
            return false;
        }
        TubeStack stack = new TubeStack(filter, null, color);
        stack.setTarget(target, dirToRetrieveInto);
        Pair<ForgeDirection, TileEntity> result = this.getHeadingForItem(stack, false);
        if (result == null) {
            return false;
        }
        int fuzzySetting = 0;
        if (target instanceof IFuzzyRetrieving) {
            fuzzySetting = ((IFuzzyRetrieving)target).getFuzzySetting();
        }
        ItemStack extractedItem = null;
        if (result.getValue() instanceof TileManager) {
            TileEntity managedInventory = ((TileManager)result.getValue()).getTileCache(((TileManager)result.getValue()).getFacingDirection());
            extractedItem = IOHelper.extract(managedInventory, ((ForgeDirection)result.getKey()).getOpposite(), filter, false, false, fuzzySetting);
        } else {
            extractedItem = filter != null ? IOHelper.extract((TileEntity)result.getValue(), ((ForgeDirection)result.getKey()).getOpposite(), filter, !(target instanceof TileManager), false, fuzzySetting) : IOHelper.extract((TileEntity)result.getValue(), ((ForgeDirection)result.getKey()).getOpposite(), false);
        }
        if (extractedItem == null) {
            throw new IllegalArgumentException("This isn't possible!");
        }
        stack = new TubeStack(extractedItem, ((ForgeDirection)result.getKey()).getOpposite(), color);
        stack.setTarget(target, dirToRetrieveInto);
        PneumaticTube tube = (PneumaticTube)MultipartCompatibility.getPart((World)this.tube.getWorld(), (int)(((TileEntity)result.getValue()).field_145851_c - ((ForgeDirection)result.getKey()).offsetX), (int)(((TileEntity)result.getValue()).field_145848_d - ((ForgeDirection)result.getKey()).offsetY), (int)(((TileEntity)result.getValue()).field_145849_e - ((ForgeDirection)result.getKey()).offsetZ), PneumaticTube.class);
        if (tube == null) {
            throw new IllegalArgumentException("wieeeeerd!");
        }
        return tube.getLogic().injectStack(stack, ((ForgeDirection)result.getKey()).getOpposite(), false);
    }

    private Pair<ForgeDirection, TileEntity> getHeadingForItem(TubeStack stack, boolean simulate) {
        HashMap<TubeNode, Integer> distances = new HashMap<TubeNode, Integer>();
        LinkedBlockingQueue<TubeNode> traversingNodes = new LinkedBlockingQueue<TubeNode>();
        LinkedBlockingQueue<ForgeDirection> trackingExportDirection = new LinkedBlockingQueue<ForgeDirection>();
        LinkedHashMap<TubeEdge, ForgeDirection> validDestinations = new LinkedHashMap<TubeEdge, ForgeDirection>();
        if (this.getNode() != null) {
            distances.put(this.getNode(), 0);
            traversingNodes.add(this.getNode());
        }
        boolean firstRun = true;
        int closestDest = 0;
        while (!traversingNodes.isEmpty()) {
            TubeNode node = (TubeNode)traversingNodes.poll();
            if (node.edges == null) {
                node.init();
            }
            ForgeDirection heading = firstRun ? null : (ForgeDirection)trackingExportDirection.poll();
            for (int i = 0; i < 6; ++i) {
                Integer distance;
                TubeEdge edge;
                if (firstRun) {
                    heading = ForgeDirection.getOrientation((int)i);
                }
                if (node.edges == null || (edge = node.edges[i]) == null || !this.canPassThroughMask(stack.color, edge.colorMask) || (distance = (Integer)distances.get(edge.target)) != null && (Integer)distances.get(node) + edge.distance >= distance) continue;
                distances.put(edge.target, (Integer)distances.get(node) + edge.distance);
                if (edge.target.target instanceof PneumaticTube) {
                    traversingNodes.add(edge.target);
                    trackingExportDirection.add(heading);
                    continue;
                }
                if (!(stack.getTarget(this.tube.getWorld()) == null && edge.isValidForExportItem(stack.stack) || stack.heading == null && edge.isValidForImportItem(stack)) && (stack.heading == null || stack.getTarget(this.tube.getWorld()) != edge.target.target || edge.targetConnectionSide.getOpposite() != stack.getTargetEntryDir())) continue;
                validDestinations.put(edge, stack.heading == null ? edge.targetConnectionSide : heading);
            }
            boolean isDoneSearching = true;
            closestDest = this.getClosestDestination(validDestinations.keySet(), distances);
            for (TubeNode checkingNode : traversingNodes) {
                if ((Integer)distances.get(checkingNode) > closestDest) continue;
                isDoneSearching = false;
                break;
            }
            if (isDoneSearching) break;
            firstRun = false;
        }
        if (validDestinations.size() == 0) {
            if (stack.getTarget(this.tube.getWorld()) != null && stack.heading != null && !simulate) {
                stack.setTarget(null, ForgeDirection.UNKNOWN);
                return this.getHeadingForItem(stack, simulate);
            }
            return null;
        }
        ArrayList<ImmutablePair> validDirections = new ArrayList<ImmutablePair>();
        for (Map.Entry entry : validDestinations.entrySet()) {
            if ((Integer)distances.get(((TubeEdge)entry.getKey()).target) != closestDest) continue;
            validDirections.add(new ImmutablePair(entry.getValue(), ((TubeEdge)entry.getKey()).target.target));
        }
        if (!simulate) {
            ++this.roundRobinCounter;
        }
        if (this.roundRobinCounter >= validDirections.size()) {
            this.roundRobinCounter = 0;
        }
        return (Pair)validDirections.get(this.roundRobinCounter);
    }

    private boolean canPassThroughMask(IPneumaticTube.TubeColor color, int colorMask) {
        return color == IPneumaticTube.TubeColor.NONE || Integer.bitCount(colorMask) == 0 || Integer.bitCount(colorMask) == 1 && (colorMask & 1 << color.ordinal()) != 0;
    }

    private int getClosestDestination(Set<TubeEdge> validDestinations, Map<TubeNode, Integer> distances) {
        int minDest = Integer.MAX_VALUE;
        for (TubeEdge edge : validDestinations) {
            if (distances.get(edge.target) >= minDest) continue;
            minDest = distances.get(edge.target);
        }
        return minDest;
    }

    @Override
    public boolean injectStack(ItemStack stack, ForgeDirection from, IPneumaticTube.TubeColor itemColor, boolean simulate) {
        return this.injectStack(new TubeStack(stack.func_77946_l(), from, itemColor), from, simulate);
    }

    public boolean injectStack(TubeStack stack, ForgeDirection from, boolean simulate) {
        if (this.tube.getWorld() != null && this.tube.getWorld().field_72995_K) {
            throw new IllegalArgumentException("[Pneumatic Tube] You can't inject items from the client side!");
        }
        Pair<ForgeDirection, TileEntity> heading = this.getHeadingForItem(stack, simulate);
        if (heading != null && heading.getKey() != from.getOpposite()) {
            if (!simulate) {
                this.tubeStacks.add(stack);
                this.tube.sendUpdatePacket();
            }
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (TubeStack stack : this.tubeStacks) {
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.writeToNBT(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("tubeStacks", (NBTBase)tagList);
        tag.func_74768_a("roundRobinCounter", this.roundRobinCounter);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.tubeStacks = new ArrayList<TubeStack>();
        NBTTagList tagList = tag.func_150295_c("tubeStacks", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = tagList.func_150305_b(i);
            this.tubeStacks.add(TubeStack.loadFromNBT(stackTag));
        }
        this.roundRobinCounter = tag.func_74762_e("roundRobinCounter");
    }

    public void writeData(DataOutput buffer) throws IOException {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        PacketHelper.writeNBT((DataOutput)buffer, (NBTTagCompound)tag);
    }

    public void readData(DataInput buffer) throws IOException {
        this.readFromNBT(PacketHelper.readNBT((DataInput)buffer));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vec3d pos, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(pos.getX() + 0.5), (double)(pos.getY() + 0.5), (double)(pos.getZ() + 0.5));
        for (TubeStack stack : this.tubeStacks) {
            stack.render(partialTick);
        }
        GL11.glPopMatrix();
    }

    public class TubeEdge {
        public TubeNode target;
        private final ForgeDirection targetConnectionSide;
        public final int distance;
        public int colorMask;

        public TubeEdge(TubeNode target, ForgeDirection targetConnectionSide, int colorMask, int distance) {
            this.target = target;
            this.targetConnectionSide = targetConnectionSide;
            this.distance = distance;
            this.colorMask = colorMask;
        }

        public boolean isValidForExportItem(ItemStack stack) {
            if (this.target.target instanceof PneumaticTube) {
                return false;
            }
            if (this.target.target instanceof IWeightedTubeInventory && ((IWeightedTubeInventory)this.target.target).getWeight(this.targetConnectionSide) > 10000) {
                return true;
            }
            ItemStack remainder = IOHelper.insert((TileEntity)this.target.target, stack.func_77946_l(), this.targetConnectionSide.getOpposite(), true);
            return remainder == null || remainder.field_77994_a < stack.field_77994_a;
        }

        public boolean isValidForImportItem(TubeStack stack) {
            if (this.target.target instanceof PneumaticTube) {
                return false;
            }
            TileEntity stackTarget = stack.getTarget(((TileEntity)this.target.target).func_145831_w());
            if (stackTarget instanceof TileManager) {
                TileManager retrievingManager = (TileManager)stackTarget;
                if (this.target.target instanceof TileManager) {
                    TileManager pulledManager = (TileManager)this.target.target;
                    if (retrievingManager == pulledManager) {
                        return false;
                    }
                    if (pulledManager.priority >= retrievingManager.priority) {
                        return false;
                    }
                    if (pulledManager.filterColor != IPneumaticTube.TubeColor.NONE && retrievingManager.filterColor != IPneumaticTube.TubeColor.NONE && retrievingManager.filterColor != pulledManager.filterColor) {
                        return false;
                    }
                    TileEntity managedInventory = pulledManager.getTileCache(pulledManager.getFacingDirection());
                    return IOHelper.extract(managedInventory, pulledManager.getFacingDirection().getOpposite(), stack.stack, false, true) != null;
                }
            }
            if (stack.stack != null) {
                int fuzzySetting = 0;
                if (stackTarget instanceof IFuzzyRetrieving) {
                    fuzzySetting = ((IFuzzyRetrieving)stackTarget).getFuzzySetting();
                }
                return IOHelper.extract((TileEntity)this.target.target, this.targetConnectionSide.getOpposite(), stack.stack, !(stackTarget instanceof TileManager), true, fuzzySetting) != null;
            }
            return IOHelper.extract((TileEntity)this.target.target, this.targetConnectionSide.getOpposite(), true) != null;
        }
    }

    public class TubeNode {
        public TubeEdge[] edges;
        public Object target;

        public TubeNode(TileEntity te) {
            this.target = te;
        }

        public TubeNode(PneumaticTube tube) {
            this.target = tube;
        }

        public void init() {
            PneumaticTube nodeTube = (PneumaticTube)this.target;
            this.edges = new TubeEdge[6];
            for (int i = 0; i < 6; ++i) {
                int colorMask;
                if (!((TubeLogic)TubeLogic.this).tube.connections[i]) continue;
                TileEntity neighbor = nodeTube.getTileCache(ForgeDirection.getOrientation((int)i));
                PneumaticTube tube = nodeTube.getPartCache(ForgeDirection.getOrientation((int)i));
                int n = colorMask = nodeTube.getColor(ForgeDirection.getOrientation((int)i)) != IPneumaticTube.TubeColor.NONE ? 1 << nodeTube.getColor(ForgeDirection.getOrientation((int)i)).ordinal() : 0;
                if (tube != null) {
                    int dist = tube.getWeight();
                    if (tube.getColor(ForgeDirection.getOrientation((int)i).getOpposite()) != IPneumaticTube.TubeColor.NONE) {
                        colorMask |= 1 << tube.getColor(ForgeDirection.getOrientation((int)i).getOpposite()).ordinal();
                    }
                    ForgeDirection curDir = ForgeDirection.getOrientation((int)i);
                    while (!tube.isCrossOver && tube.initialized) {
                        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                            if (dir == curDir.getOpposite() || !tube.connections[dir.ordinal()]) continue;
                            curDir = dir;
                            break;
                        }
                        if ((neighbor = tube.getTileCache(curDir)) == null) continue;
                        if (tube.getColor(curDir) != IPneumaticTube.TubeColor.NONE) {
                            colorMask |= 1 << tube.getColor(curDir).ordinal();
                        }
                        if ((tube = tube.getPartCache(curDir)) == null) {
                            this.edges[i] = new TubeEdge(new TubeNode(neighbor), curDir, colorMask, dist + (neighbor instanceof IWeightedTubeInventory ? ((IWeightedTubeInventory)neighbor).getWeight(curDir) : 0));
                            break;
                        }
                        if (!tube.initialized) break;
                        dist += tube.getWeight();
                        if (tube.getColor(curDir.getOpposite()) == IPneumaticTube.TubeColor.NONE) continue;
                        colorMask |= 1 << tube.getColor(curDir.getOpposite()).ordinal();
                    }
                    if (tube == null || tube == nodeTube || tube.getLogic() == null || tube.getLogic().getNode() == null) continue;
                    this.edges[i] = new TubeEdge(tube.getLogic().getNode(), curDir, colorMask, dist);
                    continue;
                }
                if (neighbor == null) continue;
                this.edges[i] = new TubeEdge(new TubeNode(neighbor), ForgeDirection.getOrientation((int)i), colorMask, neighbor instanceof IWeightedTubeInventory ? ((IWeightedTubeInventory)neighbor).getWeight(ForgeDirection.getOrientation((int)i)) : 0);
            }
        }
    }
}

