/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.wire;

import com.bluepowermod.part.BPPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.part.IPartThruHole;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class PartWireFreestanding
extends BPPart
implements IPartThruHole {
    protected abstract boolean shouldRenderConnection(ForgeDirection var1);

    protected abstract int getSize();

    protected int getColorMultiplier() {
        return 0xFFFFFF;
    }

    protected int getFrameColorMultiplier() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract IIcon getWireIcon(ForgeDirection var1);

    @SideOnly(value=Side.CLIENT)
    protected IIcon getWireIcon(ForgeDirection side, ForgeDirection face) {
        return this.getWireIcon(face);
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon[] getIcons(ForgeDirection side) {
        return new IIcon[]{this.getWireIcon(side, ForgeDirection.DOWN), this.getWireIcon(side, ForgeDirection.UP), this.getWireIcon(side, ForgeDirection.WEST), this.getWireIcon(side, ForgeDirection.EAST), this.getWireIcon(side, ForgeDirection.NORTH), this.getWireIcon(side, ForgeDirection.SOUTH)};
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract IIcon getFrameIcon();

    protected List<Vec3dCube> getFrameBoxes() {
        double wireSize = (double)this.getSize() / 16.0;
        double frameSeparation = 0.25 - (wireSize - 0.125);
        double frameThickness = 0.0625;
        boolean isInWorld = this.getParent() != null;
        boolean down = this.shouldRenderConnection(ForgeDirection.DOWN);
        boolean up = this.shouldRenderConnection(ForgeDirection.UP);
        boolean north = this.shouldRenderConnection(ForgeDirection.NORTH);
        boolean south = this.shouldRenderConnection(ForgeDirection.SOUTH);
        boolean west = this.shouldRenderConnection(ForgeDirection.WEST);
        boolean east = this.shouldRenderConnection(ForgeDirection.EAST);
        return this.getFrameBoxes(wireSize, frameSeparation, frameThickness, down, up, west, east, north, south, isInWorld);
    }

    protected List<Vec3dCube> getFrameBoxes(double wireSize, double frameSeparation, double frameThickness, boolean down, boolean up, boolean west, boolean east, boolean north, boolean south, boolean isInWorld) {
        return this.getFrameBoxes(wireSize, frameSeparation, frameThickness, down, up, west, east, north, south, down, up, west, east, north, south, isInWorld);
    }

    protected List<Vec3dCube> getFrameBoxes(double wireSize, double frameSeparation, double frameThickness, boolean down, boolean up, boolean west, boolean east, boolean north, boolean south, boolean sideDown, boolean sideUp, boolean sideWest, boolean sideEast, boolean sideNorth, boolean sideSouth, boolean isInWorld) {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        if (west == up || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0));
        }
        if (east == up || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0));
        }
        if (south == up || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness));
        }
        if (north == up || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0));
        }
        if (west == down || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0));
        }
        if (east == down || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0));
        }
        if (south == down || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness));
        }
        if (north == down || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0));
        }
        if (north == west || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0));
        }
        if (south == west || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness));
        }
        if (north == east || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0));
        }
        if (south == east || !isInWorld) {
            boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness));
        }
        boxes.add(new Vec3dCube(0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0));
        boxes.add(new Vec3dCube(0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness));
        boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0));
        boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness));
        boxes.add(new Vec3dCube(0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0));
        boxes.add(new Vec3dCube(0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness));
        boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0));
        boxes.add(new Vec3dCube(0.5 + (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 + (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 + (wireSize + frameSeparation) / 2.0 + frameThickness));
        if (isInWorld) {
            int i;
            Vec3dCube box = new Vec3dCube(0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0, 0.5 - (wireSize + frameSeparation) / 2.0 - frameThickness, 0.5 - (wireSize + frameSeparation) / 2.0);
            if (sideDown) {
                for (i = 0; i < 4; ++i) {
                    boxes.add(box.clone().rotate(0, 90 * i, 0, Vec3d.center).rotate(ForgeDirection.DOWN, Vec3d.center));
                }
            }
            if (sideUp) {
                for (i = 0; i < 4; ++i) {
                    boxes.add(box.clone().rotate(0, 90 * i, 0, Vec3d.center).rotate(ForgeDirection.UP, Vec3d.center));
                }
            }
            if (sideWest) {
                for (i = 0; i < 4; ++i) {
                    boxes.add(box.clone().rotate(0, 90 * i, 0, Vec3d.center).rotate(ForgeDirection.WEST, Vec3d.center));
                }
            }
            if (sideEast) {
                for (i = 0; i < 4; ++i) {
                    boxes.add(box.clone().rotate(0, 90 * i, 0, Vec3d.center).rotate(ForgeDirection.EAST, Vec3d.center));
                }
            }
            if (sideNorth) {
                for (i = 0; i < 4; ++i) {
                    boxes.add(box.clone().rotate(0, 90 * i, 0, Vec3d.center).rotate(ForgeDirection.NORTH, Vec3d.center));
                }
            }
            if (sideSouth) {
                for (i = 0; i < 4; ++i) {
                    boxes.add(box.clone().rotate(0, 90 * i, 0, Vec3d.center).rotate(ForgeDirection.SOUTH, Vec3d.center));
                }
            }
        }
        return boxes;
    }

    protected void renderFrame(RenderHelper helper, double wireSize, double frameSeparation, double frameThickness, boolean down, boolean up, boolean west, boolean east, boolean north, boolean south, boolean sideDown, boolean sideUp, boolean sideWest, boolean sideEast, boolean sideNorth, boolean sideSouth, boolean isInWorld, IIcon texture, int color) {
        helper.setColor(color);
        for (Vec3dCube box : this.getFrameBoxes(wireSize, frameSeparation, frameThickness, down, up, west, east, north, south, sideDown, sideUp, sideWest, sideEast, sideNorth, sideSouth, isInWorld)) {
            helper.renderBox(box, texture);
        }
        helper.setColor(0xFFFFFF);
    }

    protected void renderFrame(RenderHelper helper, double wireSize, double frameSeparation, double frameThickness, boolean down, boolean up, boolean west, boolean east, boolean north, boolean south, boolean isInWorld, IIcon texture, int color) {
        this.renderFrame(helper, wireSize, frameSeparation, frameThickness, down, up, west, east, north, south, down, up, west, east, north, south, isInWorld, texture, color);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        double wireSize = (double)this.getSize() / 16.0;
        double frameSeparation = 0.25 - (wireSize - 0.125);
        double frameThickness = 0.0625;
        int color = this.getColorMultiplier();
        boolean isInWorld = this.getParent() != null;
        boolean down = this.shouldRenderConnection(ForgeDirection.DOWN);
        boolean up = this.shouldRenderConnection(ForgeDirection.UP);
        boolean north = this.shouldRenderConnection(ForgeDirection.NORTH);
        boolean south = this.shouldRenderConnection(ForgeDirection.SOUTH);
        boolean west = this.shouldRenderConnection(ForgeDirection.WEST);
        boolean east = this.shouldRenderConnection(ForgeDirection.EAST);
        renderer.setColor(color);
        renderer.renderBox(new Vec3dCube(0.5 - wireSize / 2.0, 0.5 - wireSize / 2.0, 0.5 - wireSize / 2.0, 0.5 + wireSize / 2.0, 0.5 + wireSize / 2.0, 0.5 + wireSize / 2.0), this.getIcons(ForgeDirection.UNKNOWN));
        if (up || !isInWorld) {
            renderer.renderBox(new Vec3dCube(0.5 - wireSize / 2.0, 0.5 + wireSize / 2.0, 0.5 - wireSize / 2.0, 0.5 + wireSize / 2.0, 1.0, 0.5 + wireSize / 2.0), this.getIcons(ForgeDirection.UP));
        }
        if (down || !isInWorld) {
            renderer.renderBox(new Vec3dCube(0.5 - wireSize / 2.0, 0.0, 0.5 - wireSize / 2.0, 0.5 + wireSize / 2.0, 0.5 - wireSize / 2.0, 0.5 + wireSize / 2.0), this.getIcons(ForgeDirection.DOWN));
        }
        if (north || !isInWorld) {
            renderer.renderBox(new Vec3dCube(0.5 - wireSize / 2.0, 0.5 - wireSize / 2.0, 0.0, 0.5 + wireSize / 2.0, 0.5 + wireSize / 2.0, 0.5 - wireSize / 2.0), this.getIcons(ForgeDirection.NORTH));
        }
        if (south || !isInWorld) {
            renderer.renderBox(new Vec3dCube(0.5 - wireSize / 2.0, 0.5 - wireSize / 2.0, 0.5 + wireSize / 2.0, 0.5 + wireSize / 2.0, 0.5 + wireSize / 2.0, 1.0), this.getIcons(ForgeDirection.SOUTH));
        }
        if (west || !isInWorld) {
            renderer.renderBox(new Vec3dCube(0.0, 0.5 - wireSize / 2.0, 0.5 - wireSize / 2.0, 0.5 - wireSize / 2.0, 0.5 + wireSize / 2.0, 0.5 + wireSize / 2.0), this.getIcons(ForgeDirection.WEST));
        }
        if (east || !isInWorld) {
            renderer.renderBox(new Vec3dCube(0.5 + wireSize / 2.0, 0.5 - wireSize / 2.0, 0.5 - wireSize / 2.0, 1.0, 0.5 + wireSize / 2.0, 0.5 + wireSize / 2.0), this.getIcons(ForgeDirection.EAST));
        }
        renderer.setColor(this.getFrameColorMultiplier());
        this.renderFrame(renderer, wireSize, frameSeparation, frameThickness, down, up, west, east, north, south, isInWorld, this.getFrameIcon(), this.getFrameColorMultiplier());
        return true;
    }

    public int getHollowSize(ForgeDirection side) {
        return 8;
    }
}

