/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.connect.IConnectionListener;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.redstone.BundledConnection;
import com.bluepowermod.redstone.RedConnectionHelper;
import com.bluepowermod.redstone.RedstoneApi;
import net.minecraftforge.common.util.ForgeDirection;

public class BundledConnectionCache
implements IConnectionCache<IBundledDevice> {
    private IBundledDevice dev;
    private BundledConnection[] connections = new BundledConnection[7];
    private boolean listening = false;

    public BundledConnectionCache(IBundledDevice dev) {
        this.dev = dev;
    }

    @Override
    public IBundledDevice getSelf() {
        return this.dev;
    }

    @Override
    public IConnection<IBundledDevice> getConnectionOnSide(ForgeDirection side) {
        return this.connections[side.ordinal()];
    }

    @Override
    public void onConnect(ForgeDirection side, IBundledDevice connectable, ForgeDirection connectableSide, ConnectionType type) {
        BundledConnection bundledConnection = RedstoneApi.getInstance().createConnection(this.getSelf(), connectable, side, connectableSide, type);
        this.connections[side.ordinal()] = bundledConnection;
        BundledConnection con = bundledConnection;
        if (this.listening) {
            ((IConnectionListener)((Object)this.dev)).onConnect(con);
        }
    }

    @Override
    public void onDisconnect(ForgeDirection side) {
        BundledConnection con = this.connections[side.ordinal()];
        this.connections[side.ordinal()] = null;
        if (this.listening) {
            ((IConnectionListener)((Object)this.dev)).onDisconnect(con);
        }
    }

    @Override
    public void recalculateConnections() {
        if (this.dev.getWorld().field_72995_K) {
            return;
        }
        IBundledDevice self = this.getSelf();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            boolean wasConnected = this.connections[d.ordinal()] != null;
            BundledConnection con = RedConnectionHelper.getBundledNeighbor(self, d);
            if (con != null) {
                if (wasConnected && this.connections[d.ordinal()].getB() == con.getB() && this.connections[d.ordinal()].getSideB() == con.getSideB() && this.connections[d.ordinal()].getType() == con.getType()) continue;
                this.onConnect(con.getSideA(), con.getB(), con.getSideB(), con.getType());
                con.getB().getBundledConnectionCache().onConnect(con.getSideB(), con.getA(), con.getSideA(), con.getType());
                IConnection<IBundledDevice> con2 = con.getB().getBundledConnectionCache().getConnectionOnSide(con.getSideB());
                con = this.connections[d.ordinal()];
                if (con == null) {
                    return;
                }
                con.setComplementaryConnection(con2);
                con2.setComplementaryConnection(con);
                continue;
            }
            if (!wasConnected || (con = this.connections[d.ordinal()]) == null) continue;
            this.onDisconnect(con.getSideA());
            con.getB().getBundledConnectionCache().onDisconnect(con.getSideB());
        }
    }

    @Override
    public void disconnectAll() {
        for (BundledConnection con : this.connections) {
            if (con == null) continue;
            con.getB().getBundledConnectionCache().onDisconnect(con.getSideB());
            this.onDisconnect(con.getSideA());
        }
    }

    @Override
    public void listen() {
        this.listening = this.dev instanceof IConnectionListener;
    }
}

