/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.part.tube.TubeStack;
import com.bluepowermod.tile.TileMachineBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTransposer
extends TileMachineBase {
    private static AxisAlignedBB[] ITEM_SUCK_AABBS = new AxisAlignedBB[6];

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.isBufferEmpty() && !this.field_145850_b.field_72995_K) {
            this.suckEntity();
        }
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        ForgeDirection direction = this.getFacingDirection();
        if (!this.field_145850_b.field_72995_K && this.isBufferEmpty() && newValue) {
            if (this.field_145850_b.func_147437_c(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ)) {
                this.suckItems();
            } else {
                this.pullItem();
            }
        }
    }

    @Override
    public TubeStack acceptItemFromTube(TubeStack stack, ForgeDirection from, boolean simulate) {
        if (from == this.getFacingDirection() && this.getIsRedstonePowered()) {
            return stack;
        }
        return super.acceptItemFromTube(stack, from, simulate);
    }

    protected void pullItem() {
        ForgeDirection dir = this.getOutputDirection().getOpposite();
        TileEntity inputTE = this.getTileCache(dir);
        ItemStack extractedStack = IOHelper.extractOneItem(inputTE, dir.getOpposite());
        if (extractedStack != null) {
            this.addItemToOutputBuffer(extractedStack);
        }
    }

    private void suckItems() {
        for (EntityItem entity : this.field_145850_b.func_72872_a(EntityItem.class, ITEM_SUCK_AABBS[this.getFacingDirection().ordinal()].func_72329_c().func_72317_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e))) {
            ItemStack stack = entity.func_92059_d();
            if (!this.isItemAccepted(stack) || entity.field_70128_L) continue;
            this.addItemToOutputBuffer(stack, this.getAcceptedItemColor(stack));
            entity.func_70106_y();
        }
    }

    private void suckEntity() {
        ForgeDirection direction = this.getFacingDirection();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(this.field_145851_c + direction.offsetX), (double)(this.field_145848_d + direction.offsetY), (double)(this.field_145849_e + direction.offsetZ), (double)(this.field_145851_c + direction.offsetX + 1), (double)(this.field_145848_d + direction.offsetY + 1), (double)(this.field_145849_e + direction.offsetZ + 1));
        for (EntityItem entity : this.field_145850_b.func_72872_a(EntityItem.class, box)) {
            ItemStack stack = entity.func_92059_d();
            if (!this.isItemAccepted(stack) || entity.field_70128_L) continue;
            this.addItemToOutputBuffer(stack, this.getAcceptedItemColor(stack));
            entity.func_70106_y();
        }
    }

    protected boolean isItemAccepted(ItemStack item) {
        return true;
    }

    protected IPneumaticTube.TubeColor getAcceptedItemColor(ItemStack item) {
        return IPneumaticTube.TubeColor.NONE;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    static {
        TileTransposer.ITEM_SUCK_AABBS[0] = AxisAlignedBB.func_72330_a((double)-1.0, (double)-1.0, (double)-1.0, (double)2.0, (double)0.0, (double)2.0);
        TileTransposer.ITEM_SUCK_AABBS[1] = AxisAlignedBB.func_72330_a((double)-1.0, (double)1.0, (double)-1.0, (double)2.0, (double)2.0, (double)2.0);
        TileTransposer.ITEM_SUCK_AABBS[2] = AxisAlignedBB.func_72330_a((double)-1.0, (double)-1.0, (double)-1.0, (double)2.0, (double)2.0, (double)0.0);
        TileTransposer.ITEM_SUCK_AABBS[3] = AxisAlignedBB.func_72330_a((double)-1.0, (double)-1.0, (double)1.0, (double)2.0, (double)2.0, (double)2.0);
        TileTransposer.ITEM_SUCK_AABBS[4] = AxisAlignedBB.func_72330_a((double)-1.0, (double)-1.0, (double)-1.0, (double)0.0, (double)2.0, (double)2.0);
        TileTransposer.ITEM_SUCK_AABBS[5] = AxisAlignedBB.func_72330_a((double)1.0, (double)-1.0, (double)-1.0, (double)2.0, (double)2.0, (double)2.0);
    }
}

