/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3i;

@SideOnly(value=Side.CLIENT)
public class LightingHelper {
    private float[][] ao = new float[13][4];
    private int[][] brightness = new int[13][4];
    private int sampledSides = 0;
    private int computedSides = 0;
    private float[] aoSamples = new float[27];
    private int[] brightnessSamples = new int[27];
    private static final int[][] ssamplem = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8}, {18, 19, 20, 21, 22, 23, 24, 25, 26}, {0, 9, 18, 1, 10, 19, 2, 11, 20}, {6, 15, 24, 7, 16, 25, 8, 17, 26}, {0, 3, 6, 9, 12, 15, 18, 21, 24}, {2, 5, 8, 11, 14, 17, 20, 23, 26}, {9, 10, 11, 12, 13, 14, 15, 16, 17}, {9, 10, 11, 12, 13, 14, 15, 16, 17}, {3, 12, 21, 4, 13, 22, 5, 14, 23}, {3, 12, 21, 4, 13, 22, 5, 14, 23}, {1, 4, 7, 10, 13, 16, 19, 22, 25}, {1, 4, 7, 10, 13, 16, 19, 22, 25}, {13, 13, 13, 13, 13, 13, 13, 13, 13}};
    private static final int[][] qsamplem = new int[][]{{0, 1, 3, 4}, {5, 1, 2, 4}, {6, 7, 3, 4}, {5, 7, 8, 4}};
    private static final float[] sideao = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f, 0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f, 1.0f};
    private IBlockAccess access;
    private Vec3i pos;

    public LightingHelper(IBlockAccess world, Vec3i location) {
        this.access = world;
        this.pos = location;
    }

    public int[] getBrightness(int side) {
        this.sideSample(side);
        return this.brightness[side];
    }

    public float[] getAo(int side) {
        this.sideSample(side);
        return this.ao[side];
    }

    public int getVertexBrightness(Vec3d vertex, int side) {
        vertex = vertex.clone().mul(2.0).sub(1.0, 1.0, 1.0);
        int[] b = this.getBrightness(side);
        int br = LightingHelper.interpolateBrightness(b[0], b[1], b[2], b[3]);
        Vec3d v = new Vec3d(0.0, 0.0, 0.0).add(ForgeDirection.getOrientation((int)side)).mul(vertex.getX(), vertex.getY(), vertex.getZ());
        double d = v.getX() + v.getY() + v.getZ();
        if (Math.abs(d) < 0.9) {
            int bbr = this.access.func_147439_a(this.pos.getX(), this.pos.getY(), this.pos.getZ()).func_149677_c(this.access, this.pos.getX(), this.pos.getY(), this.pos.getZ());
            br = LightingHelper.interpolateBrightness(br, br, bbr, bbr);
        }
        return br;
    }

    public float getVertexAo(Vec3d vertex, int side) {
        vertex = vertex.clone().mul(2.0).sub(1.0, 1.0, 1.0);
        float[] a = this.getAo(side);
        float ao = LightingHelper.interpolateAO(a[0], a[1], a[2], a[3]);
        Vec3d v = new Vec3d(0.0, 0.0, 0.0).add(ForgeDirection.getOrientation((int)side)).mul(vertex.getX(), vertex.getY(), vertex.getZ());
        double d = v.getX() + v.getY() + v.getZ();
        if (Math.abs(d) < 0.9) {
            float bao = sideao[side];
            ao = bao * (ao / 3.0f + 0.6666667f);
        }
        return ao;
    }

    public int getVertexBrightness(Vec3d vertex, Vec3d normal) {
        normal = normal.normalize();
        double x = normal.getX();
        double y = normal.getY();
        double z = normal.getZ();
        int br = 0;
        if (x < 0.0) {
            br += LightingHelper.getProportion(this.getVertexBrightness(vertex, ForgeDirection.WEST.ordinal()), -x);
        }
        if (x > 0.0) {
            br += LightingHelper.getProportion(this.getVertexBrightness(vertex, ForgeDirection.EAST.ordinal()), x);
        }
        if (y < 0.0) {
            br += LightingHelper.getProportion(this.getVertexBrightness(vertex, ForgeDirection.DOWN.ordinal()), -y);
        }
        if (y > 0.0) {
            br += LightingHelper.getProportion(this.getVertexBrightness(vertex, ForgeDirection.UP.ordinal()), y);
        }
        if (z < 0.0) {
            br += LightingHelper.getProportion(this.getVertexBrightness(vertex, ForgeDirection.NORTH.ordinal()), -z);
        }
        if (z > 0.0) {
            br += LightingHelper.getProportion(this.getVertexBrightness(vertex, ForgeDirection.SOUTH.ordinal()), z);
        }
        return br & 0xF000F0;
    }

    public float getVertexAo(Vec3d vertex, Vec3d normal) {
        normal = normal.normalize();
        double x = normal.getX();
        double y = normal.getY();
        double z = normal.getZ();
        float ao = 0.0f;
        if (x < 0.0) {
            ao += LightingHelper.getProportion(this.getVertexAo(vertex, ForgeDirection.WEST.ordinal()), -x);
        }
        if (x > 0.0) {
            ao += LightingHelper.getProportion(this.getVertexAo(vertex, ForgeDirection.EAST.ordinal()), x);
        }
        if (y < 0.0) {
            ao += LightingHelper.getProportion(this.getVertexAo(vertex, ForgeDirection.DOWN.ordinal()), -y);
        }
        if (y > 0.0) {
            ao += LightingHelper.getProportion(this.getVertexAo(vertex, ForgeDirection.UP.ordinal()), y);
        }
        if (z < 0.0) {
            ao += LightingHelper.getProportion(this.getVertexAo(vertex, ForgeDirection.NORTH.ordinal()), -z);
        }
        if (z > 0.0) {
            ao += LightingHelper.getProportion(this.getVertexAo(vertex, ForgeDirection.SOUTH.ordinal()), z);
        }
        return Math.max(Math.min(ao, 1.0f), 0.0f);
    }

    public int getFaceBrightness(int brightness, Vec3d normal) {
        float ao = 0.0f;
        normal = normal.normalize();
        double x = normal.getX();
        double y = normal.getY();
        double z = normal.getZ();
        if (x < 0.0) {
            ao = (float)((double)ao + (double)sideao[ForgeDirection.WEST.ordinal()] * -x);
        }
        if (x > 0.0) {
            ao = (float)((double)ao + (double)sideao[ForgeDirection.EAST.ordinal()] * -x);
        }
        if (y < 0.0) {
            ao = (float)((double)ao + (double)sideao[ForgeDirection.DOWN.ordinal()] * -y);
        }
        if (y > 0.0) {
            ao = (float)((double)ao + (double)sideao[ForgeDirection.UP.ordinal()] * y);
        }
        if (z < 0.0) {
            ao = (float)((double)ao + (double)sideao[ForgeDirection.NORTH.ordinal()] * -z);
        }
        if (z > 0.0) {
            ao = (float)((double)ao + (double)sideao[ForgeDirection.SOUTH.ordinal()] * z);
        }
        return LightingHelper.getProportion(brightness, (double)ao);
    }

    private void sample(int side) {
        if ((this.sampledSides & 1 << side) == 0) {
            int x = this.pos.getX() + side % 3 - 1;
            int y = this.pos.getY() + side / 9 - 1;
            int z = this.pos.getZ() + side / 3 % 3 - 1;
            Block b = this.access.func_147439_a(x, y, z);
            this.brightnessSamples[side] = this.access.func_72802_i(x, y, z, b.getLightValue(this.access, x, y, z));
            this.aoSamples[side] = b.func_149685_I();
            this.sampledSides |= 1 << side;
        }
    }

    private void sideSample(int side) {
        if ((this.computedSides & 1 << side) == 0) {
            int[] ssample = ssamplem[side];
            for (int q = 0; q < 4; ++q) {
                int[] qsample = qsamplem[q];
                if (Minecraft.func_71379_u()) {
                    this.interpolateSides(side, q, ssample[qsample[0]], ssample[qsample[1]], ssample[qsample[2]], ssample[qsample[3]]);
                    continue;
                }
                this.interpolateSides(side, q, ssample[4], ssample[4], ssample[4], ssample[4]);
            }
            this.computedSides |= 1 << side;
        }
    }

    private void interpolateSides(int s, int q, int a, int b, int c, int d) {
        this.sample(a);
        this.sample(b);
        this.sample(c);
        this.sample(d);
        this.ao[s][q] = LightingHelper.interpolateAO(this.aoSamples[a], this.aoSamples[b], this.aoSamples[c], this.aoSamples[d]) * sideao[s];
        this.brightness[s][q] = LightingHelper.interpolateBrightness(this.brightnessSamples[a], this.brightnessSamples[b], this.brightnessSamples[c], this.brightnessSamples[d]);
    }

    private static float interpolateAO(float a, float b, float c, float d) {
        return (a + b + c + d) / 4.0f;
    }

    private static int interpolateBrightness(int a, int b, int c, int d) {
        if (a == 0) {
            a = d;
        }
        if (b == 0) {
            b = d;
        }
        if (c == 0) {
            c = d;
        }
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    private static int getProportion(int br, double amt) {
        double a = LightingHelper.getProportion((float)(br & 0xFF), amt);
        double b = LightingHelper.getProportion((float)((br & 0xFF00) >> 4), amt);
        double c = LightingHelper.getProportion((float)((br & 0xFF0000) >> 8), amt);
        return (int)a + ((int)b << 4) + ((int)c << 8);
    }

    private static float getProportion(float ao, double amt) {
        return (float)((double)ao * amt);
    }
}

