/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.client.render.BakedModel;
import uk.co.qmunity.lib.client.render.ExtensionRendering;
import uk.co.qmunity.lib.client.render.LightingHelper;
import uk.co.qmunity.lib.client.render.UVHelper;
import uk.co.qmunity.lib.misc.Pair;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.transform.TransformationList;
import uk.co.qmunity.lib.transform.Translation;
import uk.co.qmunity.lib.vec.Vec2d;
import uk.co.qmunity.lib.vec.Vec2dRect;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    public static final RenderHelper instance = new RenderHelper();
    private IBlockAccess world = null;
    private Vec3i location = new Vec3i(0, 0, 0);
    private LightingHelper lightingHelper = null;
    protected TransformationList transformations = new TransformationList(new Transformation[0]);
    private Vec3d normal = new Vec3d(0.0, 0.0, 0.0);
    private int[] rotations = new int[]{0, 0, 0, 0, 0, 0};
    private boolean[] sides = new boolean[]{true, true, true, true, true, true};
    private boolean renderFromInside = false;
    private int color = 0xFFFFFF;
    private double opacity = 1.0;
    private IIcon overrideTexture = null;
    private ExtensionRendering renderingMethod = ExtensionRendering.SAME_TEXTURE;
    private boolean ignoreLighting = false;
    private int lightingOverride = 0;
    private Transformation vertexTransformation = null;

    public void reset() {
        this.setRenderCoords(null, 0, 0, 0);
        this.transformations.clear();
        this.setNormal(0.0, 0.0, 0.0);
        this.resetTextureRotations();
        this.resetRenderedSides();
        this.resetTransformations();
        this.renderFromInside = false;
        this.color = 0xFFFFFF;
        this.opacity = 1.0;
        this.renderingMethod = ExtensionRendering.SAME_TEXTURE;
        this.ignoreLighting = false;
        this.lightingOverride = 0;
        this.vertexTransformation = null;
    }

    public void fullReset() {
        this.reset();
        this.setOverrideTexture(null);
    }

    public void resetTextureRotations() {
        this.rotations = new int[]{0, 0, 0, 0, 0, 0};
    }

    public void resetRenderedSides() {
        this.sides = new boolean[]{true, true, true, true, true, true};
    }

    public void resetTransformations() {
        this.transformations.clear();
    }

    public void setOverrideTexture(IIcon texture) {
        this.overrideTexture = texture;
    }

    public IIcon getOverrideTexture() {
        return this.overrideTexture;
    }

    public void setRenderFromInside(boolean render) {
        this.renderFromInside = render;
    }

    public void setRenderCoords(IBlockAccess world, int x, int y, int z) {
        this.world = world;
        this.location = new Vec3i(x, y, z);
        if (world != null) {
            this.lightingHelper = new LightingHelper(world, this.location);
        }
    }

    public void addTransformation(Transformation transformation) {
        this.transformations.add(transformation);
    }

    public void removeTransformation() {
        if (this.transformations.size() > 0) {
            this.transformations.remove(this.transformations.size() - 1);
        }
    }

    public void removeTransformations(int amount) {
        for (int i = 0; i < amount && this.transformations.size() > 0; ++i) {
            this.transformations.remove(this.transformations.size() - 1);
        }
    }

    public void setNormal(double x, double y, double z) {
        this.normal = new Vec3d(x, y, z);
    }

    public void setTextureRotation(ForgeDirection side, int times) {
        if ((times %= 4) < 0) {
            times += 4;
        }
        this.rotations[side.ordinal()] = times;
    }

    public void setTextureRotations(int down, int up, int west, int east, int north, int south) {
        this.setTextureRotation(ForgeDirection.DOWN, down);
        this.setTextureRotation(ForgeDirection.UP, up);
        this.setTextureRotation(ForgeDirection.WEST, west);
        this.setTextureRotation(ForgeDirection.EAST, east);
        this.setTextureRotation(ForgeDirection.NORTH, north);
        this.setTextureRotation(ForgeDirection.SOUTH, south);
    }

    public void setRenderSide(ForgeDirection side, boolean rendered) {
        this.sides[side.ordinal()] = rendered;
    }

    public void setRenderSides(boolean down, boolean up, boolean west, boolean east, boolean north, boolean south) {
        this.setRenderSide(ForgeDirection.DOWN, down);
        this.setRenderSide(ForgeDirection.UP, up);
        this.setRenderSide(ForgeDirection.WEST, west);
        this.setRenderSide(ForgeDirection.EAST, east);
        this.setRenderSide(ForgeDirection.NORTH, north);
        this.setRenderSide(ForgeDirection.SOUTH, south);
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    public int getColor() {
        return this.color;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setRenderingMethod(ExtensionRendering renderingMethod) {
        if (renderingMethod != null) {
            this.renderingMethod = renderingMethod;
        }
    }

    public ExtensionRendering getRenderingMethod() {
        return this.renderingMethod;
    }

    public void setIgnoreLighting(boolean ignoreLighting) {
        this.ignoreLighting = ignoreLighting;
    }

    public void setLightingOverride(int lightingOverride) {
        this.lightingOverride = lightingOverride;
    }

    public void addVertex(double x, double y, double z) {
        this.addVertex(x, y, z, 0.0, 0.0);
    }

    public void addVertex(double x, double y, double z, double u, double v) {
        Vec3d vertex = new Vec3d(x, y, z);
        if (this.vertexTransformation != null) {
            vertex = vertex.transform(this.vertexTransformation);
        }
        vertex = vertex.transform(this.transformations);
        Vec3d normal = this.normal.clone().add(0.5, 0.5, 0.5).transform(this.transformations).sub(0.5, 0.5, 0.5);
        Vec3d normalTranslations = new Vec3d(0.5, 0.5, 0.5).transform(this.transformations).sub(0.5, 0.5, 0.5);
        normal.sub(normalTranslations);
        int brightness = this.world != null && this.lightingHelper != null ? (this.ignoreLighting ? this.lightingHelper.getFaceBrightness(this.lightingOverride, normal) : this.lightingHelper.getVertexBrightness(vertex, normal)) : 0xF000F0;
        double ao = this.world != null && this.lightingHelper != null && !this.ignoreLighting ? (double)this.lightingHelper.getVertexAo(vertex, normal) : 1.0;
        int color = 0;
        color += (int)((double)(this.color >> 0 & 0xFF) * ao) << 0;
        color += (int)((double)(this.color >> 8 & 0xFF) * ao) << 8;
        this.addVertex_do(vertex, normal, color += (int)((double)(this.color >> 16 & 0xFF) * ao) << 16, (int)(this.opacity * 255.0), brightness, u, v);
    }

    public void addVertex_do(Vec3d vertex, Vec3d normal, int color, int opacity, int brightness, double u, double v) {
        if (brightness == -1) {
            brightness = this.world != null && this.lightingHelper != null ? (this.ignoreLighting ? this.lightingHelper.getFaceBrightness(this.lightingOverride, normal) : this.lightingHelper.getVertexBrightness(vertex, normal)) : 0xF000F0;
        }
        Tessellator.field_78398_a.func_78385_a(u, v);
        Tessellator.field_78398_a.func_78380_c(brightness);
        Tessellator.field_78398_a.func_78384_a(color, opacity);
        Tessellator.field_78398_a.func_78375_b((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
        Tessellator.field_78398_a.func_78377_a(vertex.getX(), vertex.getY(), vertex.getZ());
    }

    public Vec3i getLocation() {
        return this.location;
    }

    public IBlockAccess getWorld() {
        return this.world;
    }

    public void renderBox(Vec3dCube cube) {
        this.renderBox(cube, (IIcon)null);
    }

    public void renderBox(Vec3dCube cube, IIcon icon) {
        this.renderBox(cube, icon, icon, icon, icon, icon, icon);
    }

    public void renderBox(Vec3dCube cube, IIcon[] icons) {
        this.renderBox(cube, icons[0], icons[1], icons[2], icons[3], icons[4], icons[5]);
    }

    public void renderBox(Vec3dCube cube, IIcon down, IIcon up, IIcon west, IIcon east, IIcon north, IIcon south) {
        if (cube.getMinX() < 0.0 || cube.getMinY() < 0.0 || cube.getMinZ() < 0.0 || cube.getMaxX() > 1.0 || cube.getMaxY() > 1.0 || cube.getMaxZ() > 1.0) {
            if (this.renderingMethod == ExtensionRendering.SAME_TEXTURE) {
                LightingHelper h = this.lightingHelper;
                for (Pair<Pair<Vec3dCube, Translation>, boolean[]> data : cube.splitInto1x1()) {
                    this.sides = data.getValue();
                    Translation tr = data.getKey().getValue();
                    if (tr.getX() == 0.0 && tr.getY() == 0.0 && tr.getZ() == 0.0) {
                        this.lightingHelper = h;
                    } else {
                        Vec3d t = new Vec3d(tr.getX(), tr.getY(), tr.getZ()).transform(this.transformations);
                        this.lightingHelper = new LightingHelper(this.getWorld(), new Vec3i((int)t.getX(), (int)t.getY(), (int)t.getZ()).add(this.getLocation()));
                    }
                    this.vertexTransformation = tr;
                    this.renderBox_do(data.getKey().getKey(), down, up, west, east, north, south);
                    this.vertexTransformation = null;
                }
                this.resetRenderedSides();
                this.lightingHelper = h;
            }
        } else {
            this.renderBox_do(cube, down, up, west, east, north, south);
        }
    }

    public void renderBox_do(Vec3dCube cube, IIcon down, IIcon up, IIcon west, IIcon east, IIcon north, IIcon south) {
        Tessellator.field_78398_a.func_78372_c((float)this.location.getX(), (float)this.location.getY(), (float)this.location.getZ());
        if (this.sides[ForgeDirection.WEST.ordinal()]) {
            this.setNormal(-1.0, 0.0, 0.0);
            this.renderFaceXNeg(cube.getFace(ForgeDirection.WEST), cube.getMinX(), west);
        }
        if (this.sides[ForgeDirection.EAST.ordinal()]) {
            this.setNormal(1.0, 0.0, 0.0);
            this.renderFaceXPos(cube.getFace(ForgeDirection.EAST), cube.getMaxX(), east);
        }
        if (this.sides[ForgeDirection.DOWN.ordinal()]) {
            this.setNormal(0.0, -1.0, 0.0);
            this.renderFaceYNeg(cube.getFace(ForgeDirection.DOWN), cube.getMinY(), down);
        }
        if (this.sides[ForgeDirection.UP.ordinal()]) {
            this.setNormal(0.0, 1.0, 0.0);
            this.renderFaceYPos(cube.getFace(ForgeDirection.UP), cube.getMaxY(), up);
        }
        if (this.sides[ForgeDirection.NORTH.ordinal()]) {
            this.setNormal(0.0, 0.0, -1.0);
            this.renderFaceZNeg(cube.getFace(ForgeDirection.NORTH), cube.getMinZ(), north);
        }
        if (this.sides[ForgeDirection.SOUTH.ordinal()]) {
            this.setNormal(0.0, 0.0, 1.0);
            this.renderFaceZPos(cube.getFace(ForgeDirection.SOUTH), cube.getMaxZ(), south);
        }
        Tessellator.field_78398_a.func_78372_c((float)(-this.location.getX()), (float)(-this.location.getY()), (float)(-this.location.getZ()));
    }

    public void renderFaceXNeg(Vec2dRect face, double x, IIcon icon) {
        if (this.overrideTexture != null) {
            icon = this.overrideTexture;
        }
        if (icon == null) {
            return;
        }
        Vec3d v1 = new Vec3d(x, face.getMinX(), face.getMinY());
        Vec3d v2 = new Vec3d(x, face.getMinX(), face.getMaxY());
        Vec3d v3 = new Vec3d(x, face.getMaxX(), face.getMaxY());
        Vec3d v4 = new Vec3d(x, face.getMaxX(), face.getMinY());
        double a = this.rotations[ForgeDirection.WEST.ordinal()] * 90;
        Vec2d t1 = UVHelper.rotateUV(new Vec2d(face.getMinY(), 1.0 - face.getMinX()), a, icon);
        Vec2d t2 = UVHelper.rotateUV(new Vec2d(face.getMaxY(), 1.0 - face.getMinX()), a, icon);
        Vec2d t3 = UVHelper.rotateUV(new Vec2d(face.getMaxY(), 1.0 - face.getMaxX()), a, icon);
        Vec2d t4 = UVHelper.rotateUV(new Vec2d(face.getMinY(), 1.0 - face.getMaxX()), a, icon);
        this.renderFace(v1, v2, v3, v4, t1, t2, t3, t4);
    }

    public void renderFaceXPos(Vec2dRect face, double x, IIcon icon) {
        if (this.overrideTexture != null) {
            icon = this.overrideTexture;
        }
        if (icon == null) {
            return;
        }
        Vec3d v1 = new Vec3d(x, face.getMinX(), face.getMinY());
        Vec3d v2 = new Vec3d(x, face.getMaxX(), face.getMinY());
        Vec3d v3 = new Vec3d(x, face.getMaxX(), face.getMaxY());
        Vec3d v4 = new Vec3d(x, face.getMinX(), face.getMaxY());
        double a = this.rotations[ForgeDirection.EAST.ordinal()] * 90;
        Vec2d t1 = UVHelper.rotateUV(new Vec2d(face.getMinY(), 1.0 - face.getMinX()), a, icon);
        Vec2d t2 = UVHelper.rotateUV(new Vec2d(face.getMinY(), 1.0 - face.getMaxX()), a, icon);
        Vec2d t3 = UVHelper.rotateUV(new Vec2d(face.getMaxY(), 1.0 - face.getMaxX()), a, icon);
        Vec2d t4 = UVHelper.rotateUV(new Vec2d(face.getMaxY(), 1.0 - face.getMinX()), a, icon);
        this.renderFace(v1, v2, v3, v4, t1, t2, t3, t4);
    }

    public void renderFaceYNeg(Vec2dRect face, double y, IIcon icon) {
        if (this.overrideTexture != null) {
            icon = this.overrideTexture;
        }
        if (icon == null) {
            return;
        }
        Vec3d v1 = new Vec3d(face.getMinX(), y, face.getMinY());
        Vec3d v2 = new Vec3d(face.getMaxX(), y, face.getMinY());
        Vec3d v3 = new Vec3d(face.getMaxX(), y, face.getMaxY());
        Vec3d v4 = new Vec3d(face.getMinX(), y, face.getMaxY());
        double a = this.rotations[ForgeDirection.DOWN.ordinal()] * 90;
        Vec2d t1 = UVHelper.rotateUV(new Vec2d(face.getMinX(), face.getMinY()), a, icon);
        Vec2d t2 = UVHelper.rotateUV(new Vec2d(face.getMaxX(), face.getMinY()), a, icon);
        Vec2d t3 = UVHelper.rotateUV(new Vec2d(face.getMaxX(), face.getMaxY()), a, icon);
        Vec2d t4 = UVHelper.rotateUV(new Vec2d(face.getMinX(), face.getMaxY()), a, icon);
        this.renderFace(v1, v2, v3, v4, t1, t2, t3, t4);
    }

    public void renderFaceYPos(Vec2dRect face, double y, IIcon icon) {
        if (this.overrideTexture != null) {
            icon = this.overrideTexture;
        }
        if (icon == null) {
            return;
        }
        Vec3d v1 = new Vec3d(face.getMinX(), y, face.getMinY());
        Vec3d v2 = new Vec3d(face.getMinX(), y, face.getMaxY());
        Vec3d v3 = new Vec3d(face.getMaxX(), y, face.getMaxY());
        Vec3d v4 = new Vec3d(face.getMaxX(), y, face.getMinY());
        double a = this.rotations[ForgeDirection.UP.ordinal()] * 90;
        Vec2d t1 = UVHelper.rotateUV(new Vec2d(face.getMinX(), face.getMinY()), a, icon);
        Vec2d t2 = UVHelper.rotateUV(new Vec2d(face.getMinX(), face.getMaxY()), a, icon);
        Vec2d t3 = UVHelper.rotateUV(new Vec2d(face.getMaxX(), face.getMaxY()), a, icon);
        Vec2d t4 = UVHelper.rotateUV(new Vec2d(face.getMaxX(), face.getMinY()), a, icon);
        this.renderFace(v1, v2, v3, v4, t1, t2, t3, t4);
    }

    public void renderFaceZNeg(Vec2dRect face, double z, IIcon icon) {
        if (this.overrideTexture != null) {
            icon = this.overrideTexture;
        }
        if (icon == null) {
            return;
        }
        Vec3d v1 = new Vec3d(face.getMinX(), face.getMinY(), z);
        Vec3d v2 = new Vec3d(face.getMinX(), face.getMaxY(), z);
        Vec3d v3 = new Vec3d(face.getMaxX(), face.getMaxY(), z);
        Vec3d v4 = new Vec3d(face.getMaxX(), face.getMinY(), z);
        double a = this.rotations[ForgeDirection.NORTH.ordinal()] * 90;
        Vec2d t1 = UVHelper.rotateUV(new Vec2d(face.getMinX(), 1.0 - face.getMinY()), a, icon);
        Vec2d t2 = UVHelper.rotateUV(new Vec2d(face.getMinX(), 1.0 - face.getMaxY()), a, icon);
        Vec2d t3 = UVHelper.rotateUV(new Vec2d(face.getMaxX(), 1.0 - face.getMaxY()), a, icon);
        Vec2d t4 = UVHelper.rotateUV(new Vec2d(face.getMaxX(), 1.0 - face.getMinY()), a, icon);
        this.renderFace(v1, v2, v3, v4, t1, t2, t3, t4);
    }

    public void renderFaceZPos(Vec2dRect face, double z, IIcon icon) {
        if (this.overrideTexture != null) {
            icon = this.overrideTexture;
        }
        if (icon == null) {
            return;
        }
        Vec3d v1 = new Vec3d(face.getMinX(), face.getMinY(), z);
        Vec3d v2 = new Vec3d(face.getMaxX(), face.getMinY(), z);
        Vec3d v3 = new Vec3d(face.getMaxX(), face.getMaxY(), z);
        Vec3d v4 = new Vec3d(face.getMinX(), face.getMaxY(), z);
        double a = this.rotations[ForgeDirection.SOUTH.ordinal()] * 90;
        Vec2d t1 = UVHelper.rotateUV(new Vec2d(face.getMinX(), 1.0 - face.getMinY()), a, icon);
        Vec2d t2 = UVHelper.rotateUV(new Vec2d(face.getMaxX(), 1.0 - face.getMinY()), a, icon);
        Vec2d t3 = UVHelper.rotateUV(new Vec2d(face.getMaxX(), 1.0 - face.getMaxY()), a, icon);
        Vec2d t4 = UVHelper.rotateUV(new Vec2d(face.getMinX(), 1.0 - face.getMaxY()), a, icon);
        this.renderFace(v1, v2, v3, v4, t1, t2, t3, t4);
    }

    private void renderFace(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, Vec2d t1, Vec2d t2, Vec2d t3, Vec2d t4) {
        Vec3d normal = this.normal;
        if (this.renderFromInside) {
            Vec3d v = v2;
            v2 = v4;
            v4 = v;
            Vec2d t = t2;
            t2 = t4;
            t4 = t;
            this.normal = new Vec3d(0.0, 0.0, 0.0).sub(normal);
        }
        this.addVertex(v1.getX(), v1.getY(), v1.getZ(), t1.getX(), t1.getY());
        this.addVertex(v2.getX(), v2.getY(), v2.getZ(), t2.getX(), t2.getY());
        this.addVertex(v3.getX(), v3.getY(), v3.getZ(), t3.getX(), t3.getY());
        this.addVertex(v4.getX(), v4.getY(), v4.getZ(), t4.getX(), t4.getY());
        this.normal = normal;
    }

    public void renderBakedModel(BakedModel model) {
        model.render(this);
    }
}

