/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.helper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;

public class TeleportHelper {
    public static TeleportQueue teleportQueue;

    public TeleportHelper() {
        teleportQueue = new TeleportQueue();
    }

    public static boolean movePlayer(String playername, int dim, ChunkCoordinates dest) {
        EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playername);
        if (MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playername) != null) {
            if (player.field_71093_bK != dim) {
                MinecraftServer.func_71276_C().func_71203_ab().func_72356_a(player, dim);
            }
            player.func_70634_a((double)dest.field_71574_a, (double)dest.field_71572_b, (double)dest.field_71573_c);
            return true;
        }
        TeleportHelper.queuePlayer(playername, dim, dest);
        return false;
    }

    public static boolean sendToDefaultSpawn(String playername) {
        if (MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playername) != null) {
            EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playername);
            if (player.getBedLocation(0) != null) {
                return TeleportHelper.sendToBed(playername);
            }
            return TeleportHelper.sendToDimension(playername, 0);
        }
        teleportQueue.addToQueue(playername);
        return false;
    }

    public static boolean sendToBed(String playername) {
        EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playername);
        ChunkCoordinates dest = player.getBedLocation(0);
        return TeleportHelper.movePlayer(playername, 0, dest);
    }

    public static boolean sendToDimension(String playername, int dim) {
        ChunkCoordinates dest = MinecraftServer.func_71276_C().func_71218_a(dim).func_72861_E();
        return TeleportHelper.movePlayer(playername, dim, dest);
    }

    public static boolean sendToLocation(String playername, int dim, int x, int y, int z) {
        return TeleportHelper.movePlayer(playername, dim, new ChunkCoordinates(x, y, z));
    }

    private static boolean queuePlayer(String playername, int dim, ChunkCoordinates dest) {
        if (!teleportQueue.isQueued(playername)) {
            return teleportQueue.addToQueue(playername, dim, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c);
        }
        return false;
    }

    public class TeleportQueue {
        private List<TeleportEntry> queue = new ArrayList<TeleportEntry>();

        public boolean addToQueue(String player) {
            return this.queue.add(new TeleportEntry(player));
        }

        public boolean addToQueue(String player, int dim, int x, int y, int z) {
            return this.queue.add(new TeleportEntry(player.toLowerCase(), dim, x, y, z));
        }

        public void clearQueue() {
            teleportQueue = new TeleportQueue();
        }

        public boolean process(String player) {
            for (TeleportEntry te : this.queue) {
                if (!te.getPlayer().equals(player.toLowerCase())) continue;
                if (te.type.equals("default")) {
                    TeleportHelper.sendToDefaultSpawn(te.getPlayer());
                } else {
                    TeleportHelper.sendToLocation(player, te.getDim(), te.getX(), te.getY(), te.getZ());
                }
                this.remove(player);
                return true;
            }
            return false;
        }

        public void remove(String player) {
            for (TeleportEntry te : this.queue) {
                if (!te.getPlayer().equals(player.toLowerCase())) continue;
                this.queue.remove(te);
            }
        }

        public boolean isQueued(String player) {
            for (TeleportEntry te : this.queue) {
                if (!te.getPlayer().equals(player.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        public List<String> getQueue() {
            ArrayList<String> queuedPlayers = new ArrayList<String>();
            for (TeleportEntry te : this.queue) {
                queuedPlayers.add(te.getPlayer());
            }
            return queuedPlayers;
        }

        public class TeleportEntry {
            private String player;
            private String type;
            private int dim;
            private int x;
            private int y;
            private int z;

            public TeleportEntry(String player, int dim, int x, int y, int z) {
                this.player = player;
                this.type = "location";
                this.dim = dim;
                this.x = x;
                this.y = y;
                this.z = z;
            }

            public TeleportEntry(String player) {
                this.player = player;
                this.type = "default";
            }

            public String getPlayer() {
                return this.player;
            }

            public int getDim() {
                return this.dim;
            }

            public int getX() {
                return this.x;
            }

            public int getY() {
                return this.y;
            }

            public int getZ() {
                return this.z;
            }
        }
    }
}

