/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import uk.co.qmunity.lib.network.Packet;
import uk.co.qmunity.lib.vec.IWorldLocation;

public abstract class LocatedPacket<T extends LocatedPacket<T>>
extends Packet<T> {
    protected int x;
    protected int y;
    protected int z;

    public LocatedPacket(IWorldLocation location) {
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
    }

    public LocatedPacket(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public LocatedPacket() {
    }

    @Override
    public void read(DataInput buffer) throws IOException {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    @Override
    public void write(DataOutput buffer) throws IOException {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world, double range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)this.x, (double)this.y, (double)this.z, range);
    }

    protected TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }
}

