/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.part.compat;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.IMicroblock;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartOccluding;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.MicroblockShape;
import uk.co.qmunity.lib.part.PartNormallyOccluded;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class OcclusionHelper {
    public static PartNormallyOccluded getMicroblockPart(MicroblockShape shape, int size, ForgeDirection ... sides) {
        if (shape == MicroblockShape.FACE) {
            return new PartNormallyOccluded(OcclusionHelper.getFaceMicroblockBox(size, sides[0]));
        }
        if (shape == MicroblockShape.FACE_HOLLOW) {
            return new PartNormallyOccluded(OcclusionHelper.getHollowFaceMicroblockBox(size, sides[0]));
        }
        if (shape == MicroblockShape.EDGE) {
            return new PartNormallyOccluded(OcclusionHelper.getEdgeMicroblockBox(size, sides[0], sides[1]));
        }
        if (shape == MicroblockShape.CORNER) {
            return new PartNormallyOccluded(OcclusionHelper.getCornerMicroblockBox(size, sides[0], sides[1], sides[2]));
        }
        return new PartNormallyOccluded(new Vec3dCube(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
    }

    public static boolean microblockOcclusionTest(Vec3i block, MicroblockShape shape, int size, ForgeDirection ... sides) {
        return OcclusionHelper.microblockOcclusionTest(block.getWorld(), block, shape, size, sides);
    }

    public static boolean microblockOcclusionTest(World world, Vec3i block, MicroblockShape shape, int size, ForgeDirection ... sides) {
        ArrayList<IPart> parts = new ArrayList<IPart>();
        for (IPart iPart : MultipartCompatibility.getMicroblocks(world, block)) {
            parts.add(iPart);
        }
        return OcclusionHelper.occlusionTest(parts, (IPart)OcclusionHelper.getMicroblockPart(shape, size, sides));
    }

    public static boolean microblockOcclusionTest(ITilePartHolder holder, MicroblockShape shape, int size, ForgeDirection ... sides) {
        return OcclusionHelper.microblockOcclusionTest(holder, false, shape, size, sides);
    }

    public static boolean microblockOcclusionTest(ITilePartHolder holder, boolean allParts, MicroblockShape shape, int size, ForgeDirection ... sides) {
        ArrayList<IPart> parts = new ArrayList<IPart>();
        if (allParts) {
            parts.addAll(holder.getParts());
        }
        for (IPart iPart : holder.getMicroblocks()) {
            if (parts.contains(iPart)) continue;
            parts.add(iPart);
        }
        return OcclusionHelper.occlusionTest(parts, (IPart)OcclusionHelper.getMicroblockPart(shape, size, sides));
    }

    public static boolean microblockOcclusionTest(ITilePartHolder holder, IMicroblock microblock) {
        ArrayList<IPart> parts = new ArrayList<IPart>();
        for (IPart iPart : holder.getMicroblocks()) {
            parts.add(iPart);
        }
        return OcclusionHelper.occlusionTest(parts, (IPart)microblock);
    }

    public static Vec3dCube getFaceMicroblockBox(int size, ForgeDirection face) {
        double s = (double)(size * 2) / 16.0;
        return new Vec3dCube(face.offsetX > 0 ? 1.0 - s : 0.0, face.offsetY > 0 ? 1.0 - s : 0.0, face.offsetZ > 0 ? 1.0 - s : 0.0, face.offsetX < 0 ? s : 1.0, face.offsetY < 0 ? s : 1.0, face.offsetZ < 0 ? s : 1.0);
    }

    public static Vec3dCube getHollowFaceMicroblockBox(int size, ForgeDirection face) {
        double s = 0.125;
        double d = (double)size / 32.0;
        return new Vec3dCube(face.offsetX > 0 ? 1.0 - s : (face.offsetX < 0 ? 0.0 : 0.5 - d), face.offsetY > 0 ? 1.0 - s : (face.offsetY < 0 ? 0.0 : 0.5 - d), face.offsetZ > 0 ? 1.0 - s : (face.offsetZ < 0 ? 0.0 : 0.5 - d), face.offsetX < 0 ? s : (face.offsetX > 0 ? 1.0 : 0.5 + d), face.offsetY < 0 ? s : (face.offsetY > 0 ? 1.0 : 0.5 + d), face.offsetZ < 0 ? s : (face.offsetZ > 0 ? 1.0 : 0.5 + d));
    }

    public static Vec3dCube getEdgeMicroblockBox(int size, ForgeDirection side1, ForgeDirection side2) {
        boolean x = side1.offsetX > 0 || side2.offsetX > 0;
        boolean y = side1.offsetY > 0 || side2.offsetY > 0;
        boolean z = side1.offsetZ > 0 || side2.offsetZ > 0;
        double s = (double)(size * 2) / 16.0;
        return new Vec3dCube(side1.offsetX == 0 && side2.offsetX == 0 ? s : (x ? 1.0 - s : 0.0), side1.offsetY == 0 && side2.offsetY == 0 ? s : (y ? 1.0 - s : 0.0), side1.offsetZ == 0 && side2.offsetZ == 0 ? s : (z ? 1.0 - s : 0.0), side1.offsetX == 0 && side2.offsetX == 0 ? 1.0 - s : (x ? 1.0 : s), side1.offsetY == 0 && side2.offsetY == 0 ? 1.0 - s : (y ? 1.0 : s), side1.offsetZ == 0 && side2.offsetZ == 0 ? 1.0 - s : (z ? 1.0 : s));
    }

    public static Vec3dCube getCornerMicroblockBox(int size, ForgeDirection side1, ForgeDirection side2, ForgeDirection side3) {
        boolean x = side1.offsetX > 0 || side2.offsetX > 0 || side3.offsetX > 0;
        boolean y = side1.offsetY > 0 || side2.offsetY > 0 || side3.offsetY > 0;
        boolean z = side1.offsetZ > 0 || side2.offsetZ > 0 || side3.offsetZ > 0;
        double s = (double)(size * 2) / 16.0;
        return new Vec3dCube(x ? 1.0 - s : 0.0, y ? 1.0 - s : 0.0, z ? 1.0 - s : 0.0, x ? 1.0 : s, y ? 1.0 : s, z ? 1.0 : s);
    }

    public static boolean occlusionTest(Vec3i block, Collection<Vec3dCube> boxes) {
        return OcclusionHelper.occlusionTest(block.getWorld(), block, boxes);
    }

    public static boolean occlusionTest(World world, Vec3i block, Collection<Vec3dCube> boxes) {
        ITilePartHolder holder = MultipartCompatibility.getPartHolder(world, block);
        if (holder != null) {
            return OcclusionHelper.occlusionTest(holder, boxes);
        }
        return true;
    }

    public static boolean occlusionTest(ITilePartHolder holder, Collection<Vec3dCube> boxes) {
        for (Vec3dCube box : boxes) {
            if (OcclusionHelper.occlusionTest(holder, box)) continue;
            return false;
        }
        return true;
    }

    public static boolean occlusionTest(Collection<IPart> parts, Collection<Vec3dCube> boxes) {
        for (IPart p : parts) {
            for (Vec3dCube box : boxes) {
                if (OcclusionHelper.occlusionTest(p, box)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean occlusionTest(IPart part, Collection<Vec3dCube> boxes) {
        for (Vec3dCube box : boxes) {
            if (OcclusionHelper.occlusionTest(part, box)) continue;
            return false;
        }
        return true;
    }

    public static boolean occlusionTest(Vec3i block, Vec3dCube box) {
        return OcclusionHelper.occlusionTest(block.getWorld(), block, box);
    }

    public static boolean occlusionTest(World world, Vec3i block, Vec3dCube box) {
        ITilePartHolder holder = MultipartCompatibility.getPartHolder(world, block);
        if (holder != null) {
            return OcclusionHelper.occlusionTest(holder, box);
        }
        return true;
    }

    public static boolean occlusionTest(ITilePartHolder holder, Vec3dCube box) {
        return OcclusionHelper.occlusionTest(holder, (IPart)new PartNormallyOccluded(box));
    }

    public static boolean occlusionTest(Collection<IPart> parts, Vec3dCube box) {
        return OcclusionHelper.occlusionTest(parts, (IPart)new PartNormallyOccluded(box));
    }

    public static boolean occlusionTest(IPart part, Vec3dCube box) {
        return OcclusionHelper.occlusionTest(part, (IPart)new PartNormallyOccluded(box));
    }

    public static boolean occlusionTest(Vec3i block, IPart part) {
        return OcclusionHelper.occlusionTest(block.getWorld(), block, part);
    }

    public static boolean occlusionTest(World world, Vec3i block, IPart part) {
        ITilePartHolder holder = MultipartCompatibility.getPartHolder(world, block);
        if (holder != null) {
            return OcclusionHelper.occlusionTest(holder, part);
        }
        return true;
    }

    public static boolean occlusionTest(ITilePartHolder holder, IPart part) {
        return OcclusionHelper.occlusionTest(holder.getParts(), part);
    }

    public static boolean occlusionTest(Collection<IPart> parts, IPart part) {
        for (IPart p : parts) {
            if (p.occlusionTest(part) && part.occlusionTest(p)) continue;
            return false;
        }
        return true;
    }

    public static boolean occlusionTest(IPart part, IPart part2) {
        if (part instanceof IPartOccluding && part2 instanceof IPartOccluding) {
            IPartOccluding p1 = (IPartOccluding)part;
            IPartOccluding p2 = (IPartOccluding)part2;
            for (Vec3dCube c1 : p1.getOcclusionBoxes()) {
                for (Vec3dCube c2 : p2.getOcclusionBoxes()) {
                    if (c1.occlusionTest(c2)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

