/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.peripheral;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import openccsensors.OpenCCSensors;
import openccsensors.api.IMethodCallback;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorAccess;
import openccsensors.api.ISensorEnvironment;
import openccsensors.api.SensorCard;
import openccsensors.common.item.ItemSensorCard;
import openccsensors.common.util.CallbackEventManager;

public class PeripheralSensor
implements IPeripheral,
ISensorAccess {
    private ISensorEnvironment env;
    private boolean isTurtle;
    private CallbackEventManager eventManager = new CallbackEventManager();

    public ISensorAccess getThis() {
        return this;
    }

    public PeripheralSensor(ISensorEnvironment _env, boolean _turtle) {
        this.env = _env;
        this.isTurtle = _turtle;
        this.eventManager.registerCallback(new IMethodCallback(){

            @Override
            public String getMethodName() {
                return "getTargets";
            }

            @Override
            public Object execute(IComputerAccess computer, Object[] arguments) throws Exception {
                SensorCard card = PeripheralSensor.this.getSensorCard();
                if (card != null) {
                    ChunkCoordinates location = PeripheralSensor.this.env.getLocation();
                    ISensor sensor = card.getSensor();
                    if (sensor != null) {
                        HashMap targets = sensor.getTargets(PeripheralSensor.this.env.getWorld(), location, card.getTier());
                        for (Map.Entry entry : targets.entrySet()) {
                            entry.setValue(sensor.getDetails(PeripheralSensor.this.env.getWorld(), entry.getValue(), location, false));
                        }
                        return targets;
                    }
                    throw new Exception("There was a problem with your sensor card. Please report details on the OpenCCSensors bug tracker");
                }
                throw new Exception("Could not find a valid sensor card");
            }
        });
        this.eventManager.registerCallback(new IMethodCallback(){

            @Override
            public String getMethodName() {
                return "getTargetDetails";
            }

            @Override
            public Object execute(IComputerAccess computer, Object[] arguments) throws Exception {
                if (arguments.length != 1 || !(arguments[0] instanceof String)) {
                    throw new Exception("getTargetDetails takes just one argument, which should be the name of the target you're trying to retrieve");
                }
                String targetName = (String)arguments[0];
                SensorCard card = PeripheralSensor.this.getSensorCard();
                if (card == null) {
                    throw new Exception("Could not find a valid sensor card");
                }
                ChunkCoordinates location = PeripheralSensor.this.env.getLocation();
                ISensor sensor = card.getSensor();
                HashMap targets = sensor.getTargets(PeripheralSensor.this.env.getWorld(), location, card.getTier());
                if (!targets.containsKey(targetName)) {
                    throw new Exception("Sensor cannot find data at location");
                }
                return sensor.getDetails(PeripheralSensor.this.env.getWorld(), targets.get(targetName), location, true);
            }
        });
        this.eventManager.registerCallback(new IMethodCallback(){

            @Override
            public String getMethodName() {
                return "getSensorName";
            }

            @Override
            public Object execute(IComputerAccess computer, Object[] arguments) throws Exception {
                if (arguments.length > 0) {
                    throw new Exception("getSensorName does not take any arguments");
                }
                SensorCard sensorCard = PeripheralSensor.this.getSensorCard();
                if (sensorCard == null) {
                    return null;
                }
                return sensorCard.getSensor().getName();
            }
        });
        this.eventManager.registerCallback(new IMethodCallback(){

            @Override
            public String getMethodName() {
                return "getSensorMethods";
            }

            @Override
            public Object execute(IComputerAccess item, Object[] args) throws Exception {
                SensorCard sensorCard = PeripheralSensor.this.getSensorCard();
                HashMap<Integer, String> methods = new HashMap<Integer, String>();
                if (sensorCard == null) {
                    throw new Exception("Card not found");
                }
                ISensor sensor = sensorCard.getSensor();
                String[] customMethods = sensor.getCustomMethods(sensorCard.getTier());
                if (customMethods == null) {
                    return null;
                }
                for (int i = 0; i < customMethods.length; ++i) {
                    methods.put(i + 1, customMethods[i]);
                }
                return methods;
            }
        });
        this.eventManager.registerCallback(new IMethodCallback(){

            @Override
            public String getMethodName() {
                return "sensorCardCall";
            }

            @Override
            public Object execute(IComputerAccess item, Object[] args) throws Exception {
                SensorCard sensorCard = PeripheralSensor.this.getSensorCard();
                if (sensorCard == null) {
                    throw new Exception("Card not found");
                }
                ISensor sensor = sensorCard.getSensor();
                if (args.length < 1 || !(args[0] instanceof String)) {
                    throw new Exception("Invalid arguments. Expected String.");
                }
                String[] sensorMethods = sensor.getCustomMethods(sensorCard.getTier());
                if (sensorMethods == null) {
                    return null;
                }
                int methodId = Arrays.asList(sensorMethods).indexOf(args[0].toString());
                if (methodId < 0) {
                    throw new Exception("Invalid sensor command");
                }
                Object[] arguments = new Object[args.length - 1];
                System.arraycopy(args, 1, arguments, 0, args.length - 1);
                ChunkCoordinates vec = PeripheralSensor.this.env.getLocation();
                return sensor.callCustomMethod(PeripheralSensor.this.env.getWorld(), PeripheralSensor.this.env.getLocation(), methodId, arguments, sensorCard.getTier());
            }
        });
    }

    public void attach(IComputerAccess computer) {
        computer.mount("ocs", (IMount)OpenCCSensors.mount);
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        Object[] params;
        int id = this.eventManager.queueMethodCall(computer, method, arguments);
        while (true) {
            if ((params = context.pullEvent(null)).length < 3 || !(params[1] instanceof Double) || ((Double)params[1]).intValue() != id) {
                continue;
            }
            if (params[0].equals("ocs_success")) {
                return new Object[]{params[2]};
            }
            if (params[0].equals("ocs_error")) break;
        }
        return new Object[]{null, params[2]};
    }

    public void detach(IComputerAccess computer) {
    }

    public String[] getMethodNames() {
        return this.eventManager.getMethodNames();
    }

    @Override
    public ISensorEnvironment getSensorEnvironment() {
        return this.env;
    }

    public String getType() {
        return "sensor";
    }

    @Override
    public boolean isTurtle() {
        return this.isTurtle;
    }

    public void update() {
        this.eventManager.process();
    }

    public SensorCard getSensorCard() {
        if (this.env != null) {
            ItemStack stack = this.env.getSensorCardStack();
            if (stack == null) {
                return null;
            }
            Item card = stack.func_77973_b();
            if (card != null && card instanceof ItemSensorCard) {
                return ((ItemSensorCard)card).getSensorCard(stack);
            }
        }
        return null;
    }

    public boolean equals(IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TileEntity) {
            TileEntity tother = (TileEntity)other;
            ChunkCoordinates location = this.env.getLocation();
            return tother.func_145831_w().equals(this.env.getWorld()) && tother.field_145851_c == location.field_71574_a && tother.field_145848_d == location.field_71572_b && tother.field_145849_e == location.field_71573_c;
        }
        return false;
    }
}

