/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import openccsensors.api.IGaugeSensor;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;
import openccsensors.common.sensor.TileSensor;
import openccsensors.common.util.CoFHUtils;
import openccsensors.common.util.Ic2Utils;
import openccsensors.common.util.Mods;
import openccsensors.common.util.RotaryCraftUtils;

public class MachineSensor
extends TileSensor
implements ISensor,
IRequiresIconLoading,
IGaugeSensor {
    private IIcon icon;
    private String[] gaugeProperties = new String[]{"HeatPercentage", "Progress"};

    @Override
    public String[] getGaugeProperties() {
        return this.gaugeProperties;
    }

    @Override
    public boolean isValidTarget(Object target) {
        return Mods.IC2 && Ic2Utils.isValidMachineTarget(target) || Mods.TE && CoFHUtils.isValidMachineTarget(target) || Mods.RC && RotaryCraftUtils.isValidMachineTarget(target);
    }

    @Override
    public void loadIcon(IIconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:machine");
    }

    @Override
    public HashMap getDetails(World world, Object obj, ChunkCoordinates sensorPos, boolean additional) {
        TileEntity tile = (TileEntity)obj;
        HashMap response = super.getDetails(tile, sensorPos);
        if (Mods.IC2) {
            response.putAll(Ic2Utils.getMachineDetails(world, obj, additional));
        }
        if (Mods.TE) {
            response.putAll(CoFHUtils.getMachineDetails(world, obj, additional));
        }
        if (Mods.RC) {
            response.putAll(RotaryCraftUtils.getMachineDetails(world, obj, additional));
        }
        return response;
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, ChunkCoordinates location, int methodID, Object[] args, ISensorTier tier) throws Exception {
        return null;
    }

    @Override
    public String getName() {
        return "machineCard";
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack((Item)Item.field_150901_e.func_82594_a("redstone"));
    }
}

