/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;
import openccsensors.common.util.EntityUtils;

public class ProximitySensor
implements ISensor,
IRequiresIconLoading {
    public static final int MODE_ALL = 0;
    public static final int MODE_PLAYERS = 1;
    public static final int MODE_OWNER = 2;
    private IIcon icon;

    @Override
    public HashMap getDetails(World world, Object obj, ChunkCoordinates sensorPos, boolean additional) {
        return EntityUtils.livingToMap((EntityLivingBase)obj, sensorPos, additional);
    }

    @Override
    public HashMap getTargets(World world, ChunkCoordinates location, ISensorTier tier) {
        double radius = tier.getMultiplier() * 4.0;
        return EntityUtils.getEntities(world, location, radius, EntityLivingBase.class);
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, ChunkCoordinates location, int methodID, Object[] args, ISensorTier tier) {
        return null;
    }

    @Override
    public String getName() {
        return "proximityCard";
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void loadIcon(IIconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:proximity");
    }

    public double getDistanceToNearestEntity(World world, Vec3 location, int mode, String owner) {
        Class<EntityLivingBase> klazz = EntityLivingBase.class;
        if (mode == 1 || mode == 2) {
            klazz = EntityPlayer.class;
        }
        List list = world.func_72872_a(klazz, AxisAlignedBB.func_72330_a((double)(location.field_72450_a - 16.0), (double)(location.field_72448_b - 16.0), (double)(location.field_72449_c - 16.0), (double)(location.field_72450_a + 16.0), (double)(location.field_72448_b + 16.0), (double)(location.field_72449_c + 16.0)));
        double closestDistance = Double.MAX_VALUE;
        Vec3 livingPos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (EntityLivingBase current : list) {
            if (mode == 2 && !current.func_70005_c_().equals(owner)) continue;
            livingPos.field_72450_a = current.field_70165_t + 0.5;
            livingPos.field_72448_b = current.field_70163_u + 0.5;
            livingPos.field_72449_c = current.field_70161_v + 0.5;
            double distanceTo = location.func_72438_d(livingPos);
            if (!(distanceTo <= 16.0)) continue;
            closestDistance = Math.min(distanceTo, closestDistance);
        }
        return closestDistance;
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack((Block)Block.field_149771_c.func_82594_a("stone_pressure_plate"));
    }
}

