/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import openccsensors.api.IMethodCallback;
import openccsensors.common.util.MethodCallItem;

public class CallbackEventManager {
    private int callId = 0;
    public ConcurrentLinkedQueue<MethodCallItem> callQueue = new ConcurrentLinkedQueue();
    public ArrayList<IMethodCallback> callbacks = new ArrayList();

    public String[] getMethodNames() {
        int len = this.callbacks.size();
        String[] names = new String[len];
        for (int i = 0; i < len; ++i) {
            names[i] = this.callbacks.get(i).getMethodName();
        }
        return names;
    }

    public void registerCallback(IMethodCallback callback) {
        this.callbacks.add(callback);
    }

    public int queueMethodCall(IComputerAccess computer, int method, Object[] arguments) {
        ++this.callId;
        if (this.callId > 1000) {
            this.callId = 0;
        }
        this.callQueue.add(new MethodCallItem(this.callId, computer, method, arguments));
        return this.callId;
    }

    public void process() {
        MethodCallItem item = this.callQueue.poll();
        while (item != null) {
            try {
                IMethodCallback callback = this.callbacks.get(item.getMethodId());
                Object[] response = new Object[]{item.getCallId(), callback.execute(item.getComputer(), item.getArguments())};
                item.getComputer().queueEvent("ocs_success", response);
            }
            catch (Exception e) {
                try {
                    item.getComputer().queueEvent("ocs_error", new Object[]{item.getCallId(), e.getMessage()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            item = this.callQueue.poll();
        }
    }
}

