/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import java.util.HashMap;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CoFHUtils {
    public static boolean isValidPowerTarget(Object target) {
        return target != null && (target instanceof IEnergyHandler || target instanceof IEnergyProvider);
    }

    public static boolean isValidMachineTarget(Object target) {
        return target != null && (target instanceof IEnergyHandler || target instanceof IEnergyProvider);
    }

    public static HashMap getPowerDetails(World world, Object obj, boolean additional) {
        HashMap<String, Number> response = new HashMap<String, Number>();
        if (obj == null || !(obj instanceof IEnergyHandler) && !(obj instanceof IEnergyProvider) || !additional) {
            return response;
        }
        if (obj instanceof IEnergyHandler || obj instanceof IEnergyProvider) {
            int capacity;
            int stored;
            if (obj instanceof IEnergyHandler) {
                IEnergyHandler energyHandler = (IEnergyHandler)obj;
                stored = energyHandler.getEnergyStored(ForgeDirection.UNKNOWN);
                capacity = energyHandler.getMaxEnergyStored(ForgeDirection.UNKNOWN);
            } else if (obj instanceof IEnergyProvider) {
                IEnergyProvider energyProvider = (IEnergyProvider)obj;
                stored = energyProvider.getEnergyStored(ForgeDirection.UNKNOWN);
                capacity = energyProvider.getMaxEnergyStored(ForgeDirection.UNKNOWN);
            } else {
                return response;
            }
            response.put("Stored", stored);
            response.put("Capacity", capacity);
            response.put("StoredPercentage", 0);
            if (capacity > 0) {
                response.put("StoredPercentage", Math.max(Math.min(100.0, 100.0 * (double)stored / (double)capacity), 0.0));
            }
        }
        return response;
    }

    public static HashMap getMachineDetails(World world, Object obj, boolean additional) {
        HashMap<String, Number> response = new HashMap<String, Number>();
        if (obj == null || !(obj instanceof IEnergyHandler) && !(obj instanceof IEnergyProvider) || !additional) {
            return response;
        }
        if (obj instanceof IEnergyHandler || obj instanceof IEnergyProvider) {
            int capacity;
            int stored;
            if (obj instanceof IEnergyHandler) {
                IEnergyHandler energyHandler = (IEnergyHandler)obj;
                stored = energyHandler.getEnergyStored(ForgeDirection.UNKNOWN);
                capacity = energyHandler.getMaxEnergyStored(ForgeDirection.UNKNOWN);
            } else if (obj instanceof IEnergyProvider) {
                IEnergyProvider energyProvider = (IEnergyProvider)obj;
                stored = energyProvider.getEnergyStored(ForgeDirection.UNKNOWN);
                capacity = energyProvider.getMaxEnergyStored(ForgeDirection.UNKNOWN);
            } else {
                return response;
            }
            response.put("Stored", stored);
            response.put("Capacity", capacity);
            response.put("StoredPercentage", 0);
            if (capacity > 0) {
                response.put("StoredPercentage", Math.max(Math.min(100.0, 100.0 * (double)stored / (double)capacity), 0.0));
            }
        }
        return response;
    }
}

