/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import openccsensors.OpenCCSensors;
import openccsensors.common.util.OCSLog;

public class ResourceExtractingUtils {
    private static final void copyFile(File source, File destination) throws IOException {
        FileInputStream inputStream = new FileInputStream(source);
        FileOutputStream outputStream = new FileOutputStream(destination);
        FileChannel sourceChannel = inputStream.getChannel();
        FileChannel targetChannel = outputStream.getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        sourceChannel.close();
        targetChannel.close();
        inputStream.close();
        outputStream.close();
    }

    public static final void copyDirectory(File source, File destination) throws IOException {
        File[] files;
        if (!source.isDirectory()) {
            throw new IllegalArgumentException("Source (" + source.getPath() + ") must be a directory.");
        }
        if (!source.exists()) {
            throw new IllegalArgumentException("Source directory (" + source.getPath() + ") doesn't exist.");
        }
        destination.mkdirs();
        for (File file : files = source.listFiles()) {
            if (file.isDirectory()) {
                ResourceExtractingUtils.copyDirectory(file, new File(destination, file.getName()));
                continue;
            }
            ResourceExtractingUtils.copyFile(file, new File(destination, file.getName()));
        }
    }

    public static final void copy(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            ResourceExtractingUtils.copyDirectory(source, destination);
        } else {
            ResourceExtractingUtils.copyFile(source, destination);
        }
    }

    public static void extractZipToLocation(File zipFile, String sourceFolder, String destFolder) {
        try {
            sourceFolder = sourceFolder.substring(1) + "/";
            File destFile = new File(OpenCCSensors.proxy.getBase(), destFolder);
            String destinationName = destFile.getAbsolutePath();
            byte[] buf = new byte[1024];
            ZipInputStream zipinputstream = null;
            zipinputstream = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                int n;
                String zipentryName = zipentry.getName();
                if (!zipentryName.startsWith(sourceFolder)) {
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                String entryName = destinationName + zipentryName.substring(Math.min(zipentryName.length(), sourceFolder.length() - 1));
                entryName = entryName.replace('/', File.separatorChar);
                entryName = entryName.replace('\\', File.separatorChar);
                File newFile = new File(entryName);
                if (zipentry.isDirectory()) {
                    if (!newFile.mkdirs()) break;
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                FileOutputStream fileoutputstream = new FileOutputStream(entryName);
                while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                    fileoutputstream.write(buf, 0, n);
                }
                fileoutputstream.close();
                zipinputstream.closeEntry();
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        catch (Exception e) {
            OCSLog.warn("Error while extracting Lua files. Peripheral may not automount Lua files! Exception follows.", new Object[0]);
            e.printStackTrace();
        }
    }
}

