/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import java.util.HashMap;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TankUtils {
    public static HashMap fluidHandlerToMap(IFluidHandler container) {
        FluidTankInfo[] tanks = container.getTankInfo(ForgeDirection.UNKNOWN);
        HashMap allTanks = new HashMap();
        int i = 0;
        try {
            if (tanks != null) {
                for (FluidTankInfo tank : tanks) {
                    if (tank == null) continue;
                    HashMap<String, Object> tankMap = new HashMap<String, Object>();
                    tankMap.put("Capacity", tank.capacity);
                    int fluidAmount = 0;
                    tankMap.put("Amount", 0);
                    FluidStack stack = tank.fluid;
                    if (stack != null) {
                        Fluid fluid = stack.getFluid();
                        tankMap.put("Name", FluidRegistry.getFluidName((FluidStack)stack));
                        tankMap.put("RawName", fluid.getUnlocalizedName());
                        fluidAmount = stack.amount;
                        tankMap.put("Luminousity", fluid.getLuminosity());
                        tankMap.put("Temperature", fluid.getTemperature());
                        tankMap.put("Viscosity", fluid.getViscosity());
                        tankMap.put("IsGaseous", fluid.isGaseous());
                    }
                    tankMap.put("Amount", fluidAmount);
                    tankMap.put("PercentFull", (double)fluidAmount * 100.0 / (double)tank.capacity);
                    allTanks.put(++i, tankMap);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return allTanks;
    }
}

