/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery.tileentity;

import com.bymarcin.zettaindustries.mods.battery.AdvancedStorage;
import com.bymarcin.zettaindustries.mods.battery.Battery;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.IMultiblockPart;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockControllerBase;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockValidationException;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.rectangular.RectangularMultiblockControllerBase;
import com.bymarcin.zettaindustries.mods.battery.gui.BigBatteryContainer;
import com.bymarcin.zettaindustries.mods.battery.gui.EnergyUpdatePacket;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityControler;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityPowerTap;
import com.bymarcin.zettaindustries.registry.ZIRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.FluidRegistry;

public class BatteryController
extends RectangularMultiblockControllerBase {
    private Set<TileEntityPowerTap> powerTaps;
    private Set<TileEntityControler> controlers;
    private Set<EntityPlayer> updatePlayers;
    private TileEntityControler controler;
    private short lastUpdate = 0;
    private long lastTickBalance = 0L;
    private long tickBalance = 0L;
    private long electrolyte = 0L;
    private AdvancedStorage storage = new AdvancedStorage(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    int i = 0;

    public BatteryController(World world) {
        super(world);
        this.powerTaps = new HashSet<TileEntityPowerTap>();
        this.controlers = new HashSet<TileEntityControler>();
        this.updatePlayers = new HashSet<EntityPlayer>();
    }

    public Container getContainer(EntityPlayer player) {
        return new BigBatteryContainer(this.controler, player);
    }

    public Set<TileEntityPowerTap> getPowerTaps() {
        return this.powerTaps;
    }

    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.updatePlayers.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    protected void sendIndividualUpdate(EntityPlayer player) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        ZIRegistry.packetHandler.sendTo((IMessage)this.getUpdatePacket(), (EntityPlayerMP)player);
    }

    protected EnergyUpdatePacket getUpdatePacket() {
        return new EnergyUpdatePacket(this.controler, this.storage.getRealEnergyStored(), this.storage.getRealMaxEnergyStored());
    }

    public void onPacket(long capacity, long storage) {
        this.electrolyte = capacity;
        this.getStorage().setCapacity(capacity);
        this.getStorage().setEnergyStored(storage);
    }

    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.updatePlayers.remove(playerToRemove);
    }

    public AdvancedStorage getStorage() {
        return this.storage;
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineAssembled() {
        Iterator<TileEntityControler> iterator = this.controlers.iterator();
        while (iterator.hasNext()) {
            TileEntityControler c;
            this.controler = c = iterator.next();
        }
        this.recalculate();
    }

    public static boolean isSourceFluid(World worldObj, int x, int y, int z) {
        Block block = worldObj.func_147439_a(x, y, z);
        if (block instanceof BlockFluidBase && worldObj.func_72805_g(x, y, z) == 0) {
            return true;
        }
        if (block instanceof BlockFluidClassic && worldObj.func_72805_g(x, y, z) == 0) {
            return true;
        }
        if (block instanceof BlockStaticLiquid && worldObj.func_72805_g(x, y, z) == 0) {
            return true;
        }
        return block instanceof BlockLiquid && worldObj.func_72805_g(x, y, z) == 0;
    }

    public static int checkElectrolyte(World worldObj, int x, int y, int z) {
        Block block = worldObj.func_147439_a(x, y, z);
        if (BatteryController.isSourceFluid(worldObj, x, y, z) && Battery.getElectrolyteList().containsKey(FluidRegistry.lookupFluidForBlock((Block)block))) {
            return Battery.getElectrolyteList().get(FluidRegistry.lookupFluidForBlock((Block)block));
        }
        return 0;
    }

    @Override
    protected void onMachineDisassembled() {
    }

    @Override
    protected void onMachineRestored() {
        this.recalculate();
    }

    public void recalculate() {
        this.electrolyte = 0L;
        for (int x = this.getMinimumCoord().x; x < this.getMaximumCoord().x; ++x) {
            for (int y = this.getMinimumCoord().y; y < this.getMaximumCoord().y; ++y) {
                for (int z = this.getMinimumCoord().z; z < this.getMaximumCoord().z; ++z) {
                    this.electrolyte += (long)BatteryController.checkElectrolyte(this.worldObj, x, y, z);
                }
            }
        }
        this.storage.setCapacity(this.electrolyte);
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.powerTaps.size() == 0) {
            throw new MultiblockValidationException("BigBattery must have power tap");
        }
        if (this.controlers.size() == 0) {
            throw new MultiblockValidationException("BigBattery must have controler");
        }
        if (this.controlers.size() > 1) {
            throw new MultiblockValidationException("BigBattery have too many controlers");
        }
        boolean foundElectrolyte = false;
        block0: for (int x = this.getMinimumCoord().x; x < this.getMaximumCoord().x; ++x) {
            for (int y = this.getMinimumCoord().y; y < this.getMaximumCoord().y; ++y) {
                for (int z = this.getMinimumCoord().z; z < this.getMaximumCoord().z; ++z) {
                    if (BatteryController.checkElectrolyte(this.worldObj, x, y, z) <= 0) continue;
                    foundElectrolyte = true;
                    break block0;
                }
            }
        }
        if (!foundElectrolyte) {
            throw new MultiblockValidationException("BigBattery must have electrolyte");
        }
        super.isMachineWhole();
    }

    @Override
    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        if (material instanceof MaterialLiquid) {
            return;
        }
        String blockName = world.func_147439_a(x, y, z).func_149732_F();
        throw new MultiblockValidationException(String.format("%d, %d, %d - Unrecognized block with ID %s, not valid for the reactor's interior", x, y, z, blockName));
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 36;
    }

    @Override
    protected int getMaximumXSize() {
        return 32;
    }

    @Override
    protected int getMaximumZSize() {
        return 32;
    }

    @Override
    protected int getMaximumYSize() {
        return 32;
    }

    public void modifyLastTickBalance(int energy) {
        this.tickBalance += (long)energy;
    }

    @Override
    protected boolean updateServer() {
        if (this.electrolyte == 0L) {
            return false;
        }
        for (TileEntityPowerTap powerTap : this.powerTaps) {
            powerTap.onTransferEnergy();
        }
        if (this.lastUpdate % 4 == 0) {
            EnergyUpdatePacket packet = this.getUpdatePacket();
            for (EntityPlayer p : this.updatePlayers) {
                ZIRegistry.packetHandler.sendTo((IMessage)packet, (EntityPlayerMP)p);
            }
            this.lastUpdate = 0;
        }
        this.lastUpdate = (short)(this.lastUpdate + 1);
        this.lastTickBalance = this.tickBalance;
        this.tickBalance = 0L;
        return true;
    }

    public long getLastTickBalance() {
        return this.lastTickBalance;
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileEntityPowerTap) {
            this.powerTaps.add((TileEntityPowerTap)newPart);
        }
        if (newPart instanceof TileEntityControler) {
            this.controlers.add((TileEntityControler)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileEntityPowerTap) {
            this.powerTaps.remove((Object)oldPart);
        }
        if (oldPart instanceof TileEntityControler) {
            this.controlers.remove((Object)oldPart);
        }
    }

    @Override
    protected void onAssimilate(MultiblockControllerBase assimilated) {
        BatteryController other = (BatteryController)assimilated;
        this.storage.merge(other.getStorage());
    }

    @Override
    protected void onAssimilated(MultiblockControllerBase assimilator) {
    }

    @Override
    protected void updateClient() {
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74772_a("Electrolyte", this.electrolyte);
        this.storage.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("Electrolyte")) {
            this.electrolyte = data.func_74763_f("Electrolyte");
        }
        this.storage.readFromNBT(data);
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        data.func_74772_a("Electrolyte", this.electrolyte);
        this.storage.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        if (data.func_74764_b("Electrolyte")) {
            this.electrolyte = data.func_74763_f("Electrolyte");
        }
        this.storage.readFromNBT(data);
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.readFromNBT(data);
    }
}

