/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.ecatalogue;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumPostage;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalState;
import forestry.api.mail.PostManager;
import forestry.mail.items.ItemStamps;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.internal.Agent;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class MailmanUpgrade
extends ManagedEnvironment {
    private final Agent robot;

    public MailmanUpgrade(Agent entity) {
        this.robot = entity;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withConnector().withComponent("mailman", Visibility.Neighbors).create());
    }

    public void getTileEntityHost() {
        this.robot.world().func_147438_o((int)this.robot.xPosition(), (int)this.robot.yPosition(), (int)this.robot.zPosition());
    }

    private IMailAddress getRecipientAddress(String name) {
        GameProfile gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(name);
        if (gameProfile == null) {
            gameProfile = new GameProfile(new UUID(0L, 0L), name);
        }
        return PostManager.postRegistry.getMailAddress(gameProfile);
    }

    private ItemStack consumePaper(int slot, boolean simulate) {
        ItemStack paper = this.robot.mainInventory().func_70301_a(slot);
        if (paper != null && paper.func_77973_b().equals(Items.field_151121_aF) && paper.field_77994_a > 0) {
            if (simulate) {
                paper = ItemStack.func_77944_b((ItemStack)paper);
                paper.field_77994_a = 1;
                return paper;
            }
            return this.robot.mainInventory().func_70298_a(slot, 1);
        }
        return null;
    }

    private int getStampValue(int slot) {
        ItemStack stack = this.robot.mainInventory().func_70301_a(slot);
        if (stack != null && stack.func_77973_b() instanceof ItemStamps) {
            ItemStamps stamp = (ItemStamps)stack.func_77973_b();
            return stamp.getPostage(stack).getValue();
        }
        return EnumPostage.P_0.getValue();
    }

    public int getNeededStampCount(int required, int stampValue) {
        if (stampValue > 0) {
            return (int)Math.ceil((double)required / (double)stampValue);
        }
        return -1;
    }

    private boolean consumeStamps(ILetter letter, int stampSlot, boolean simulate) {
        ItemStack stack = this.robot.mainInventory().func_70301_a(stampSlot);
        int stampValue = this.getStampValue(stampSlot);
        if (stampValue != 0 && this.getNeededStampCount(letter.requiredPostage(), stampValue) > 0 && this.getNeededStampCount(letter.requiredPostage(), stampValue) <= stack.field_77994_a) {
            if (simulate) {
                return true;
            }
            letter.addStamps(this.robot.mainInventory().func_70298_a(stampSlot, this.getNeededStampCount(letter.requiredPostage(), stampValue)));
            return true;
        }
        return false;
    }

    public boolean addAtachments(ILetter letter, Arguments args) {
        for (int i = 4; i < args.count(); ++i) {
            if (args.isInteger(i)) {
                int slot = args.checkInteger(i) - 1;
                if (slot >= this.robot.mainInventory().func_70302_i_() || slot < 0 || this.robot.mainInventory().func_70301_a(slot) == null) continue;
                letter.addAttachment(this.robot.mainInventory().func_70298_a(slot, this.robot.mainInventory().func_70301_a((int)slot).field_77994_a));
                continue;
            }
            return false;
        }
        return true;
    }

    public Object[] error(String message) {
        return new Object[]{false, message};
    }

    @Callback(doc="function():table")
    public Object[] getAllTrades(Context context, Arguments args) {
        IPostOffice postOffice = PostManager.postRegistry.getPostOffice(this.robot.world());
        return new Object[]{postOffice.getActiveTradeStations(this.robot.world()).values()};
    }

    @Callback(doc="function(address:string, message:string, stampSlot:number, paperSlot:number, attachmentSlots:number...):boolean")
    public Object[] sendMail(Context ctx, Arguments args) {
        IMailAddress recipient = this.getRecipientAddress(args.checkString(0));
        IMailAddress sender = PostManager.postRegistry.getMailAddress(this.robot.name());
        String message = args.checkString(1);
        int stampSlot = args.checkInteger(2) - 1;
        int paperSlot = args.checkInteger(3) - 1;
        if (recipient == null || !recipient.isValid()) {
            return this.error("Wrong recipient address");
        }
        if (!(sender.isValid() && PostManager.postRegistry.isValidTradeAddress(this.robot.world(), sender) && PostManager.postRegistry.isAvailableTradeAddress(this.robot.world(), sender))) {
            return this.error("Name reserved. Change robot name.");
        }
        if (message.length() > 128) {
            return this.error("Message is too long");
        }
        if (stampSlot < 0 || stampSlot > this.robot.mainInventory().func_70302_i_()) {
            return this.error("Wrong stamp slot.");
        }
        if (paperSlot < 0 || paperSlot > this.robot.mainInventory().func_70302_i_()) {
            return this.error("Wrong paper slot.");
        }
        ILetter letter = PostManager.postRegistry.createLetter(sender, recipient);
        letter.setText(message);
        if (args.count() > letter.func_70302_i_()) {
            return this.error("Too much attachments.");
        }
        if (this.consumePaper(paperSlot, true) == null) {
            return this.error("Wrong item or slot paper is empty.");
        }
        if (!this.consumeStamps(letter, stampSlot, true)) {
            return this.error("Wrong item, insufficient stamp value or too small amount.");
        }
        if (!this.addAtachments(letter, args)) {
            for (ItemStack s : letter.getAttachments()) {
                this.giveBack(s);
            }
            return this.error("Wrong attachment slots.");
        }
        this.consumeStamps(letter, stampSlot, false);
        ItemStack paperCache = this.consumePaper(paperSlot, false);
        if (paperCache == null) {
            for (ItemStack stmp : letter.getPostage()) {
                this.giveBack(stmp);
            }
            for (ItemStack s : letter.getAttachments()) {
                this.giveBack(s);
            }
            return this.error("Wrong item or slot paper is empty.");
        }
        IPostalState state = PostManager.postRegistry.getPostOffice(this.robot.world()).lodgeLetter(this.robot.world(), PostManager.postRegistry.createLetterStack(letter), true);
        if (!state.isOk()) {
            this.giveBack(paperCache);
            for (ItemStack s : letter.getAttachments()) {
                this.giveBack(s);
            }
            for (ItemStack stmp : letter.getPostage()) {
                this.giveBack(stmp);
            }
        }
        return new Object[]{state.isOk(), state.getIdentifier()};
    }

    private void giveBack(ItemStack stack) {
        if (stack != null && !this.mergeItemStack(stack, 0, this.robot.mainInventory().func_70302_i_(), false)) {
            this.robot.world().func_72838_d((Entity)new EntityItem(this.robot.world(), this.robot.xPosition(), this.robot.yPosition() + 1.0, this.robot.zPosition(), stack));
        }
    }

    private boolean mergeItemStack(ItemStack stack, int start, int end, boolean backwards) {
        int l;
        ItemStack itemstack1;
        int k;
        boolean flag1 = false;
        int n = k = backwards ? end - 1 : start;
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!backwards && k < end || backwards && k >= start)) {
                itemstack1 = this.robot.mainInventory().func_70301_a(k);
                if (!this.robot.mainInventory().func_94041_b(k, stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 != null && itemstack1.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1)) {
                    l = itemstack1.field_77994_a + stack.field_77994_a;
                    if (l <= stack.func_77976_d() && l <= this.robot.mainInventory().func_70297_j_()) {
                        stack.field_77994_a = 0;
                        itemstack1.field_77994_a = l;
                        this.robot.mainInventory().func_70296_d();
                        flag1 = true;
                    } else if (itemstack1.field_77994_a < stack.func_77976_d() && l < this.robot.mainInventory().func_70297_j_()) {
                        stack.field_77994_a -= stack.func_77976_d() - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = stack.func_77976_d();
                        this.robot.mainInventory().func_70296_d();
                        flag1 = true;
                    }
                }
                k += backwards ? -1 : 1;
            }
        }
        if (stack.field_77994_a > 0) {
            int n2 = k = backwards ? end - 1 : start;
            while (!backwards && k < end || backwards && k >= start) {
                itemstack1 = this.robot.mainInventory().func_70301_a(k);
                if (!this.robot.mainInventory().func_94041_b(k, stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 == null) {
                    l = stack.field_77994_a;
                    if (l <= this.robot.mainInventory().func_70297_j_()) {
                        this.robot.mainInventory().func_70299_a(k, stack.func_77946_l());
                        stack.field_77994_a = 0;
                        this.robot.mainInventory().func_70296_d();
                        flag1 = true;
                        break;
                    }
                    this.robot.mainInventory().func_70299_a(k, new ItemStack(stack.func_77973_b(), this.robot.mainInventory().func_70297_j_(), stack.func_77960_j()));
                    stack.field_77994_a -= this.robot.mainInventory().func_70297_j_();
                    this.robot.mainInventory().func_70296_d();
                    flag1 = true;
                }
                k += backwards ? -1 : 1;
            }
        }
        return flag1;
    }
}

