/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.ocwires.item;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.IWireCoil;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorLV;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.bymarcin.zettaindustries.basic.BasicItem;
import com.bymarcin.zettaindustries.mods.ocwires.TelecommunicationWireType;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemTelecommunicationWire
extends BasicItem
implements IWireCoil {
    public ItemTelecommunicationWire() {
        super("TelecommunicationWire");
        this.func_77625_d(64);
        this.setNoRepair();
    }

    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("zettaindustries:coil_telecommunication");
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        int[] link;
        list.add(StatCollector.func_74838_a((String)"tooltip.coil.info0"));
        list.add(StatCollector.func_74838_a((String)"tooltip.coil.info1"));
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("linkingPos") && (link = stack.func_77978_p().func_74759_k("linkingPos")) != null && link.length > 3) {
            list.add(StatCollector.func_74837_a((String)"tooltip.coil.attachedTo", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            if (!((IImmersiveConnectable)tileEntity).canConnectCable(this.getWireType(stack), target) || world.func_147438_o(x, y, z) instanceof TileEntityConnectorLV) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongCable", new Object[0]));
                return false;
            }
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"linkingPos")) {
                ItemNBTHelper.setIntArray((ItemStack)stack, (String)"linkingPos", (int[])new int[]{world.field_73011_w.field_76574_g, x, y, z});
                target.writeToNBT(stack.func_77978_p());
            } else {
                WireType type = this.getWireType(stack);
                int[] pos = ItemNBTHelper.getIntArray((ItemStack)stack, (String)"linkingPos");
                TileEntity tileEntityLinkingPos = world.func_147438_o(pos[1], pos[2], pos[3]);
                int distance = (int)Math.ceil(Math.sqrt((pos[1] - x) * (pos[1] - x) + (pos[2] - y) * (pos[2] - y) + (pos[3] - z) * (pos[3] - z)));
                if (pos[0] != world.field_73011_w.field_76574_g) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongDimension", new Object[0]));
                } else if (pos[1] == x && pos[2] == y && pos[3] == z) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.sameConnection", new Object[0]));
                } else if (distance > type.getMaxLength()) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.tooFar", new Object[0]));
                } else if (!(tileEntityLinkingPos instanceof IImmersiveConnectable)) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.invalidPoint", new Object[0]));
                } else {
                    IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                    IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                    boolean connectionExists = false;
                    Set outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC((Object)nodeHere));
                    if (outputs != null) {
                        for (ImmersiveNetHandler.Connection con : outputs) {
                            if (!con.end.equals((Object)Utils.toCC((Object)nodeLink))) continue;
                            connectionExists = true;
                        }
                    }
                    if (connectionExists) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.connectionExists", new Object[0]));
                    } else {
                        Vec3 rtOff1;
                        Vec3 rtOff0 = nodeHere.getRaytraceOffset(nodeLink).func_72441_c((double)x, (double)y, (double)z);
                        boolean canSee = Utils.canBlocksSeeOther((World)world, (ChunkCoordinates)new ChunkCoordinates(x, y, z), (ChunkCoordinates)new ChunkCoordinates(pos[1], pos[2], pos[3]), (Vec3)rtOff0, (Vec3)(rtOff1 = nodeLink.getRaytraceOffset(nodeHere).func_72441_c((double)pos[1], (double)pos[2], (double)pos[3])));
                        if (canSee) {
                            TargetingInfo targetLink = TargetingInfo.readFromNBT((NBTTagCompound)stack.func_77978_p());
                            ImmersiveNetHandler.INSTANCE.addConnection(world, Utils.toCC((Object)nodeHere), Utils.toCC((Object)nodeLink), distance, type);
                            nodeHere.connectCable(type, target);
                            nodeLink.connectCable(type, targetLink);
                            IESaveData.setDirty((int)world.field_73011_w.field_76574_g);
                            player.func_71029_a((StatBase)IEAchievements.connectWire);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                            ((TileEntity)nodeHere).func_70296_d();
                            world.func_147471_g(x, y, z);
                            ((TileEntity)nodeLink).func_70296_d();
                            world.func_147471_g(pos[1], pos[2], pos[3]);
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.cantSee", new Object[0]));
                        }
                    }
                }
                ItemNBTHelper.remove((ItemStack)stack, (String)"linkingPos");
                ItemNBTHelper.remove((ItemStack)stack, (String)"side");
                ItemNBTHelper.remove((ItemStack)stack, (String)"hitX");
                ItemNBTHelper.remove((ItemStack)stack, (String)"hitY");
                ItemNBTHelper.remove((ItemStack)stack, (String)"hitZ");
            }
            return true;
        }
        return false;
    }

    public WireType getWireType(ItemStack arg) {
        return TelecommunicationWireType.TELECOMMUNICATION;
    }
}

